/*
 * Decompiled with CFR 0.152.
 */
package main;

import componentes.Situation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import main.MakeFile;
import main.ReadXMCDA;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.decisionDeck.x2012.xmcda220.XMCDADocument;
import utils.FuzzyToNumerical;

public class Main {
    private static final String OUTF2N = "/alternativesValues.xml";
    private static final String OUTMESSAGEFILE = "/messages.xml";
    private static boolean error = false;
    private static String input = null;
    private static String output = null;
    private static XMCDADocument docMessage;
    private static FuzzyToNumerical F2N;

    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        try {
            Main.parseComannd(args);
        }
        catch (ParseException e) {
            docMessage = MakeFile.addMessageToLog(docMessage, "Parse fail", true);
        }
        if (input != null && output != null) {
            try {
                try {
                    docMessage = MakeFile.makeMessageDocument();
                    File dir = new File(input);
                    File[] listFile = dir.listFiles();
                    Situation situation = null;
                    if (listFile.length < 2) {
                        docMessage = MakeFile.addMessageToLog(docMessage, "No files in the directory specified", true);
                    } else {
                        ArrayList<XmlError> errorList = new ArrayList<XmlError>();
                        situation = ReadXMCDA.readData(listFile, errorList);
                        if (errorList.size() > 0 || error) {
                            int i = 0;
                            while (i < errorList.size()) {
                                XmlError xmlerror = errorList.get(i);
                                docMessage = MakeFile.addMessageToLog(docMessage, "Error: " + xmlerror.getMessage(), true);
                                docMessage = MakeFile.addMessageToLog(docMessage, "Locate Error: " + xmlerror.getCursorLocation().xmlText(), true);
                                ++i;
                            }
                        } else if (situation.validationSituation()) {
                            F2N = new FuzzyToNumerical(situation, FuzzyToNumerical.Type.ORDINAL);
                            docMessage = MakeFile.addMessageToLog(docMessage, "OK", false);
                            XMCDADocument docResults = MakeFile.makeDocumentResults(F2N.calculated(), situation);
                            MakeFile.createDocument(String.valueOf(output) + OUTF2N, docResults);
                        } else {
                            docMessage = MakeFile.addMessageToLog(docMessage, "Fail information:\n" + situation.getErrorText(), true);
                        }
                    }
                }
                catch (NullPointerException ex) {
                    docMessage = MakeFile.addMessageToLog(docMessage, "The pathname argument is null", true);
                    MakeFile.createDocument(String.valueOf(output) + OUTMESSAGEFILE, docMessage);
                }
                catch (XmlException e) {
                    for (Object error : e.getErrors()) {
                        XmlError xmlError = (XmlError)error;
                        docMessage = MakeFile.addMessageToLog(docMessage, xmlError.getMessage(), true);
                        docMessage = MakeFile.addMessageToLog(docMessage, xmlError.getCursorLocation().xmlText(), true);
                    }
                    docMessage = MakeFile.addMessageToLog(docMessage, "Error processing, parsing, or compiling XML", true);
                }
                catch (IOException e) {
                    docMessage = MakeFile.addMessageToLog(docMessage, "File fail", true);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    MakeFile.createDocument(String.valueOf(output) + OUTMESSAGEFILE, docMessage);
                }
            }
            finally {
                MakeFile.createDocument(String.valueOf(output) + OUTMESSAGEFILE, docMessage);
            }
        }
    }

    private static void parseComannd(String[] args) throws ParseException {
        BasicParser parser = new BasicParser();
        Options options = new Options();
        options.addOption("i", true, "Input folder");
        options.addOption("o", true, "Output folder");
        options.addOption("h", "help", false, "Show help");
        CommandLine cmdLine = parser.parse(options, args);
        if (cmdLine.hasOption("h")) {
            new HelpFormatter().printHelp(FuzzyToNumerical.class.getCanonicalName(), options);
        } else {
            input = cmdLine.getOptionValue("i");
            if (input == null) {
                error = true;
                docMessage = MakeFile.addMessageToLog(docMessage, "Fail input folder", true);
            }
            if ((output = cmdLine.getOptionValue("o")) == null) {
                error = true;
                docMessage = MakeFile.addMessageToLog(docMessage, "Fail output folder", true);
            }
        }
    }
}

