/*
 * Decompiled with CFR 0.152.
 */
package componentes;

public class Label
implements Comparable<Label> {
    private String id;
    private String name;
    private int index;
    private float[] points;

    public Label(String id, float a, float b, float c, float d, int index) {
        this.id = id;
        this.name = null;
        this.index = index;
        this.points = new float[4];
        this.points[0] = a;
        this.points[1] = b;
        this.points[2] = c;
        this.points[3] = d;
    }

    public Label(String id, String name, float a, float b, float c, float d, int index) {
        this.name = name;
        this.id = id;
        this.index = index;
        this.points = new float[4];
        this.points[0] = a;
        this.points[1] = b;
        this.points[2] = c;
        this.points[3] = d;
    }

    public Label(String id, String name, int index, float[] points) {
        this.name = name;
        this.id = id;
        this.index = index;
        this.points = (float[])points.clone();
    }

    public Label(String id, int index, float[] points) {
        this.name = null;
        this.id = id;
        this.index = index;
        this.points = (float[])points.clone();
    }

    public float[] getPoints() {
        return this.points;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public float[] getCoG() {
        float[] CoG = new float[2];
        float a1 = this.points[0];
        float a2 = this.points[1];
        float a3 = this.points[2];
        float a4 = this.points[3];
        CoG[1] = a1 != a4 ? 0.16666667f * ((a3 - a2) / (a4 - a1) + 2.0f) : 0.5f;
        CoG[0] = (CoG[1] * (a3 + a2) + (a4 + a1) * (1.0f - CoG[1])) / 2.0f + 0.001f;
        return CoG;
    }

    public float getCOM() {
        float COM = (this.points[2] - this.points[3]) / 2.0f;
        return COM;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Label)) {
            return false;
        }
        Label other = (Label)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Alternative");
        str.append(" [");
        str.append(this.id);
        if (this.name != null) {
            str.append(", '" + this.name + "'");
        }
        str.append(" Index: " + this.index);
        str.append(" (");
        str.append(String.valueOf(this.points[0]) + ", ");
        str.append(String.valueOf(this.points[1]) + ", ");
        str.append(String.valueOf(this.points[2]) + ", ");
        str.append(this.points[3]);
        str.append(") ]");
        return str.toString();
    }

    @Override
    public int compareTo(Label o) {
        if (this.index < o.getIndex()) {
            return 1;
        }
        if (this.index > o.getIndex()) {
            return -1;
        }
        return 0;
    }
}

