/*
 * Decompiled with CFR 0.152.
 */
package componentes;

import componentes.Alternativa;
import componentes.Alternativas;
import componentes.Criterio;
import componentes.Criterios;
import componentes.FuzzyVariable;
import componentes.Label;
import componentes.Matrix;
import componentes.Par;
import componentes.Weight;
import componentes.Weights;

public class Situation {
    FuzzyVariable fuzzyVariable;
    Weights weights;
    private Alternativas alts = new Alternativas();
    private Criterios crits = new Criterios();
    private Matrix<Par<Alternativa, Criterio>, String> matrixEval = new Matrix();

    public Situation() {
        this.fuzzyVariable = new FuzzyVariable();
        this.weights = new Weights();
    }

    public void addFuzzyNumbers(Label label) {
        this.fuzzyVariable.setLabel(label);
    }

    public boolean addAlternative(Alternativa alt) {
        return this.alts.addAlternative(alt);
    }

    public boolean addCriterion(Criterio criterion) {
        return this.crits.addCriterion(criterion);
    }

    public void putEvaluation(Alternativa row, Criterio column, String value) {
        this.matrixEval.setValue(new Par<Alternativa, Criterio>(row, column), value);
    }

    public boolean removeAlternative(Alternativa alt) {
        return this.alts.removeAlternative(alt);
    }

    public boolean removeCriterion(Criterio crit) {
        return this.crits.removeCriterion(crit);
    }

    public FuzzyVariable getFuzzyVariable() {
        return this.fuzzyVariable;
    }

    public Alternativas getAlternatives() {
        return this.alts;
    }

    public Criterios getCriteria() {
        return this.crits;
    }

    public Weights getWeights() {
        return this.weights;
    }

    public int getAlternativesCount() {
        return this.alts.size();
    }

    public int getCriteriaCount() {
        return this.crits.size();
    }

    public String getEvaluation(Alternativa row, Criterio column) {
        return this.matrixEval.getValue(new Par<Alternativa, Criterio>(row, column));
    }

    public Matrix<Par<Alternativa, Criterio>, String> getEvaluationMatrix() {
        return this.matrixEval;
    }

    public int getEvaluationsCount() {
        return this.matrixEval.size();
    }

    public void setFuzzyVariable(FuzzyVariable fuzzyVariable) {
        this.fuzzyVariable = fuzzyVariable;
    }

    public void setCriteria(Criterios crits) {
        if (crits == null) {
            throw new NullPointerException("" + crits);
        }
        this.crits = crits;
    }

    public void setAlternatives(Alternativas alts) {
        if (alts == null) {
            throw new NullPointerException("" + alts);
        }
        this.alts = alts;
    }

    public void setEvaluationMatrix(Matrix<Par<Alternativa, Criterio>, String> matrixEval) {
        if (matrixEval == null) {
            throw new NullPointerException("" + matrixEval);
        }
        this.matrixEval = matrixEval;
    }

    public void setWeights(Weights weights) {
        this.weights = weights;
    }

    public boolean existThisAlternative(String alternative) {
        Label[] labelArray = this.fuzzyVariable.getAllLabel();
        int n = labelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Label label = labelArray[n2];
            if (label.getId().compareToIgnoreCase(alternative) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean validationSituation() {
        if (!this.weights.isNormalized()) {
            return false;
        }
        if (this.crits.size() * this.alts.size() != this.matrixEval.size()) {
            return false;
        }
        if (this.crits.size() != this.weights.size()) {
            return false;
        }
        Alternativa[] alternativaArray = this.alts.getAllAlternative();
        int n = alternativaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Alternativa alter = alternativaArray[n2];
            Criterio[] criterioArray = this.crits.getAllCriterion();
            int n3 = criterioArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Criterio crit = criterioArray[n4];
                if (this.matrixEval.getValue(new Par<Alternativa, Criterio>(alter, crit)) == null) {
                    return false;
                }
                if (!this.existThisAlternative(this.matrixEval.getValue(new Par<Alternativa, Criterio>(alter, crit)))) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public String getErrorText() {
        String aux = "";
        Alternativa[] alternativaArray = this.alts.getAllAlternative();
        int n = alternativaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Alternativa alter = alternativaArray[n2];
            Criterio[] criterioArray = this.crits.getAllCriterion();
            int n3 = criterioArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Criterio crit = criterioArray[n4];
                if (this.matrixEval.getValue(new Par<Alternativa, Criterio>(alter, crit)) == null) {
                    aux = String.valueOf(aux) + "Alternative: " + alter.getId() + ", Criterion: " + crit.getId() + ": It's null\n";
                } else if (!this.existThisAlternative(this.matrixEval.getValue(new Par<Alternativa, Criterio>(alter, crit)))) {
                    aux = String.valueOf(aux) + "Alternative: " + alter.getId() + ", Criterion: " + crit.getId() + ": No exist this label\n";
                }
                ++n4;
            }
            ++n2;
        }
        if (!this.weights.isNormalized()) {
            aux = String.valueOf(aux) + "The weights aren't Normalized\n";
        }
        if (this.crits.size() * this.alts.size() != this.matrixEval.size()) {
            aux = String.valueOf(aux) + "Check the number of alternatives and criteria based on the performanceTable\n";
        }
        if (this.crits.size() != this.weights.size()) {
            aux = String.valueOf(aux) + "The number of weights and the number of criteria are different\n";
        }
        return aux;
    }

    public void generateWeights(Weight weight) {
        this.weights.addWeight(weight);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Situation [");
        builder.append(String.valueOf(this.fuzzyVariable.size()) + " " + (this.fuzzyVariable.size() == 1 ? "fuzzy" : "fuzzys") + ", ");
        builder.append(String.valueOf(this.alts.size()) + " " + (this.alts.size() == 1 ? "alt" : "alts") + ", ");
        builder.append(String.valueOf(this.crits.size()) + " " + (this.crits.size() == 1 ? "crit" : "crits") + ", ");
        builder.append(String.valueOf(this.matrixEval.size()) + " " + (this.matrixEval.size() == 1 ? "eval" : "evals") + ", ");
        builder.append(String.valueOf(this.weights.size()) + " " + (this.weights.size() == 1 ? "weight" : "weights"));
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alts == null ? 0 : this.alts.hashCode());
        result = 31 * result + (this.crits == null ? 0 : this.crits.hashCode());
        result = 31 * result + (this.fuzzyVariable == null ? 0 : this.fuzzyVariable.hashCode());
        result = 31 * result + (this.matrixEval == null ? 0 : this.matrixEval.hashCode());
        result = 31 * result + (this.weights == null ? 0 : this.weights.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Situation)) {
            return false;
        }
        Situation other = (Situation)obj;
        if (this.alts == null ? other.alts != null : !this.alts.equals(other.alts)) {
            return false;
        }
        if (this.crits == null ? other.crits != null : !this.crits.equals(other.crits)) {
            return false;
        }
        if (this.fuzzyVariable == null ? other.fuzzyVariable != null : !this.fuzzyVariable.equals(other.fuzzyVariable)) {
            return false;
        }
        if (this.matrixEval == null ? other.matrixEval != null : !this.matrixEval.equals(other.matrixEval)) {
            return false;
        }
        return !(this.weights == null ? other.weights != null : !this.weights.equals(other.weights));
    }
}

