/*
 * Decompiled with CFR 0.152.
 */
package owa;

import componentes.Alternativa;
import componentes.Criterio;
import componentes.Situation;
import java.util.HashMap;

public class owa {
    private Situation situation;
    private HashMap<Alternativa, Double> res;

    public owa(Situation situation) {
        if (situation == null) {
            throw new IllegalArgumentException("situation is null");
        }
        if (situation.getAlternativesCount() * situation.getCriteriaCount() != situation.getEvaluationsCount()) {
            throw new IllegalArgumentException("Fail to data " + situation.toString());
        }
        if (situation.getCriteriaCount() != situation.getWeights().size()) {
            throw new IllegalArgumentException("Fail to data " + situation.toString());
        }
        this.res = new HashMap();
        this.situation = situation;
    }

    private double[] descending(double[] dades) {
        int numValues = dades.length;
        int i = 0;
        while (i < numValues) {
            int j = i + 1;
            while (j < numValues) {
                if (dades[j] > dades[i]) {
                    double aux = dades[j];
                    dades[j] = dades[i];
                    dades[i] = aux;
                }
                ++j;
            }
            ++i;
        }
        return (double[])dades.clone();
    }

    private double[] preparaDades(Alternativa alter) {
        int i = 0;
        double[] dades = new double[this.situation.getCriteria().size()];
        Criterio[] criterioArray = this.situation.getCriteria().getAllCriterion();
        int n = criterioArray.length;
        int n2 = 0;
        while (n2 < n) {
            Criterio criton = criterioArray[n2];
            dades[i++] = this.situation.getEvaluation(alter, criton);
            ++n2;
        }
        return dades;
    }

    private double escProd(double[] w, double[] dades) {
        int num_values = w.length;
        int i = 0;
        double r = 0.0;
        while (i < num_values) {
            r += w[i] * dades[i];
            ++i;
        }
        return r;
    }

    public HashMap<Alternativa, Double> calculated() {
        double[] dades = new double[this.situation.getCriteriaCount()];
        Alternativa[] alternativaArray = this.situation.getAlternatives().getAllAlternative();
        int n = alternativaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Alternativa alter = alternativaArray[n2];
            dades = this.descending(this.preparaDades(alter));
            this.res.put(alter, this.escProd(this.situation.getWeights().getWeightsValues(), dades));
            ++n2;
        }
        return this.res;
    }
}

