/*
 * Decompiled with CFR 0.152.
 */
package main;

import componentes.Alternativa;
import componentes.Situation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.xmlbeans.XmlCursor;
import org.decisionDeck.x2009.xmcda210.AlternativeValue;
import org.decisionDeck.x2009.xmcda210.AlternativesValues;
import org.decisionDeck.x2009.xmcda210.MethodMessages;
import org.decisionDeck.x2009.xmcda210.XMCDADocument;

public class MakeFile {
    public static void createDocument(String file, XMCDADocument doc) {
        File xmlfile = new File(file);
        try {
            if (!xmlfile.exists()) {
                xmlfile.createNewFile();
                xmlfile.setWritable(true);
            }
            doc.save(xmlfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\nXML Instance Document saved at: " + xmlfile.getPath());
    }

    public static XMCDADocument makeDocumentResults(HashMap<Alternativa, Double> resultat, Situation situation) {
        XMCDADocument doc = XMCDADocument.Factory.newInstance();
        XMCDADocument.XMCDA xmcda = doc.addNewXMCDA();
        AlternativesValues alternativesvalues = xmcda.addNewAlternativesValues();
        Alternativa[] alternativaArray = situation.getAlternatives().getAllAlternative();
        int n = alternativaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Alternativa alter = alternativaArray[n2];
            if (alter.isActive()) {
                AlternativeValue alternativevalue = alternativesvalues.addNewAlternativeValue();
                alternativevalue.setAlternativeID(alter.getId());
                alternativevalue.addNewValue().setReal(resultat.get(alter).floatValue());
            }
            ++n2;
        }
        return doc;
    }

    public static XMCDADocument addMessageToLog(XMCDADocument doc, String msg, boolean isError) {
        XMCDADocument.XMCDA xmcda = doc.getXMCDA();
        XmlCursor orderCursor = xmcda.newCursor();
        orderCursor.toChild("methodMessages");
        MethodMessages methodmessages = (MethodMessages)orderCursor.getObject();
        if (isError) {
            methodmessages.addNewErrorMessage().setText(msg);
        } else {
            methodmessages.addNewLogMessage().setText(msg);
        }
        return doc;
    }

    public static XMCDADocument makeMessageDocument() {
        XMCDADocument doc = XMCDADocument.Factory.newInstance();
        XMCDADocument.XMCDA xmcda = doc.addNewXMCDA();
        xmcda.addNewMethodMessages();
        return doc;
    }
}

