/*
 * Decompiled with CFR 0.152.
 */
package componentes;

import componentes.Alternativa;
import componentes.Alternativas;
import componentes.Criterio;
import componentes.Criterios;
import componentes.Matrix;
import componentes.Par;
import componentes.Pesos;

public class Situation {
    private Alternativas alts = new Alternativas();
    private Criterios crits = new Criterios();
    private Pesos weights = new Pesos();
    private Matrix<Par<Alternativa, Criterio>, Double> matrixEval = new Matrix();

    public boolean addAlternative(Alternativa alt) {
        return this.alts.addAlternative(alt);
    }

    public boolean addCriterion(Criterio criterion) {
        return this.crits.addCriterion(criterion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Situation other = (Situation)obj;
        if (!this.alts.equals(other.alts)) {
            return false;
        }
        if (!this.crits.equals(other.crits)) {
            return false;
        }
        if (!this.matrixEval.equals(other.matrixEval)) {
            return false;
        }
        return this.weights.equals(other.weights);
    }

    public Alternativas getAlternatives() {
        return this.alts;
    }

    public Criterios getCriteria() {
        return this.crits;
    }

    public int getAlternativesCount() {
        return this.alts.size();
    }

    public int getCriteriaCount() {
        return this.crits.size();
    }

    public Double getEvaluation(Alternativa row, Criterio column) {
        return this.matrixEval.getValue(new Par<Alternativa, Criterio>(row, column));
    }

    public Matrix<Par<Alternativa, Criterio>, Double> getEvaluationMatrix() {
        return this.matrixEval;
    }

    public int getEvaluationsCount() {
        return this.matrixEval.size();
    }

    public Pesos getWeights() {
        return this.weights;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.alts.hashCode();
        result = prime * result + this.crits.hashCode();
        result = prime * result + this.matrixEval.hashCode();
        result = prime * result + this.weights.hashCode();
        return result;
    }

    public boolean isEvaluationComplete() {
        return this.matrixEval.size() == this.alts.size() * this.crits.size();
    }

    public void putEvaluation(Alternativa row, Criterio column, double value) {
        this.matrixEval.setValue(new Par<Alternativa, Criterio>(row, column), value);
    }

    public boolean removeAlternative(Alternativa alt) {
        return this.alts.removeAlternative(alt);
    }

    public boolean removeCriterion(Criterio crit) {
        return this.crits.removeCriterion(crit);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Situation [");
        builder.append(String.valueOf(this.alts.size()) + " " + (this.alts.size() == 1 ? "alt" : "alts") + ", ");
        builder.append(String.valueOf(this.crits.size()) + " " + (this.crits.size() == 1 ? "crit" : "crits") + ", ");
        builder.append(String.valueOf(this.matrixEval.size()) + " " + (this.matrixEval.size() == 1 ? "eval" : "evals") + ", ");
        builder.append(String.valueOf(this.weights.size()) + " " + (this.weights.size() == 1 ? "weight" : "weights"));
        builder.append("]");
        return builder.toString();
    }

    public void setCriteria(Criterios crits) {
        if (crits == null) {
            throw new NullPointerException("" + crits);
        }
        this.crits = crits;
    }

    public void setAlternatives(Alternativas alts) {
        if (alts == null) {
            throw new NullPointerException("" + alts);
        }
        this.alts = alts;
    }

    public void setWeights(Pesos weights) {
        if (weights == null) {
            throw new NullPointerException("" + weights);
        }
        this.weights = weights;
    }

    public Pesos getCoalitions() {
        return this.weights;
    }

    public void setEvaluationMatrix(Matrix<Par<Alternativa, Criterio>, Double> matrixEval) {
        if (matrixEval == null) {
            throw new NullPointerException("" + matrixEval);
        }
        this.matrixEval = matrixEval;
    }

    public boolean validationSituation() {
        if (!this.weights.isNormalized()) {
            return false;
        }
        if (this.crits.size() * this.alts.size() != this.matrixEval.size()) {
            return false;
        }
        if (this.crits.size() != this.weights.size()) {
            return false;
        }
        Alternativa[] alternativaArray = this.alts.getAllAlternative();
        int n = alternativaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Alternativa alter = alternativaArray[n2];
            Criterio[] criterioArray = this.crits.getAllCriterion();
            int n3 = criterioArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Criterio crit = criterioArray[n4];
                if (this.matrixEval.getValue(new Par<Alternativa, Criterio>(alter, crit)) == null) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public String getErrorText() {
        String aux = "";
        Alternativa[] alternativaArray = this.alts.getAllAlternative();
        int n = alternativaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Alternativa alter = alternativaArray[n2];
            Criterio[] criterioArray = this.crits.getAllCriterion();
            int n3 = criterioArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Criterio crit = criterioArray[n4];
                if (this.matrixEval.getValue(new Par<Alternativa, Criterio>(alter, crit)) == null) {
                    aux = String.valueOf(aux) + "Alternative: " + alter.getId() + ", Criterion: " + crit.getId() + "\n";
                }
                ++n4;
            }
            ++n2;
        }
        if (!this.weights.isNormalized()) {
            aux = String.valueOf(aux) + "The weights aren't Normalized\n";
        }
        if (this.crits.size() * this.alts.size() != this.matrixEval.size()) {
            aux = String.valueOf(aux) + "Check the number of alternatives and criteria based on the performanceTable\n";
        }
        if (this.crits.size() != this.weights.size()) {
            aux = String.valueOf(aux) + "The number of weights and the number of criteria are different\n";
        }
        return aux;
    }
}

