/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import componentes.FuzzyVariable;
import componentes.Label;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Fuzziness {
    Label[] labels;

    public Fuzziness(FuzzyVariable fuzzyVar) {
        this.labels = fuzzyVar.getAllLabel();
    }

    public Fuzziness(Label[] labels) {
        this.labels = labels;
    }

    public LinkedHashMap<Label, Double> calculated() throws Exception {
        if (this.labels.length > 0 && (this.labels[0].getPoints()[0] != 0.0f || this.labels[this.labels.length - 1].getPoints()[3] != 1.0f)) {
            throw new Exception("Required range for fuzzy variable: [0...1]");
        }
        LinkedHashMap<Label, Double> results = new LinkedHashMap<Label, Double>();
        int i = 0;
        while (i < this.labels.length) {
            results.put(this.labels[i], this.computeFuzziness(this.labels[i]));
            ++i;
        }
        return results;
    }

    private double computeFuzziness(Label l) {
        double h = l.getHeight();
        float[] points = l.getPoints();
        double area = points[1] > points[0] ? (double)(points[1] - points[0]) * h / 2.0 : 0.0;
        BigDecimal bigVal = BigDecimal.valueOf(area += points[3] > points[2] ? (double)(points[3] - points[2]) * h / 2.0 : 0.0);
        bigVal = bigVal.setScale(2, 6);
        return bigVal.doubleValue();
    }

    public String toString() {
        String s = "*********************************************\nFuziness:\n";
        Iterator<Map.Entry<Label, Double>> it = null;
        try {
            it = this.calculated().entrySet().iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (it.hasNext()) {
            Map.Entry<Label, Double> pairs = it.next();
            s = String.valueOf(s) + "\t" + pairs.getKey().getId() + " = " + pairs.getValue() + "\n";
        }
        s = String.valueOf(s) + "*********************************************\n\n";
        return s;
    }
}

