/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import org.decision_deck.utils.collection.CollectionUtils;

public class Ranking<E> {
    private LinkedList<Set<E>> rankList = new LinkedList();

    public Ranking(int size) {
        int i = 0;
        while (i < size) {
            Set newSet = CollectionUtils.newHashSetNoNull();
            this.rankList.add(newSet);
            ++i;
        }
    }

    public boolean put(E element, int rank) {
        return this.rankList.get(rank - 1).add(element);
    }

    public boolean put(Set<E> set, int rank) {
        return this.rankList.get(rank - 1).addAll(set);
    }

    public int getRank(E element) {
        for (Set set : this.rankList) {
            if (!set.contains(element)) continue;
            return 1 + this.rankList.indexOf(set);
        }
        return -1;
    }

    public Set<E> getElementsSet(int rank) {
        return this.rankList.get(rank);
    }

    public ArrayList<E> getElementsList(int rank) {
        return new ArrayList(this.rankList.get(rank));
    }

    public int removeEmptyRanks() {
        int re = 0;
        Set needToRemove = CollectionUtils.newHashSetNoNull();
        for (Set set : this.rankList) {
            if (!set.isEmpty()) continue;
            needToRemove.add(set);
            ++re;
        }
        this.rankList.removeAll(needToRemove);
        return re;
    }

    public int sizeOf() {
        return this.rankList.size();
    }

    public String toString() {
        String str = "";
        for (Set set : this.rankList) {
            str = String.valueOf(str) + "    " + (1 + this.rankList.indexOf(set)) + ": ";
            str = String.valueOf(str) + set.toString() + "\n";
        }
        return str;
    }
}

