/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.solver;

import com.google.common.collect.Table;
import ilog.concert.IloAddable;
import ilog.concert.IloException;
import ilog.concert.IloIntVar;
import ilog.concert.IloNumVar;
import ilog.concert.IloObjective;
import ilog.cplex.IloCplex;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import jrmp.srmp.base.SRMPsolver;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.settings.Config;
import jrmp.srmp.settings.Para;
import jrmp.srmp.utils.OutputUtils;
import org.decision_deck.jmcda.structure.Alternative;
import org.decision_deck.jmcda.structure.Criterion;
import org.decision_deck.jmcda.structure.matrix.Evaluations;
import org.decision_deck.jmcda.structure.matrix.EvaluationsUtils;
import org.decision_deck.utils.collection.CollectionUtils;

public abstract class XCplSRMPsolver
extends SRMPsolver {
    protected IloCplex cplex = new IloCplex();
    protected IloObjective obj;
    protected int k;
    protected IloNumVar[] w;
    protected IloIntVar[][] p;
    protected ArrayList<Integer> sigma;
    protected IloIntVar[][][] delta;
    protected IloNumVar[][][] c;
    protected IloNumVar[][][] s;
    protected IloNumVar[][] cw;
    protected IloNumVar s_min;
    protected ArrayList<ArrayList<Integer>> lexicoList;
    protected IloNumVar[] cs;
    protected IloNumVar[] gamma;
    protected IloNumVar representable;

    public XCplSRMPsolver(XSRMPmodeler input) throws IloException, IOException {
        super(input);
        this.cplex.setOut((OutputStream)OutputUtils.getLogFileStream().getOutput());
        this.k = 1;
        this.w = new IloNumVar[this.nCrit];
        this.p = new IloIntVar[Para.MAX_NUM_REF_PTS][this.nCrit];
        this.sigma = new ArrayList();
        this.delta = new IloIntVar[Para.MAX_NUM_REF_PTS][this.mElte][this.nCrit];
        this.c = new IloNumVar[Para.MAX_NUM_REF_PTS][this.mElte][this.nCrit];
        this.cw = new IloNumVar[Para.MAX_NUM_REF_PTS][this.mElte];
        this.s = new IloNumVar[this.mElte][this.mElte][Para.MAX_NUM_REF_PTS];
    }

    protected void cplexEnd() {
        this.cplex.end();
    }

    protected void cplexClear(IloObjective objective) throws IloException {
        OutputUtils.logln("-------------------------------------");
        OutputUtils.log("[Waring] Clear the model... ");
        this.cplex.remove((IloAddable)objective);
        this.cplex.clearModel();
        OutputUtils.logln("Done!");
        OutputUtils.logln("-------------------------------------");
    }

    protected boolean cplexSolve() throws IloException {
        OutputUtils.lcln("\n[CPLEX Ver." + this.cplex.getVersion() + "]");
        this.cplex.setParam(IloCplex.IntParam.MIPEmphasis, Config.CPLEX_MIP_EMPHASIS_LEVEL);
        boolean bool = this.cplex.solve();
        OutputUtils.lcln("[CPLEX] Solution status = " + this.cplex.getStatus());
        OutputUtils.lcln("[CPLEX] Objective func. = " + this.cplex.getObjective());
        if (bool) {
            OutputUtils.lcln("[CPLEX] Objective value = " + this.cplex.getObjValue());
        }
        return bool;
    }

    protected void cplexUnsolvedStop() {
        if (!this.isSolved() && this.k > Para.MAX_NUM_REF_PTS) {
            this.cplexEnd();
            OutputUtils.lcln("[Error] Has reached the maximum of number of the reference profiles! (See Para.MAX_NUM_PROFILES)");
        }
    }

    protected void doIfCplexSolved(ArrayList<Integer> sigma) throws IloException {
        this.setSolved(true);
        OutputUtils.lcln("[CPLEX] There are " + this.cplex.getSolnPoolNsolns() + " feasible solutions in the solution pool.");
        XSRMPmodeler sol = new XSRMPmodeler(this.getInput());
        sol.setRefPtsSet(this.getResultOfRefPts().getRows());
        sol.setRefPtsValues(this.getResultOfRefPts());
        sol.setLexico(this.getResultOfLexico());
        sol.setWeights(this.getResultOfWeights());
        this.addSolution(sol);
        this.addObjValue(this.cplex.getObjValue());
        this.exportSolution(sigma);
        this.exportSolutionPool(sigma);
        this.setDelta(this.getResultOfDelta());
        this.setWeightedVar(this.getResultOfWeightedVar());
        this.setCoalOfWeightedVar(this.getResultOfCoalOfWeightedVar());
        this.setSlackVar(this.getResultOfSlackVar());
        OutputUtils.lscln("[i] The problem has been solved with " + this.k + " reference points.");
        OutputUtils.summaryln("[Help: See more details in the log.]");
    }

    protected void exportModel(ArrayList<Integer> sigma) throws IloException {
        String file = String.valueOf(Config.RESOURCES_FOLDER) + Config.MODEL_FOLDER + "/" + "model_" + this.k + "rp_" + this.lexicoList.indexOf(sigma) + ".lp";
        System.out.println(String.valueOf(Config.RESOURCES_FOLDER) + Config.MODEL_FOLDER + "/" + "model_" + this.k + "rp_" + this.lexicoList.indexOf(sigma) + ".lp");
        this.cplex.exportModel(file);
        this.addModelFile(file);
        OutputUtils.logln("[i] The problem has been exported in " + file + ".");
    }

    protected void exportSolution(ArrayList<Integer> sigma) throws IloException {
        String file = String.valueOf(Config.RESOURCES_FOLDER) + Config.SOL_FOLDER + "/" + "solution_" + this.k + "rp_" + this.lexicoList.indexOf(sigma) + ".sol";
        this.cplex.writeSolution(file);
        this.addSolutionFile(file);
        OutputUtils.logln("[i] The solution has been exported in " + file + ".");
    }

    protected void exportSolutionPool(ArrayList<Integer> sigma) throws IloException {
        String file = String.valueOf(Config.RESOURCES_FOLDER) + Config.SOL_FOLDER + "/" + "solution_" + this.k + "rp_" + this.lexicoList.indexOf(sigma) + "_pool.sol";
        this.cplex.writeSolution(file);
        this.addPoolFile(file);
        OutputUtils.logln("[i] All feasible solutions have been exported in " + file + ".");
    }

    protected Integer[][][] getResultOfDelta() throws IloCplex.UnknownObjectException, IloException {
        Integer[][][] re = new Integer[this.k][this.mElte][this.nCrit];
        int n = 0;
        while (n < this.nCrit) {
            int m = 0;
            while (m < this.mElte) {
                int r = 0;
                while (r < this.k) {
                    Double temp = this.cplex.getValue((IloNumVar)this.delta[r][m][n]);
                    re[r][m][n] = temp.intValue();
                    ++r;
                }
                ++m;
            }
            ++n;
        }
        return re;
    }

    protected Integer[][][] getResultOfDelta(int solInPool) throws IloCplex.UnknownObjectException, IloException {
        Integer[][][] re = new Integer[this.k][this.mElte][this.nCrit];
        int n = 0;
        while (n < this.nCrit) {
            int m = 0;
            while (m < this.mElte) {
                int r = 0;
                while (r < this.k) {
                    Double temp = this.cplex.getValue((IloNumVar)this.delta[r][m][n], solInPool);
                    re[r][m][n] = temp.intValue();
                    ++r;
                }
                ++m;
            }
            ++n;
        }
        return re;
    }

    protected Double[][][] getResultOfWeightedVar() throws IloCplex.UnknownObjectException, IloException {
        Double[][][] re = new Double[this.k][this.mElte][this.nCrit];
        int n = 0;
        while (n < this.nCrit) {
            int m = 0;
            while (m < this.mElte) {
                int r = 0;
                while (r < this.k) {
                    re[r][m][n] = this.cplex.getValue(this.c[r][m][n]);
                    ++r;
                }
                ++m;
            }
            ++n;
        }
        return re;
    }

    protected Double[][][] getResultOfWeightedVar(int solInPool) throws IloCplex.UnknownObjectException, IloException {
        Double[][][] re = new Double[this.k][this.mElte][this.nCrit];
        int n = 0;
        while (n < this.nCrit) {
            int m = 0;
            while (m < this.mElte) {
                int r = 0;
                while (r < this.k) {
                    re[r][m][n] = this.cplex.getValue(this.c[r][m][n], solInPool);
                    ++r;
                }
                ++m;
            }
            ++n;
        }
        return re;
    }

    protected Double[][] getResultOfCoalOfWeightedVar() throws IloCplex.UnknownObjectException, IloException {
        Double[][] re = new Double[this.k][this.mElte];
        int r = 0;
        while (r < this.mElte) {
            int h = 0;
            while (h < this.k) {
                re[h][r] = this.cplex.getValue(this.cw[h][r]);
                ++h;
            }
            ++r;
        }
        return re;
    }

    protected Double[][] getResultOfCoalOfWeightedVar(int solInPool) throws IloCplex.UnknownObjectException, IloException {
        Double[][] re = new Double[this.k][this.mElte];
        int r = 0;
        while (r < this.mElte) {
            int h = 0;
            while (h < this.k) {
                re[h][r] = this.cplex.getValue(this.cw[h][r], solInPool);
                ++h;
            }
            ++r;
        }
        return re;
    }

    protected Double[][][] getResultOfSlackVar() throws IloCplex.UnknownObjectException, IloException {
        Double[][][] re = new Double[this.mElte][this.mElte][this.k];
        for (Table.Cell cell : this.getInput().getPairComps().asTable().cellSet()) {
            int row = this.eltList.indexOf(cell.getRowKey());
            int col = this.eltList.indexOf(cell.getColumnKey());
            int h = 0;
            while (h < this.k) {
                re[row][col][h] = this.cplex.getValue(this.s[row][col][h]);
                ++h;
            }
        }
        return re;
    }

    protected Double[][][] getResultOfSlackVar(int solInPool) throws IloCplex.UnknownObjectException, IloException {
        Double[][][] re = new Double[this.mElte][this.mElte][this.k];
        for (Table.Cell cell : this.getInput().getPairComps().asTable().cellSet()) {
            int row = this.eltList.indexOf(cell.getRowKey());
            int col = this.eltList.indexOf(cell.getColumnKey());
            int h = 0;
            while (h < this.k) {
                re[row][col][h] = this.cplex.getValue(this.s[row][col][h], solInPool);
                ++h;
            }
        }
        return re;
    }

    public Integer getResultOfNumOfRefPts() {
        return this.k;
    }

    public ArrayList<Integer> getResultOfLexico() {
        return this.sigma;
    }

    public Map<Criterion, Double> getResultOfWeights() throws IloCplex.UnknownObjectException, IloException {
        Map re = CollectionUtils.newMapNoNull();
        if (this.isSolved()) {
            double[] weight = this.cplex.getValues(this.w);
            int n = 0;
            while (n < this.nCrit) {
                re.put((Criterion)this.criList.get(n), weight[n]);
                ++n;
            }
        }
        return re;
    }

    public Map<Criterion, Double> getResultOfWeights(int solInPool) throws IloCplex.UnknownObjectException, IloException {
        Map re = CollectionUtils.newMapNoNull();
        if (this.isSolved()) {
            double[] weight = this.cplex.getValues(this.w, solInPool);
            int n = 0;
            while (n < this.nCrit) {
                re.put((Criterion)this.criList.get(n), weight[n]);
                ++n;
            }
        }
        return re;
    }

    public Evaluations getResultOfRefPts() throws IloCplex.UnknownObjectException, IloException {
        Evaluations re = EvaluationsUtils.newEvaluationMatrix();
        if (this.isSolved()) {
            int h = 0;
            while (h < this.k) {
                int n = 0;
                while (n < this.nCrit) {
                    double value = this.cplex.getValue((IloNumVar)this.p[h][n]);
                    re.put((Object)new Alternative("p" + (h + 1)), (Object)((Criterion)this.criList.get(n)), value);
                    ++n;
                }
                ++h;
            }
        }
        return re;
    }

    public Evaluations getResultOfRefPts(int solInPool) throws IloCplex.UnknownObjectException, IloException {
        Evaluations re = EvaluationsUtils.newEvaluationMatrix();
        if (this.isSolved()) {
            int h = 0;
            while (h < this.k) {
                int n = 0;
                while (n < this.nCrit) {
                    double value = this.cplex.getValue((IloNumVar)this.p[h][n], solInPool);
                    re.put((Object)new Alternative("p" + (h + 1)), (Object)((Criterion)this.criList.get(n)), value);
                    ++n;
                }
                ++h;
            }
        }
        return re;
    }

    public Double getResultOfMinOfSlackVars() throws IloCplex.UnknownObjectException, IloException {
        if (this.isSolved()) {
            return this.cplex.getValue(this.s_min);
        }
        return null;
    }

    public Double getResultOfMinOfSlackVars(int solInPool) throws IloCplex.UnknownObjectException, IloException {
        if (this.isSolved()) {
            return this.cplex.getValue(this.s_min, solInPool);
        }
        return null;
    }

    public Double[] getResultOfSumOfSlacks() throws IloCplex.UnknownObjectException, IloException {
        Double[] re = new Double[this.numPC];
        if (this.isSolved()) {
            int i = 0;
            while (i < this.numPC) {
                re[i] = this.cplex.getValue(this.cs[i]);
                ++i;
            }
            return re;
        }
        return null;
    }

    public Double[] getResultOfSumOfSlacks(int solInPool) throws IloCplex.UnknownObjectException, IloException {
        Double[] re = new Double[this.numPC];
        if (this.isSolved()) {
            int i = 0;
            while (i < this.numPC) {
                re[i] = this.cplex.getValue(this.cs[i], solInPool);
                ++i;
            }
            return re;
        }
        return null;
    }

    public Double[] getResultOfGamma() throws IloCplex.UnknownObjectException, IloException {
        Double[] re = new Double[this.numPC];
        if (this.isSolved()) {
            int i = 0;
            while (i < this.numPC) {
                re[i] = this.cplex.getValue(this.gamma[i]);
                ++i;
            }
            return re;
        }
        return null;
    }

    public Double[] getResultOfGamma(int solInPool) throws IloCplex.UnknownObjectException, IloException {
        Double[] re = new Double[this.numPC];
        if (this.isSolved()) {
            int i = 0;
            while (i < this.numPC) {
                re[i] = this.cplex.getValue(this.gamma[i], solInPool);
                ++i;
            }
            return re;
        }
        return null;
    }
}

