/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.solver;

import com.google.common.collect.Table;
import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.concert.IloObjective;
import java.io.IOException;
import java.util.Set;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.settings.Para;
import jrmp.srmp.solver.CplSolverJinyan;
import jrmp.srmp.utils.OutputUtils;

public class CplSolverJinyanS
extends CplSolverJinyan {
    public CplSolverJinyanS(XSRMPmodeler input) throws IOException, IloException {
        super(input);
    }

    @Override
    protected IloObjective addObjective(boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Add objective function... ");
        } else {
            OutputUtils.log("[i] Add objective function... ");
        }
        IloObjective re = this.cplex.addMaximize();
        this.representable = this.cplex.numVar(0.0, (double)this.numPC, "representable");
        this.s_min = this.cplex.numVar(0.0, 1.0, "s_min");
        this.cplex.addEq((IloNumExpr)this.representable, this.cplex.sum((IloNumExpr[])this.gamma), "representable_def");
        Set compSet = this.getInput().getPairComps().asTable().cellSet();
        for (Table.Cell comp : compSet) {
            int row = this.eltList.indexOf(comp.getRowKey());
            int col = this.eltList.indexOf(comp.getColumnKey());
            int h = 0;
            while (h < this.k) {
                if (h == 0) {
                    this.cplex.addLe(this.cplex.diff((IloNumExpr)this.s_min, this.cplex.abs((IloNumExpr)this.s[row][col][h])), 0.0);
                }
                ++h;
            }
        }
        IloNumExpr combi = this.cplex.sum((IloNumExpr)this.representable, this.cplex.prod(Para.AMPLIFI_SLACK, (IloNumExpr)this.s_min));
        re.setExpr(combi);
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
        return re;
    }
}

