/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.base;

import java.util.ArrayList;
import jrmp.srmp.base.SRMPmodeler;
import jrmp.srmp.base.XSRMPmodeler;
import org.decision_deck.jmcda.structure.Alternative;

public abstract class SRMPsolver
extends SRMPmodeler {
    private ArrayList<XSRMPmodeler> solutions = new ArrayList();
    private ArrayList<Double> objValues = new ArrayList();
    private ArrayList<String> solutionFiles = new ArrayList();
    private ArrayList<String> modelFiles = new ArrayList();
    private ArrayList<String> poolFiles = new ArrayList();
    protected int mElte = this.getInput().getNumOfAltesInPCs();
    protected ArrayList<Alternative> eltList = this.getInput().getListOfAltesInPCs();

    public SRMPsolver(XSRMPmodeler input) {
        super(input);
    }

    public abstract void solve(boolean var1);

    protected Integer findTheBestSolution(String direction) {
        int re = -1;
        if (this.isLegal()) {
            Double best = this.getObjValue(0);
            int i = 0;
            while (i < this.solutions.size()) {
                Double val = this.getObjValue(i);
                if (direction.toLowerCase().contains("min")) {
                    if (val <= best) {
                        re = i;
                    }
                } else if (val >= best) {
                    re = i;
                }
                ++i;
            }
        }
        return re;
    }

    private boolean isLegal() {
        int ref = this.solutions.size();
        int a = this.objValues.size();
        int b = this.solutionFiles.size();
        int c = this.poolFiles.size();
        return a == ref && b == ref && c == ref;
    }

    public boolean isSolved() {
        return this.isCompleted();
    }

    protected void setSolved(boolean solved) {
        this.setCompleted(solved);
    }

    protected void addSolution(XSRMPmodeler solution) {
        this.solutions.add(solution);
    }

    protected void addObjValue(Double objValue) {
        this.objValues.add(objValue);
    }

    protected void addSolutionFile(String filepath) {
        this.solutionFiles.add(filepath);
    }

    protected void addModelFile(String filepath) {
        this.modelFiles.add(filepath);
    }

    protected void addPoolFile(String filepath) {
        this.poolFiles.add(filepath);
    }

    public XSRMPmodeler getSolution(Integer index) {
        return this.solutions.get(index);
    }

    public Double getObjValue(Integer index) {
        return this.objValues.get(index);
    }

    public String getSolutionFile(Integer index) {
        return this.solutionFiles.get(index);
    }

    public String getModelFile(Integer index) {
        return this.modelFiles.get(index);
    }

    public String getPoolFile(Integer index) {
        return this.poolFiles.get(index);
    }

    public ArrayList<XSRMPmodeler> getSolutions() {
        return this.solutions;
    }

    public ArrayList<Double> getObjValues() {
        return this.objValues;
    }

    public ArrayList<String> getSolutionFiles() {
        return this.solutionFiles;
    }

    public ArrayList<String> getModelFiles() {
        return this.modelFiles;
    }

    public ArrayList<String> getPoolFiles() {
        return this.poolFiles;
    }
}

