/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.base;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Iterator;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.utils.OutputUtils;
import jrmp.srmp.utils.Ranking;
import org.decision_deck.jmcda.structure.Alternative;
import org.decision_deck.jmcda.structure.Criterion;
import org.decision_deck.utils.matrix.SparseMatrixD;

public class SRMPmodeler {
    private boolean completed = false;
    private XSRMPmodeler input;
    private XSRMPmodeler output;
    private Integer[][][] delta;
    private Double[][][] weightedVar;
    private Double[][] coalOfWeightedVar;
    private Double[][][] slackVar;
    private ArrayList<SparseMatrixD<Alternative, Alternative>> relativePrefMatrixList;
    private SparseMatrixD<Alternative, Alternative> globalPrefMatrix;
    private Ranking<Alternative> result;
    private Double[] sumOfSlacks;
    private Double[] gamma;
    protected int nCrit;
    protected int mAlte;
    protected int hRefP;
    protected ArrayList<Alternative> rptList;
    protected ArrayList<Alternative> altList;
    protected ArrayList<Criterion> criList;
    protected ArrayList<Double> wgtList;
    protected int numPC;
    protected ArrayList<Table.Cell<Alternative, Alternative, Double>> pCoList;

    public SRMPmodeler(XSRMPmodeler input) {
        this.setInput(input);
    }

    protected SparseMatrixD<Alternative, Alternative> getRelativePrefMatrix(Alternative refPt) {
        return this.getRelativePrefMatrixList().get(this.rptList.indexOf(refPt));
    }

    protected void displayDelta() {
        OutputUtils.lscln("[Re] Binary variable matrix \"delta\":");
        int dh = 0;
        while (dh < this.hRefP) {
            OutputUtils.lsc("\t* delta[" + (dh + 1) + "][m][n] *\n\t");
            Iterator<Criterion> itc = this.criList.iterator();
            while (itc.hasNext()) {
                OutputUtils.lsc("\t" + itc.next().getId());
            }
            OutputUtils.lscln("");
            int dm = 0;
            while (dm < this.mAlte) {
                OutputUtils.lsc("\t" + this.altList.get(dm).getId());
                int dn = 0;
                while (dn < this.nCrit) {
                    OutputUtils.lsc("\t" + this.delta[dh][dm][dn]);
                    ++dn;
                }
                OutputUtils.lscln("");
                ++dm;
            }
            ++dh;
        }
    }

    protected void logDelta() {
        OutputUtils.logln("[Re] Binary variable matrix \"delta\":");
        int dh = 0;
        while (dh < this.hRefP) {
            OutputUtils.log("\t* delta[" + (dh + 1) + "][m][n] *\n\t");
            Iterator<Criterion> itc = this.criList.iterator();
            while (itc.hasNext()) {
                OutputUtils.log("\t" + itc.next().getId());
            }
            OutputUtils.logln("");
            int dm = 0;
            while (dm < this.mAlte) {
                OutputUtils.log("\t" + this.altList.get(dm).getId());
                int dn = 0;
                while (dn < this.nCrit) {
                    OutputUtils.log("\t" + this.delta[dh][dm][dn]);
                    ++dn;
                }
                OutputUtils.logln("");
                ++dm;
            }
            ++dh;
        }
    }

    protected void displayWeightedVar() {
        OutputUtils.lscln("[Re] Weighted variable matrix \"c\":");
        int dh = 0;
        while (dh < this.hRefP) {
            OutputUtils.lsc("\t* c[" + (dh + 1) + "][m][n] *\n\t");
            Iterator<Criterion> itc = this.criList.iterator();
            while (itc.hasNext()) {
                OutputUtils.lsc("\t" + itc.next().getId());
            }
            OutputUtils.lscln("");
            int dm = 0;
            while (dm < this.mAlte) {
                OutputUtils.lsc("\t" + this.altList.get(dm).getId());
                int dn = 0;
                while (dn < this.nCrit) {
                    OutputUtils.lsc("\t" + OutputUtils.centi.format(this.weightedVar[dh][dm][dn]));
                    ++dn;
                }
                OutputUtils.lscln("");
                ++dm;
            }
            ++dh;
        }
    }

    protected void logWeightedVar() {
        OutputUtils.logln("[Re] Weighted variable matrix \"c\":");
        int dh = 0;
        while (dh < this.hRefP) {
            OutputUtils.log("\t* c[" + (dh + 1) + "][m][n] *\n\t");
            Iterator<Criterion> itc = this.criList.iterator();
            while (itc.hasNext()) {
                OutputUtils.log("\t" + itc.next().getId());
            }
            OutputUtils.logln("");
            int dm = 0;
            while (dm < this.mAlte) {
                OutputUtils.log("\t" + this.altList.get(dm).getId());
                int dn = 0;
                while (dn < this.nCrit) {
                    OutputUtils.log("\t" + OutputUtils.centi.format(this.weightedVar[dh][dm][dn]));
                    ++dn;
                }
                OutputUtils.logln("");
                ++dm;
            }
            ++dh;
        }
    }

    protected void displayCoalOfWeightedVar() {
        OutputUtils.lsc("[Re] Coalition of weights matrix \"cw\":\n\t");
        Iterator<Alternative> itp = this.rptList.iterator();
        while (itp.hasNext()) {
            OutputUtils.lsc("\t" + itp.next().getId());
        }
        OutputUtils.lscln("");
        int dm = 0;
        while (dm < this.mAlte) {
            OutputUtils.lsc("\t" + this.altList.get(dm).getId());
            int dh = 0;
            while (dh < this.hRefP) {
                OutputUtils.lsc("\t" + OutputUtils.centi.format(this.coalOfWeightedVar[dm][dh]));
                ++dh;
            }
            OutputUtils.lscln("");
            ++dm;
        }
    }

    protected void logCoalOfWeightedVar() {
        OutputUtils.log("[Re] Coalition of weights matrix \"cw\":\n\t");
        Iterator<Alternative> itp = this.rptList.iterator();
        while (itp.hasNext()) {
            OutputUtils.log("\t" + itp.next().getId());
        }
        OutputUtils.logln("");
        int dm = 0;
        while (dm < this.mAlte) {
            OutputUtils.log("\t" + this.altList.get(dm).getId());
            int dh = 0;
            while (dh < this.hRefP) {
                OutputUtils.log("\t" + OutputUtils.centi.format(this.coalOfWeightedVar[dm][dh]));
                ++dh;
            }
            OutputUtils.logln("");
            ++dm;
        }
    }

    protected void displaySlackVar() {
        OutputUtils.lscln("[Re] Slack variable matrix \"c\":");
        int dh = 0;
        while (dh < this.hRefP) {
            OutputUtils.lsc("\t* s[mR][mC][" + (dh + 1) + "] *\n\t");
            Iterator<Alternative> ita = this.altList.iterator();
            while (ita.hasNext()) {
                OutputUtils.lsc("\t" + ita.next().getId());
            }
            OutputUtils.lscln("");
            int dmR = 0;
            while (dmR < this.mAlte) {
                OutputUtils.lsc("\t" + this.altList.get(dmR).getId());
                int dmC = 0;
                while (dmC < this.mAlte) {
                    if (this.slackVar[dmR][dmC][dh] == null || dmR == dmC) {
                        OutputUtils.lsc("\t-");
                    } else {
                        OutputUtils.lsc("\t" + OutputUtils.centi.format(this.slackVar[dmR][dmC][dh]));
                    }
                    ++dmC;
                }
                OutputUtils.lscln("");
                ++dmR;
            }
            ++dh;
        }
    }

    protected void logSlackVar() {
        OutputUtils.logln("[Re] Slack variable matrix \"c\":");
        int dh = 0;
        while (dh < this.hRefP) {
            OutputUtils.log("\t* s[mR][mC][" + (dh + 1) + "] *\n\t");
            Iterator<Alternative> ita = this.altList.iterator();
            while (ita.hasNext()) {
                OutputUtils.log("\t" + ita.next().getId());
            }
            OutputUtils.logln("");
            int dmR = 0;
            while (dmR < this.mAlte) {
                OutputUtils.log("\t" + this.altList.get(dmR).getId());
                int dmC = 0;
                while (dmC < this.mAlte) {
                    if (this.slackVar[dmR][dmC][dh] == null || dmR == dmC) {
                        OutputUtils.log("\t-");
                    } else {
                        OutputUtils.log("\t" + OutputUtils.centi.format(this.slackVar[dmR][dmC][dh]));
                    }
                    ++dmC;
                }
                OutputUtils.logln("");
                ++dmR;
            }
            ++dh;
        }
    }

    protected void displayRelativePrefMatrixList() {
        int h = 0;
        while (h < this.hRefP) {
            this.displayRelativePrefMatrix(this.rptList.get(h));
            ++h;
        }
    }

    protected void logRelativePrefMatrixList() {
        int h = 0;
        while (h < this.hRefP) {
            this.logRelativePrefMatrix(this.rptList.get(h));
            ++h;
        }
    }

    protected void displayRelativePrefMatrix(Alternative refPt) {
        OutputUtils.lscln("[Re] Preference with respect to the reference point \"" + refPt.getId() + "\":");
        OutputUtils.lsc("    (1 = Preference, 0 = Indifference, -1 = Opposite preference)\n\t");
        Iterator<Alternative> ita = this.altList.iterator();
        while (ita.hasNext()) {
            OutputUtils.lsc("\t" + ita.next().getId());
        }
        OutputUtils.lscln("");
        for (Alternative alteRow : this.getRelativePrefMatrix(refPt).getRows()) {
            OutputUtils.lsc("\t" + alteRow.getId());
            for (Alternative alteCol : this.getRelativePrefMatrix(refPt).getColumns()) {
                Double temp = this.getRelativePrefMatrix(refPt).getValue((Object)alteRow, (Object)alteCol);
                OutputUtils.lsc("\t" + OutputUtils.integ.format(temp));
            }
            OutputUtils.lscln("");
        }
    }

    protected void logRelativePrefMatrix(Alternative refPt) {
        OutputUtils.logln("[Re] Preference with respect to the reference point \"" + refPt.getId() + "\":");
        OutputUtils.log("    (1 = Preference, 0 = Indifference, -1 = Opposite preference)\n\t");
        Iterator<Alternative> ita = this.altList.iterator();
        while (ita.hasNext()) {
            OutputUtils.log("\t" + ita.next().getId());
        }
        OutputUtils.logln("");
        for (Alternative alteRow : this.getRelativePrefMatrix(refPt).getRows()) {
            OutputUtils.log("\t" + alteRow.getId());
            for (Alternative alteCol : this.getRelativePrefMatrix(refPt).getColumns()) {
                Double temp = this.getRelativePrefMatrix(refPt).getValue((Object)alteRow, (Object)alteCol);
                OutputUtils.log("\t" + OutputUtils.integ.format(temp));
            }
            OutputUtils.logln("");
        }
    }

    protected void displayGlobalPrefMatrix() {
        OutputUtils.lscln("[Re] Global preference:");
        OutputUtils.lsc("    (1 = Preference, 0 = Indifference, -1 = Opposite preference)\n\t");
        Iterator<Alternative> ita = this.altList.iterator();
        while (ita.hasNext()) {
            OutputUtils.lsc("\t" + ita.next().getId());
        }
        OutputUtils.lscln("");
        for (Alternative alteR : this.getGlobalPrefMatrix().getRows()) {
            OutputUtils.lsc("\t" + alteR.getId());
            for (Alternative alteC : this.getGlobalPrefMatrix().getColumns()) {
                Double temp = this.getGlobalPrefMatrix().getValue((Object)alteR, (Object)alteC);
                OutputUtils.lsc("\t" + OutputUtils.integ.format(temp));
            }
            OutputUtils.lscln("");
        }
    }

    protected void logGlobalPrefMatrix() {
        OutputUtils.logln("[Re] Global preference:");
        OutputUtils.log("    (1 = Preference, 0 = Indifference, -1 = Opposite preference)\n\t");
        Iterator<Alternative> ita = this.altList.iterator();
        while (ita.hasNext()) {
            OutputUtils.log("\t" + ita.next().getId());
        }
        OutputUtils.logln("");
        for (Alternative alteR : this.getGlobalPrefMatrix().getRows()) {
            OutputUtils.log("\t" + alteR.getId());
            for (Alternative alteC : this.getGlobalPrefMatrix().getColumns()) {
                Double temp = this.getGlobalPrefMatrix().getValue((Object)alteR, (Object)alteC);
                OutputUtils.log("\t" + OutputUtils.integ.format(temp));
            }
            OutputUtils.logln("");
        }
    }

    protected void displayRanking() {
        OutputUtils.lscln("[Re] Ranking of the alternatives:");
        OutputUtils.lscln(this.getRanking().toString());
    }

    protected void logRanking() {
        OutputUtils.logln("[Re] Ranking of the alternatives:");
        OutputUtils.logln(this.getRanking().toString());
    }

    public XSRMPmodeler getInput() {
        return this.input;
    }

    public void setInput(XSRMPmodeler input) {
        this.input = input;
        this.mAlte = this.getInput().getNumOfAlternatives();
        this.nCrit = this.getInput().getNumOfCriteria();
        this.altList = this.getInput().getListOfAlternatives();
        this.criList = this.getInput().getListOfCriteria();
        if (this.getInput().isReadyForAggr()) {
            this.hRefP = this.getInput().getNumOfRefPts();
            this.rptList = this.getInput().getListOfRefPts();
            this.wgtList = this.getInput().getListOfWeights();
        }
        if (this.getInput().isReadyForDisag()) {
            this.numPC = this.getInput().getNumOfPairComps();
            this.pCoList = this.getInput().getListOfPairComps();
        }
    }

    public XSRMPmodeler getOutput() {
        return this.output;
    }

    public void setOutput(XSRMPmodeler output) {
        this.output = output;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    protected void setCompleted(boolean completed) {
        this.completed = completed;
    }

    protected Integer[][][] getDelta() {
        return this.delta;
    }

    protected void setDelta(Integer[][][] delta) {
        this.delta = delta;
    }

    protected Double[][][] getWeightedVar() {
        return this.weightedVar;
    }

    protected void setWeightedVar(Double[][][] weightedVar) {
        this.weightedVar = weightedVar;
    }

    protected Double[][] getCoalOfWeightedVar() {
        return this.coalOfWeightedVar;
    }

    protected void setCoalOfWeightedVar(Double[][] coalOfWeightedVar) {
        this.coalOfWeightedVar = coalOfWeightedVar;
    }

    protected Double[][][] getSlackVar() {
        return this.slackVar;
    }

    protected void setSlackVar(Double[][][] slackVar) {
        this.slackVar = slackVar;
    }

    protected ArrayList<SparseMatrixD<Alternative, Alternative>> getRelativePrefMatrixList() {
        return this.relativePrefMatrixList;
    }

    protected void setRelativePrefMatrixList(ArrayList<SparseMatrixD<Alternative, Alternative>> relativePrefMatrixList) {
        this.relativePrefMatrixList = relativePrefMatrixList;
    }

    protected SparseMatrixD<Alternative, Alternative> getGlobalPrefMatrix() {
        return this.globalPrefMatrix;
    }

    protected void setGlobalPrefMatrix(SparseMatrixD<Alternative, Alternative> globalPrefMatrix) {
        this.globalPrefMatrix = globalPrefMatrix;
    }

    protected Ranking<Alternative> getRanking() {
        return this.result;
    }

    protected void setRanking(Ranking<Alternative> result) {
        this.result = result;
    }

    protected Double[] getSumOfSlacks() {
        return this.sumOfSlacks;
    }

    protected void setSumOfSlacks(Double[] sumOfSlacks) {
        this.sumOfSlacks = sumOfSlacks;
    }

    protected Double[] getGamma() {
        return this.gamma;
    }

    protected void setGamma(Double[] gamma) {
        this.gamma = gamma;
    }
}

