/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.base;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Iterator;
import jrmp.srmp.base.SRMPmodeler;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.settings.Para;
import jrmp.srmp.utils.OutputUtils;
import jrmp.srmp.utils.RankingUtils;
import org.decision_deck.jmcda.structure.Alternative;
import org.decision_deck.jmcda.structure.Criterion;
import org.decision_deck.utils.matrix.Matrixes;
import org.decision_deck.utils.matrix.SparseMatrixD;

public class SRMPaggregator
extends SRMPmodeler {
    private boolean needToRebuid = false;

    public SRMPaggregator(XSRMPmodeler input) {
        super(input);
    }

    public boolean execute() {
        if (this.getInput().isReadyForAggr()) {
            this.calculateDelta(false);
            this.calculateWeightedVar(false);
            this.calculateCoalOfWeightedVar(false);
            this.calculateSlackVar(false);
            this.calculateRelativePrefs(false);
            this.calculateGlobalPref(false);
            if (this.getGlobalPrefMatrix() != null) {
                this.setRanking(RankingUtils.getRanking(this.getGlobalPrefMatrix()));
                this.logRanking();
                this.setCompleted(true);
                this.prepareOutput();
                return true;
            }
            OutputUtils.lcln("[Error] Aggregation failed!");
            return false;
        }
        return false;
    }

    public boolean execute(boolean display) {
        if (this.getInput().isReadyForAggr()) {
            OutputUtils.lscln("\n[Aggregation Process]");
            this.calculateDelta(display);
            this.calculateWeightedVar(display);
            this.calculateCoalOfWeightedVar(display);
            this.calculateSlackVar(display);
            this.calculateRelativePrefs(display);
            this.calculateGlobalPref(display);
            if (this.getGlobalPrefMatrix() != null) {
                this.setRanking(RankingUtils.getRanking(this.getGlobalPrefMatrix()));
                if (display) {
                    this.displayRanking();
                } else {
                    this.logRanking();
                }
                this.setCompleted(true);
                this.prepareOutput();
                OutputUtils.lscln("[i] Aggregation completed!");
                return true;
            }
            OutputUtils.lscln("[i] Aggregation failed!");
            return false;
        }
        return false;
    }

    public SparseMatrixD<Alternative, Alternative> rebuildPairComps() {
        SparseMatrixD re = Matrixes.newSparseD();
        for (Table.Cell cell : this.getInput().getPairComps().asTable().cellSet()) {
            re.put((Object)((Alternative)cell.getRowKey()), (Object)((Alternative)cell.getColumnKey()), this.getGlobalPrefMatrix().getValue((Object)((Alternative)cell.getRowKey()), (Object)((Alternative)cell.getColumnKey())));
        }
        return re;
    }

    private void prepareOutput() {
        XSRMPmodeler out = new XSRMPmodeler(this.getInput());
        out.setBinComps(this.getGlobalPrefMatrix());
        if (this.isNeedToRebuid()) {
            out.setPairComps(this.rebuildPairComps());
        }
        this.setOutput(out);
    }

    private void calculateDelta(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Calculating the binary variables \"delta\"...");
        } else {
            OutputUtils.log("[i] Calculating the binary variables \"delta\"...");
        }
        Integer[][][] re = new Integer[this.hRefP][this.mAlte][this.nCrit];
        int h = 0;
        for (Alternative rpt : this.rptList) {
            int m = 0;
            for (Alternative alt : this.altList) {
                int n = 0;
                for (Criterion cri : this.criList) {
                    double val = this.getInput().getEvaluationValue(alt, cri);
                    double ref = this.getInput().getRefPtsValues().getValue((Object)rpt, (Object)cri);
                    int prefDir = this.getInput().getPrefDirValue(cri);
                    switch (prefDir) {
                        case 1: {
                            if (val >= ref) {
                                re[h][m][n] = 1;
                                break;
                            }
                            re[h][m][n] = 0;
                            break;
                        }
                        case -1: {
                            if (val <= ref) {
                                re[h][m][n] = 1;
                                break;
                            }
                            re[h][m][n] = 0;
                            break;
                        }
                        default: {
                            OutputUtils.lcln("[Error] The criterion " + cri.getId() + " preference direction is missing.");
                        }
                    }
                    ++n;
                }
                ++m;
            }
            ++h;
        }
        this.setDelta(re);
        OutputUtils.logln("OK!");
        if (display) {
            OutputUtils.lcln("OK!");
            this.displayDelta();
        } else {
            this.logDelta();
        }
    }

    private void calculateWeightedVar(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Calculating the weighted variables \"c\"...");
        } else {
            OutputUtils.log("[i] Calculating the weighted variables \"c\"...");
        }
        Double[][][] re = new Double[this.hRefP][this.mAlte][this.nCrit];
        Integer[][][] d = this.getDelta();
        int h = 0;
        while (h < this.hRefP) {
            int m = 0;
            while (m < this.mAlte) {
                int n = 0;
                while (n < this.nCrit) {
                    if (d[h][m][n] != null) {
                        re[h][m][n] = (double)d[h][m][n].intValue() * (Double)this.wgtList.get(n);
                    } else {
                        OutputUtils.lcln("[Error] \"Delta\" is not available.");
                    }
                    ++n;
                }
                ++m;
            }
            ++h;
        }
        this.setWeightedVar(re);
        OutputUtils.logln("OK!");
        if (display) {
            OutputUtils.lcln("OK!");
            this.displayWeightedVar();
        } else {
            this.logWeightedVar();
        }
    }

    private void calculateCoalOfWeightedVar(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Calculating the coalitions of weighted variables \"cw\"...");
        } else {
            OutputUtils.log("[i] Calculating the coalitions of weighted variables \"cw\"...");
        }
        Double[][] re = new Double[this.mAlte][this.hRefP];
        Double[][][] c = this.getWeightedVar();
        int h = 0;
        while (h < this.hRefP) {
            int m = 0;
            while (m < this.mAlte) {
                int n = 0;
                while (n < this.nCrit) {
                    if (c[h][m][n] != null) {
                        if (re[m][h] == null) {
                            re[m][h] = 0.0;
                        }
                        Double[] doubleArray = re[m];
                        int n2 = h;
                        doubleArray[n2] = doubleArray[n2] + c[h][m][n];
                    } else {
                        OutputUtils.lcln("[Error] \"c\" is not available.");
                    }
                    ++n;
                }
                ++m;
            }
            ++h;
        }
        this.setCoalOfWeightedVar(re);
        OutputUtils.logln("OK!");
        if (display) {
            OutputUtils.lcln("OK!");
            this.displayCoalOfWeightedVar();
        } else {
            this.logCoalOfWeightedVar();
        }
    }

    private void calculateSlackVar(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Calculating the slack variables \"s\"...");
        } else {
            OutputUtils.log("[i] Calculating the slack variables \"s\"...");
        }
        Double[][][] re = new Double[this.mAlte][this.mAlte][this.hRefP];
        Double[][] cw = this.getCoalOfWeightedVar();
        int h = 0;
        while (h < this.hRefP) {
            int mR = 0;
            while (mR < this.mAlte) {
                int mC = mR;
                while (mC < this.mAlte) {
                    if (cw[mR][h] != null && cw[mC][h] != null) {
                        re[mR][mC][h] = cw[mR][h] - cw[mC][h];
                    } else {
                        OutputUtils.lcln("[Error] \"cw\" is not available.");
                    }
                    ++mC;
                }
                ++mR;
            }
            ++h;
        }
        this.setSlackVar(re);
        OutputUtils.logln("OK!");
        if (display) {
            OutputUtils.lcln("OK!");
            this.displaySlackVar();
        } else {
            this.logSlackVar();
        }
    }

    private void calculateRelativePrefs(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Determinating the relative preference relations...");
        } else {
            OutputUtils.log("[i] Determinating the relative preference relations...");
        }
        ArrayList<SparseMatrixD<Alternative, Alternative>> re = new ArrayList<SparseMatrixD<Alternative, Alternative>>();
        int h = 0;
        while (h < this.hRefP) {
            re.add(this.calculateRelativePref((Alternative)this.rptList.get(h)));
            ++h;
        }
        this.setRelativePrefMatrixList(re);
        OutputUtils.logln("OK!");
        if (display) {
            OutputUtils.lcln("OK!");
            this.displayRelativePrefMatrixList();
        } else {
            this.logRelativePrefMatrixList();
        }
    }

    private SparseMatrixD<Alternative, Alternative> calculateRelativePref(Alternative refPt) {
        SparseMatrixD re = Matrixes.newSparseD();
        Double[][][] s = this.getSlackVar();
        int mR = 0;
        while (mR < this.mAlte) {
            int mC = mR;
            while (mC < this.mAlte) {
                Double val = s[mR][mC][this.rptList.indexOf(refPt)];
                if (val.compareTo(Para.EPSILON) >= 0) {
                    re.put((Object)((Alternative)this.altList.get(mR)), (Object)((Alternative)this.altList.get(mC)), 1.0);
                    re.put((Object)((Alternative)this.altList.get(mC)), (Object)((Alternative)this.altList.get(mR)), -1.0);
                } else if (val.compareTo(-Para.EPSILON) <= 0) {
                    re.put((Object)((Alternative)this.altList.get(mR)), (Object)((Alternative)this.altList.get(mC)), -1.0);
                    re.put((Object)((Alternative)this.altList.get(mC)), (Object)((Alternative)this.altList.get(mR)), 1.0);
                } else {
                    re.put((Object)((Alternative)this.altList.get(mR)), (Object)((Alternative)this.altList.get(mC)), 0.0);
                    re.put((Object)((Alternative)this.altList.get(mC)), (Object)((Alternative)this.altList.get(mR)), 0.0);
                }
                ++mC;
            }
            ++mR;
        }
        return re;
    }

    private void calculateGlobalPref(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Determinating the global preference relations...");
        } else {
            OutputUtils.log("[i] Determinating the global preference relations...");
        }
        SparseMatrixD re = Matrixes.newSparseD();
        int r = 0;
        while (r < this.altList.size()) {
            int c = 0;
            while (c < this.altList.size()) {
                re.put((Object)((Alternative)this.altList.get(r)), (Object)((Alternative)this.altList.get(c)), 0.0);
                ++c;
            }
            ++r;
        }
        ArrayList<Integer> lexico = this.getInput().getLexico();
        Iterator<Integer> itp = lexico.iterator();
        while (itp.hasNext()) {
            int indexOfProfile = itp.next() - 1;
            SparseMatrixD<Alternative, Alternative> matrix = this.getRelativePrefMatrixList().get(indexOfProfile);
            for (Alternative alteRow : re.getRows()) {
                for (Alternative alteCol : re.getColumns()) {
                    if (re.getValue((Object)alteRow, (Object)alteCol) != 0.0) continue;
                    re.put((Object)alteRow, (Object)alteCol, matrix.getValue((Object)alteRow, (Object)alteCol));
                }
            }
        }
        this.setGlobalPrefMatrix((SparseMatrixD<Alternative, Alternative>)re);
        OutputUtils.logln("OK!");
        if (display) {
            OutputUtils.lcln("OK!");
            this.displayGlobalPrefMatrix();
        } else {
            this.logGlobalPrefMatrix();
        }
    }

    public Integer getRank(Alternative alternative) {
        return this.getRanking().getRank(alternative);
    }

    public Double getRatioOfRepresentables() {
        Double re = -1.0;
        if (this.getOutput() != null) {
            int num = this.getInput().getNumOfPairComps();
            int den = 0;
            if (num > 0) {
                for (Table.Cell pair : this.getInput().getPairComps().asTable().cellSet()) {
                    double ref = this.getInput().getPairComps().getValue((Object)((Alternative)pair.getRowKey()), (Object)((Alternative)pair.getColumnKey()));
                    double val = this.getOutput().getBinComps().getValue((Object)((Alternative)pair.getRowKey()), (Object)((Alternative)pair.getColumnKey()));
                    if (Math.rint(val) != Math.rint(ref) && Math.rint(val) != 0.0) continue;
                    ++den;
                }
                re = new Double((double)den / (double)num);
            }
        }
        return re;
    }

    public Integer getNumOfIndifferences() {
        Integer re = -1;
        if (this.getOutput() != null) {
            int num = this.getInput().getNumOfPairComps();
            int den = 0;
            if (num > 0) {
                for (Table.Cell pair : this.getInput().getPairComps().asTable().cellSet()) {
                    double val = this.getOutput().getBinComps().getValue((Object)((Alternative)pair.getRowKey()), (Object)((Alternative)pair.getColumnKey()));
                    if (Math.rint(val) != 0.0) continue;
                    ++den;
                }
                re = den;
            }
        }
        return re;
    }

    public boolean isNeedToRebuid() {
        return this.needToRebuid;
    }

    public void setNeedToRebuid(boolean needToRebuid) {
        this.needToRebuid = needToRebuid;
    }
}

