/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.access;

import ilog.concert.IloException;
import java.io.IOException;
import jrmp.srmp.access.Accessible;
import jrmp.srmp.base.SRMPaggregator;
import jrmp.srmp.base.XSRMPreader;
import jrmp.srmp.base.XSRMPwriter;
import jrmp.srmp.solver.CplSolverJinyanS;
import jrmp.srmp.utils.OutputUtils;
import org.apache.xmlbeans.XmlException;
import org.decisiondeck.jmcda.exc.InvalidInputException;

public class Malaga
extends Accessible {
    public static void main(String[] args) throws IOException, IloException, XmlException, InvalidInputException {
        Malaga.prepare(args);
        XSRMPreader reader = new XSRMPreader();
        reader.read(false);
        reader.displayPairComps();
        reader.perturb(0);
        reader.displayPairComps();
        CplSolverJinyanS jinyan = new CplSolverJinyanS(reader);
        if (jinyan.getInput().isReadyForDisag()) {
            jinyan.solve(false);
        } else {
            System.out.println("[ERROR] Disaggrgation Error!");
        }
        if (jinyan.isSolved()) {
            OutputUtils.lcln(jinyan.getGammaStatus());
            OutputUtils.lcln(jinyan.getSlackStatus());
            SRMPaggregator aggr = new SRMPaggregator(jinyan.getOutput());
            aggr.setNeedToRebuid(true);
            if (aggr.getInput().isReadyForAggr()) {
                aggr.execute(false);
            } else {
                System.out.println("[ERROR] Aggregation Error!");
            }
            aggr.getOutput().displayPairComps();
            OutputUtils.lscln("[i] The ratio of representables is " + OutputUtils.centi.format(aggr.getRatioOfRepresentables() * 100.0) + "% (" + aggr.getNumOfIndifferences() + " indiff.).");
            XSRMPwriter writer = new XSRMPwriter(jinyan.getOutput());
            writer.writeModel(true);
        }
        Malaga.end();
    }
}

