/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.utils;

import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import jrmp.srmp.settings.Config;
import jrmp.srmp.utils.PreDef;
import org.apache.xmlbeans.XmlObject;
import org.decisiondeck.jmcda.persist.xmcda2.XMCDAVarious;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XMethodMessages;
import org.decisiondeck.jmcda.persist.xmcda2.utils.XMCDAErrorsManager;
import org.decisiondeck.jmcda.persist.xmcda2.utils.XMCDAWriteUtils;

public class MsgUtils {
    private String filePath;
    private String fileName;
    private File file;
    private static ArrayList<String> msgList;

    public MsgUtils() {
        this.setFilePath(Config.XML_FOLDER);
        this.setFileName("/" + PreDef.FileName.messages.toString() + ".xml");
        this.file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.getFilePath() + this.getFileName());
        msgList = new ArrayList();
    }

    private void exportMessages(Collection<String> msg) throws IOException {
        OutputSupplier outputStream = Files.newOutputStreamSupplier((File)this.file);
        XMCDAVarious writeVarious = new XMCDAVarious(new XMCDAErrorsManager());
        XMethodMessages xMsg = writeVarious.writeMessages(msg);
        XMCDAWriteUtils.write((XmlObject)xMsg, (OutputSupplier)outputStream, (boolean)true);
    }

    public static void addMethodMessage(String msg) {
        msgList.add(msg);
    }

    public static void addMethodMessage(int index, String msg) {
        msgList.add(index, msg);
    }

    public static void clearMethodMessage() {
        msgList.clear();
    }

    public void end() throws IOException {
        this.exportMessages(msgList);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ArrayList<String> getMsgSet() {
        return msgList;
    }
}

