/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.base;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import jrmp.srmp.utils.OutputUtils;
import jrmp.srmp.utils.RankingUtils;
import org.decision_deck.jmcda.structure.Alternative;
import org.decision_deck.jmcda.structure.Criterion;
import org.decision_deck.jmcda.structure.interval.Interval;
import org.decision_deck.jmcda.structure.matrix.Evaluations;
import org.decision_deck.utils.matrix.SparseMatrixD;

public class XSRMPmodeler {
    private Status status;
    private Set<Alternative> alteSet;
    private Map<Alternative, String> alteNames;
    private Evaluations alteValues;
    private Set<Criterion> critSet;
    private Map<Criterion, String> critNames;
    private Map<Criterion, Interval> critScales;
    private Map<Criterion, Double> weights;
    private Set<Alternative> refPtsSet;
    private Evaluations refPtsValues;
    private ArrayList<Integer> lexico;
    private Set<Alternative> alteInPCs = null;
    private SparseMatrixD<Alternative, Alternative> binComps;
    private SparseMatrixD<Alternative, Alternative> pairComps;

    public XSRMPmodeler() {
        this.status = Status.initialized;
        this.alteSet = null;
        this.alteNames = null;
        this.alteValues = null;
        this.critSet = null;
        this.critNames = null;
        this.critScales = null;
        this.weights = null;
        this.refPtsSet = null;
        this.refPtsValues = null;
        this.lexico = null;
        this.alteInPCs = null;
        this.binComps = null;
        this.pairComps = null;
    }

    public XSRMPmodeler(XSRMPmodeler model) {
        if (model.getAlteSet() != null) {
            this.setAlteSet(model.getAlteSet());
        }
        if (model.getAlteNames() != null) {
            this.setAlteNames(model.getAlteNames());
        }
        if (model.getAlteValues() != null) {
            this.setAlteValues(model.getAlteValues());
        }
        if (model.getCritSet() != null) {
            this.setCritSet(model.getCritSet());
        }
        if (model.getCritNames() != null) {
            this.setCritNames(model.getCritNames());
        }
        if (model.getCritScales() != null) {
            this.setCritScales(model.getCritScales());
        }
        if (model.getWeights() != null) {
            this.setWeights(model.getWeights());
        }
        if (model.getRefPtsSet() != null) {
            this.setRefPtsSet(model.getRefPtsSet());
        }
        if (model.getRefPtsValues() != null) {
            this.setRefPtsValues(model.getRefPtsValues());
        }
        if (model.getLexico() != null) {
            this.setLexico(model.getLexico());
        }
        if (model.getAlteInPCs() != null) {
            this.setAlteInPCs(model.getAlteInPCs());
        }
        if (model.getBinComps() != null) {
            this.setBinComps(model.getBinComps());
        }
        if (model.getPairComps() != null) {
            this.setPairComps(model.getPairComps());
        }
    }

    public void copy(XSRMPmodeler model) {
        if (model.getAlteSet() != null) {
            this.setAlteSet(model.getAlteSet());
        }
        if (model.getAlteNames() != null) {
            this.setAlteNames(model.getAlteNames());
        }
        if (model.getAlteValues() != null) {
            this.setAlteValues(model.getAlteValues());
        }
        if (model.getCritSet() != null) {
            this.setCritSet(model.getCritSet());
        }
        if (model.getCritNames() != null) {
            this.setCritNames(model.getCritNames());
        }
        if (model.getCritScales() != null) {
            this.setCritScales(model.getCritScales());
        }
        if (model.getWeights() != null) {
            this.setWeights(model.getWeights());
        }
        if (model.getRefPtsSet() != null) {
            this.setRefPtsSet(model.getRefPtsSet());
        }
        if (model.getRefPtsValues() != null) {
            this.setRefPtsValues(model.getRefPtsValues());
        }
        if (model.getLexico() != null) {
            this.setLexico(model.getLexico());
        }
        if (model.getAlteInPCs() != null) {
            this.setAlteInPCs(model.getAlteInPCs());
        }
        if (model.getBinComps() != null) {
            this.setBinComps(model.getBinComps());
        }
        if (model.getPairComps() != null) {
            this.setPairComps(model.getPairComps());
        }
    }

    public boolean isReadyForAggr() {
        return this.getAlteSet() != null && this.getAlteValues() != null && this.getCritSet() != null && this.getCritScales() != null && this.getWeights() != null && this.getRefPtsSet() != null && this.getRefPtsValues() != null && this.getLexico() != null;
    }

    public boolean isReadyForDisag() {
        return this.getAlteSet() != null && this.getAlteValues() != null && this.getCritSet() != null && this.getCritScales() != null && this.getPairComps() != null;
    }

    public Integer getNumOfAlternatives() {
        return this.getAlteSet().size();
    }

    public Integer getNumOfCriteria() {
        return this.getCritSet().size();
    }

    public Integer getNumOfRefPts() {
        return this.getRefPtsSet().size();
    }

    public Integer getNumOfPairComps() {
        return this.getPairComps().getValueCount();
    }

    public Integer getNumOfAltesInPCs() {
        return this.getAlteInPCs().size();
    }

    public Double getEvaluationValue(Alternative alternative, Criterion criterion) {
        return this.getAlteValues().getValue((Object)alternative, (Object)criterion);
    }

    public Integer getPrefDirValue(Criterion criterion) {
        String dir = this.getCritScales().get(criterion).getPreferenceDirection().toString();
        if (dir.toLowerCase().contains("max")) {
            return 1;
        }
        if (dir.toLowerCase().contains("min")) {
            return -1;
        }
        return 0;
    }

    public Integer getCompType(Alternative right, Alternative left) {
        return (int)this.getPairComps().getValue((Object)right, (Object)left);
    }

    public ArrayList<Alternative> getListOfAlternatives() {
        return new ArrayList<Alternative>(this.getAlteSet());
    }

    public ArrayList<Criterion> getListOfCriteria() {
        return new ArrayList<Criterion>(this.getCritSet());
    }

    public ArrayList<Alternative> getListOfRefPts() {
        return new ArrayList<Alternative>(this.getRefPtsSet());
    }

    public ArrayList<Double> getListOfWeights() {
        return new ArrayList<Double>(this.getWeights().values());
    }

    public ArrayList<Alternative> getListOfAltesInPCs() {
        return new ArrayList<Alternative>(this.getAlteInPCs());
    }

    public ArrayList<Table.Cell<Alternative, Alternative, Double>> getListOfPairComps() {
        return new ArrayList<Table.Cell<Alternative, Alternative, Double>>(this.getPairComps().asTable().cellSet());
    }

    public void displayAlternatives() {
        OutputUtils.lscln("[Re] Alternatives:");
        if (this.getAlteSet() != null) {
            for (Alternative alte : this.getAlteSet()) {
                String id = alte.getId();
                OutputUtils.lscln("    Id: " + id + ": " + this.getAlteNames().get(alte));
            }
        }
    }

    public void outputAlternatives() {
        OutputUtils.lsln("[Re] Alternatives:");
        if (this.getAlteSet() != null) {
            for (Alternative alte : this.getAlteSet()) {
                String id = alte.getId();
                OutputUtils.lsln("    Id: " + id + ": " + this.getAlteNames().get(alte));
            }
        }
    }

    public void displayCriteria() {
        OutputUtils.lscln("[Re] Criteria:");
        if (this.getCritSet() != null) {
            for (Criterion crit : this.getCritSet()) {
                String id = crit.getId();
                OutputUtils.lscln("    Id: " + id + ": " + this.getCritNames().get(crit) + "(" + this.getCritScales().get(crit).getPreferenceDirection().toString().toLowerCase() + " Max = " + this.getCritScales().get(crit).getMaximum() + " Min = " + this.getCritScales().get(crit).getMinimum() + ")");
            }
        }
    }

    public void outputCriteria() {
        OutputUtils.lsln("[Re] Criteria:");
        if (this.getCritSet() != null) {
            for (Criterion crit : this.getCritSet()) {
                String id = crit.getId();
                OutputUtils.lsln("    Id: " + id + ": " + this.getCritNames().get(crit) + "(" + this.getCritScales().get(crit).getPreferenceDirection().toString().toLowerCase() + " Max = " + this.getCritScales().get(crit).getMaximum() + " Min = " + this.getCritScales().get(crit).getMinimum() + ")");
            }
        }
    }

    public void displayEvaluations() {
        OutputUtils.lsc("[Re] Alternative performance table:\n    \t");
        if (this.getAlteValues() != null) {
            for (Criterion crit : this.getAlteValues().getColumns()) {
                OutputUtils.lsc("\t" + crit.getId());
            }
            OutputUtils.lscln("");
            for (Alternative alte : this.getAlteValues().getRows()) {
                OutputUtils.lsc("\t" + alte.getId());
                for (Criterion crit : this.getAlteValues().getColumns()) {
                    OutputUtils.lsc("\t" + this.getAlteValues().getValue((Object)alte, (Object)crit));
                }
                OutputUtils.lscln("");
            }
        }
    }

    public void outputEvaluations() {
        OutputUtils.ls("[Re] Alternative performance table:\n    \t");
        if (this.getAlteValues() != null) {
            for (Criterion crit : this.getAlteValues().getColumns()) {
                OutputUtils.ls("\t" + crit.getId());
            }
            OutputUtils.lsln("");
            for (Alternative alte : this.getAlteValues().getRows()) {
                OutputUtils.ls("\t" + alte.getId());
                for (Criterion crit : this.getAlteValues().getColumns()) {
                    OutputUtils.ls("\t" + this.getAlteValues().getValue((Object)alte, (Object)crit));
                }
                OutputUtils.lsln("");
            }
        }
    }

    public void displayWeights() {
        OutputUtils.lscln("[Re] Criteria weights:");
        if (this.getWeights() != null) {
            for (Criterion crit : this.getWeights().keySet()) {
                Float val = Float.valueOf(Float.parseFloat(OutputUtils.centi.format(this.getWeights().get(crit))));
                OutputUtils.lsc("    " + crit.getId() + ":" + val);
            }
            OutputUtils.lscln("");
        }
    }

    public void outputWeights() {
        OutputUtils.lsln("[Re] Criteria weights:");
        if (this.getWeights() != null) {
            for (Criterion crit : this.getWeights().keySet()) {
                Float val = Float.valueOf(Float.parseFloat(OutputUtils.centi.format(this.getWeights().get(crit))));
                OutputUtils.ls("    " + crit.getId() + ":" + val);
            }
            OutputUtils.lsln("");
        }
    }

    public void displayRefPts() {
        OutputUtils.lscln("[Re] Configuration of the reference points:");
        if (this.getRefPtsSet() != null) {
            for (Criterion crit : this.getRefPtsValues().getColumns()) {
                OutputUtils.lsc("\t" + crit.getId());
            }
            OutputUtils.lscln("");
            for (Alternative p : this.getRefPtsValues().getRows()) {
                OutputUtils.lsc("    " + p.getId());
                for (Criterion crit : this.getRefPtsValues().getColumns()) {
                    OutputUtils.lsc("\t" + OutputUtils.centi.format(this.getRefPtsValues().getValue((Object)p, (Object)crit)));
                }
                OutputUtils.lscln("");
            }
        }
    }

    public void outputRefPts() {
        OutputUtils.lsln("[Re] Configuration of the reference points:");
        if (this.getRefPtsSet() != null) {
            for (Criterion crit : this.getRefPtsValues().getColumns()) {
                OutputUtils.ls("\t" + crit.getId());
            }
            OutputUtils.lsln("");
            for (Alternative p : this.getRefPtsValues().getRows()) {
                OutputUtils.ls("    " + p.getId());
                for (Criterion crit : this.getRefPtsValues().getColumns()) {
                    OutputUtils.ls("\t" + OutputUtils.centi.format(this.getRefPtsValues().getValue((Object)p, (Object)crit)));
                }
                OutputUtils.lsln("");
            }
        }
    }

    public void displayLexico() {
        if (this.getLexico() != null) {
            OutputUtils.lscln("[Re] Lexicographic order of reference points:" + this.getLexico());
        }
    }

    public void outputLexico() {
        if (this.getLexico() != null) {
            OutputUtils.lsln("[Re] Lexicographic order of reference points:" + this.getLexico());
        }
    }

    public void displayEvalsOfAltesInPCs() {
        OutputUtils.lsc("[Re] Evaluation of the alternatives involved in pairwise comparisons:\n    \t");
        if (this.getAlteInPCs() != null) {
            for (Criterion crit : this.getAlteValues().getColumns()) {
                OutputUtils.lsc("\t" + crit.getId());
            }
            OutputUtils.lscln("");
            for (Alternative alte : this.getAlteInPCs()) {
                OutputUtils.lsc("\t" + alte.getId());
                for (Criterion crit : this.getAlteValues().getColumns()) {
                    OutputUtils.lsc("\t" + this.getEvaluationValue(alte, crit));
                }
                OutputUtils.lscln("");
            }
        }
    }

    public void outputEvalsOfAltesInPCs() {
        OutputUtils.ls("[Re] Evaluation of the alternatives involved in pairwise comparisons:\n    \t");
        if (this.getAlteInPCs() != null) {
            for (Criterion crit : this.getAlteValues().getColumns()) {
                OutputUtils.ls("\t" + crit.getId());
            }
            OutputUtils.lsln("");
            for (Alternative alte : this.getAlteInPCs()) {
                OutputUtils.ls("\t" + alte.getId());
                for (Criterion crit : this.getAlteValues().getColumns()) {
                    OutputUtils.ls("\t" + this.getEvaluationValue(alte, crit));
                }
                OutputUtils.lsln("");
            }
        }
    }

    public void displayPairComps() {
        OutputUtils.lscln("[Re] Reference pairwise comparisons:");
        if (this.getPairComps() != null) {
            int n = 1;
            for (Table.Cell cell : this.getPairComps().asTable().cellSet()) {
                Alternative alteHigh = (Alternative)cell.getRowKey();
                Alternative alteLow = (Alternative)cell.getColumnKey();
                if ((Double)cell.getValue() == 1.0) {
                    OutputUtils.lscln("    " + n + ": " + alteHigh.getId() + " > " + alteLow.getId());
                }
                if ((Double)cell.getValue() == -1.0) {
                    OutputUtils.lscln("    " + n + ": " + alteLow.getId() + " > " + alteHigh.getId());
                }
                if ((Double)cell.getValue() == 0.0) {
                    OutputUtils.lscln("    " + n + ": " + alteHigh.getId() + " ~ " + alteLow.getId());
                }
                ++n;
            }
        }
    }

    public void outputPairComps() {
        OutputUtils.lsln("[Re] Reference pairwise comparisons:");
        if (this.getPairComps() != null) {
            int n = 1;
            for (Table.Cell cell : this.getPairComps().asTable().cellSet()) {
                Alternative alteHigh = (Alternative)cell.getRowKey();
                Alternative alteLow = (Alternative)cell.getColumnKey();
                if ((Double)cell.getValue() == 1.0) {
                    OutputUtils.lsln("    " + n + ": " + alteHigh.getId() + " > " + alteLow.getId());
                }
                if ((Double)cell.getValue() == -1.0) {
                    OutputUtils.lsln("    " + n + ": " + alteLow.getId() + " > " + alteHigh.getId());
                }
                if ((Double)cell.getValue() == 0.0) {
                    OutputUtils.lsln("    " + n + ": " + alteHigh.getId() + " ~ " + alteLow.getId());
                }
                ++n;
            }
        }
    }

    @Deprecated
    public void displayRefRanking() {
        OutputUtils.lscln("[Re] Reference ranking list:");
        if (this.getPairComps() != null) {
            OutputUtils.lscln(RankingUtils.getRanking(this.getPairComps()).toString());
        }
    }

    @Deprecated
    public void outputRefRanking() {
        OutputUtils.lsln("[Re] Reference ranking list:");
        if (this.getPairComps() != null) {
            OutputUtils.lsln(RankingUtils.getRanking(this.getPairComps()).toString());
        }
    }

    public void displayGlobalRanking() {
        OutputUtils.lscln("[Re] Global ranking list:");
        if (this.getBinComps() != null) {
            OutputUtils.lscln(RankingUtils.getRanking(this.getBinComps()).toString());
        }
    }

    public void outputGlobalRanking() {
        OutputUtils.lsln("[Re] Global ranking list:");
        if (this.getBinComps() != null) {
            OutputUtils.lsln(RankingUtils.getRanking(this.getBinComps()).toString());
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public Set<Alternative> getAlteSet() {
        return this.alteSet;
    }

    public Map<Alternative, String> getAlteNames() {
        return this.alteNames;
    }

    public Evaluations getAlteValues() {
        return this.alteValues;
    }

    public Set<Criterion> getCritSet() {
        return this.critSet;
    }

    public Map<Criterion, String> getCritNames() {
        return this.critNames;
    }

    public Map<Criterion, Interval> getCritScales() {
        return this.critScales;
    }

    public Map<Criterion, Double> getWeights() {
        return this.weights;
    }

    public Set<Alternative> getRefPtsSet() {
        return this.refPtsSet;
    }

    public Evaluations getRefPtsValues() {
        return this.refPtsValues;
    }

    public ArrayList<Integer> getLexico() {
        return this.lexico;
    }

    public Set<Alternative> getAlteInPCs() {
        return this.alteInPCs;
    }

    public SparseMatrixD<Alternative, Alternative> getBinComps() {
        return this.binComps;
    }

    public SparseMatrixD<Alternative, Alternative> getPairComps() {
        return this.pairComps;
    }

    protected void setStatus(Status status) {
        this.status = status;
    }

    protected void setAlteSet(Set<Alternative> alteSet) {
        this.alteSet = alteSet;
        this.setStatus(Status.overwritten);
    }

    protected void setAlteNames(Map<Alternative, String> alteNames) {
        this.alteNames = alteNames;
        this.setStatus(Status.overwritten);
    }

    protected void setAlteValues(Evaluations alteValues) {
        this.alteValues = alteValues;
        this.setStatus(Status.overwritten);
    }

    protected void setCritSet(Set<Criterion> critSet) {
        this.critSet = critSet;
        this.setStatus(Status.overwritten);
    }

    protected void setCritNames(Map<Criterion, String> critNames) {
        this.critNames = critNames;
        this.setStatus(Status.overwritten);
    }

    protected void setCritScales(Map<Criterion, Interval> critScales) {
        this.critScales = critScales;
        this.setStatus(Status.overwritten);
    }

    public void setWeights(Map<Criterion, Double> weights) {
        this.weights = weights;
        this.setStatus(Status.overwritten);
    }

    public void setRefPtsSet(Set<Alternative> refPtsSet) {
        this.refPtsSet = refPtsSet;
        this.setStatus(Status.overwritten);
    }

    public void setRefPtsValues(Evaluations refPtsValues) {
        this.refPtsValues = refPtsValues;
        this.setStatus(Status.overwritten);
    }

    public void setLexico(ArrayList<Integer> lexico) {
        this.lexico = lexico;
        this.setStatus(Status.overwritten);
    }

    protected void setAlteInPCs(Set<Alternative> alteInPCs) {
        this.alteInPCs = alteInPCs;
        this.setStatus(Status.overwritten);
    }

    protected void setBinComps(SparseMatrixD<Alternative, Alternative> binComps) {
        this.binComps = binComps;
        this.setStatus(Status.overwritten);
    }

    protected void setPairComps(SparseMatrixD<Alternative, Alternative> pairComps) {
        this.pairComps = pairComps;
        this.setStatus(Status.overwritten);
    }

    public static enum Status {
        initialized,
        loaded,
        generated,
        overwritten;

    }
}

