/*
 * Decompiled with CFR 0.152.
 */
import Xmcda_by_Dhouha.Criteria;
import Xmcda_by_Dhouha.CriteriaComparisons;
import Xmcda_by_Dhouha.JDOM_Criteria;
import Xmcda_by_Dhouha.JDOM_Criteria_Comparisons;
import Xmcda_by_Dhouha.Main;
import Xmcda_by_Dhouha.XmcdaMessage;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class TransReducCriterCom {
    private String warningMessage = "";

    public boolean checkFiles(Criteria criter, CriteriaComparisons criterComp) {
        int size2;
        boolean result = true;
        int diff = 0;
        int size1 = criter.getCriteriaIDs().size();
        if (size1 == (size2 = criterComp.getListCriteriaIDs().size())) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < size2) {
                list.add(criterComp.getListCriteriaIDs().get(i));
                ++i;
            }
            for (String s : criter.getCriteriaIDs()) {
                if (list.contains(s)) continue;
                result = false;
                ++diff;
            }
            if (diff > 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criteriaComparisons tag. There are " + diff + " different criteria.");
            }
            if (diff == 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criteriaComparisons tag. There is one different criterion.");
            }
        } else {
            result = false;
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the number of criteria given in the file containing the criteriaComparisons tag.");
        }
        return result;
    }

    public ArrayList<String> getIntersectionCriteriaIDs(Criteria criter, CriteriaComparisons criterComp) {
        ArrayList<String> listintersection = new ArrayList<String>();
        for (String t : criterComp.getListCriteriaIDs()) {
            if (!criter.getCriteriaIDs().contains(t)) continue;
            listintersection.add(t);
        }
        listintersection = new ArrayList(new TreeSet(listintersection));
        return listintersection;
    }

    public GraphVizCritTransRedu createGraphiz(ArrayList<String> CriteriaIDs, CriteriaComparisons criterComp) {
        GraphVizCritTransRedu gv = new GraphVizCritTransRedu();
        gv.addln(gv.start_graph());
        int i = 0;
        while (i < CriteriaIDs.size()) {
            int index_matrix_line = criterComp.getListCriteriaIDs().indexOf(CriteriaIDs.get(i));
            int j = 0;
            while (j < criterComp.getListCriteriaIDs().size()) {
                if (CriteriaIDs.contains(criterComp.getListCriteriaIDs().get(j)) && criterComp.getMatrix()[index_matrix_line][j] != -2000.0f) {
                    gv.addln(String.valueOf(CriteriaIDs.get(i)) + " -> " + criterComp.getListCriteriaIDs().get(j) + ";");
                }
                ++j;
            }
            ++i;
        }
        gv.addln(gv.end_graph());
        return gv;
    }

    public CriteriaComparisons parseDotFile(File dot) {
        CriteriaComparisons criterComp = new CriteriaComparisons();
        try {
            FileInputStream fis = new FileInputStream(dot.getAbsolutePath());
            DataInputStream dis = new DataInputStream(fis);
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            StringTokenizer st = new StringTokenizer(br.readLine());
            int i = 0;
            String[] mot = new String[st.countTokens()];
            while (st.hasMoreTokens()) {
                mot[i] = st.nextToken();
                ++i;
            }
            int r = 5;
            while (r < mot.length) {
                mot[r] = mot[r].replaceAll(";", "");
                r += 3;
            }
            mot[mot.length - 1] = mot[mot.length - 1].replaceAll("}", "");
            int debut = 3;
            int fin = 5;
            while (debut < mot.length && fin < mot.length) {
                String initial_ID = mot[debut];
                String final_ID = mot[fin];
                if (!criterComp.getListCriteriaIDs().contains(initial_ID)) {
                    criterComp.addCriterionID(initial_ID);
                }
                if (!criterComp.getListCriteriaIDs().contains(final_ID)) {
                    criterComp.addCriterionID(final_ID);
                }
                criterComp.updateMatrix(criterComp.getListCriteriaIDs().indexOf(initial_ID), criterComp.getListCriteriaIDs().indexOf(final_ID));
                debut += 3;
                fin += 3;
            }
            br.close();
            dis.close();
            fis.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return criterComp;
    }

    public static void main(String[] argv) {
        String pathCriteria = argv[0];
        String pathCriteriaComparisons = argv[1];
        boolean stopRunning = false;
        String errorMessage = "";
        if (argv[0] == null || argv[1] == null || argv.length != 4 || !new File(argv[0]).exists() || !new File(argv[1]).exists()) {
            stopRunning = true;
            errorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
        }
        if (!stopRunning) {
            String errCriteriaComparisons;
            Main mainFunction = new Main();
            String errCriteria = mainFunction.checkEntryFile(pathCriteria);
            if (errCriteria != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
            }
            if ((errCriteriaComparisons = mainFunction.checkEntryFile(pathCriteriaComparisons)) != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteriaComparisons tag is not a valid XMCDA document.");
                System.out.println("error :" + errCriteriaComparisons);
            }
            if (errCriteria != "" || errCriteriaComparisons != "") {
                XmcdaMessage xmcdaMess = new XmcdaMessage();
                xmcdaMess.createErrorMessage(errorMessage);
                String pathOutputMessage = argv[3];
                xmcdaMess.enregistre(pathOutputMessage);
            } else {
                TransReducCriterCom transitiveReduction = new TransReducCriterCom();
                if (mainFunction.getWarningMessage() != "") {
                    transitiveReduction.warningMessage = transitiveReduction.warningMessage.concat(mainFunction.getWarningMessage());
                }
                mainFunction.PrepareParsing(pathCriteria);
                Criteria criteriaToUse = new Criteria();
                JDOM_Criteria jdomCriter = new JDOM_Criteria();
                boolean parseCriteriaNull = false;
                criteriaToUse = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
                if (criteriaToUse == null) {
                    parseCriteriaNull = true;
                    errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the criteria tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty.");
                }
                if (jdomCriter.getWarning() != "") {
                    transitiveReduction.warningMessage = transitiveReduction.warningMessage.concat("\n" + jdomCriter.getWarning());
                }
                mainFunction.PrepareParsing(pathCriteriaComparisons);
                CriteriaComparisons criterCompaToUse = new CriteriaComparisons();
                JDOM_Criteria_Comparisons jdomCriterComp = new JDOM_Criteria_Comparisons();
                boolean parseCriterCompNull = false;
                criterCompaToUse = jdomCriterComp.exploreCriteriaComparisonsXML(mainFunction.getRacine());
                if (criterCompaToUse == null) {
                    parseCriterCompNull = true;
                    errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the criteriaComparisons tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the criteriaComparisons tag is erroneous or empty.");
                }
                if (jdomCriterComp.getWarningMessage() != "") {
                    transitiveReduction.warningMessage = transitiveReduction.warningMessage.concat("\n" + jdomCriterComp.getWarningMessage());
                }
                if (!parseCriterCompNull && !parseCriteriaNull) {
                    transitiveReduction.checkFiles(criteriaToUse, criterCompaToUse);
                    ArrayList<String> listintersectionCriterIDs = transitiveReduction.getIntersectionCriteriaIDs(criteriaToUse, criterCompaToUse);
                    if (listintersectionCriterIDs.isEmpty()) {
                        transitiveReduction.warningMessage = transitiveReduction.warningMessage.concat("\nOnly the criteria IDs in the file containing the criteriaComparisons tag will be considered. Please check your input file containing the criteria tag.");
                        int i = 0;
                        while (i < criterCompaToUse.getListCriteriaIDs().size()) {
                            listintersectionCriterIDs.add(criterCompaToUse.getListCriteriaIDs().get(i));
                            ++i;
                        }
                    }
                    if (listintersectionCriterIDs.isEmpty()) {
                        XmcdaMessage xmcdaMess = new XmcdaMessage();
                        errorMessage = errorMessage.concat("Failure to run the algorithm because it seems that the file containing the criteriaComparisons tag is empty or erroneous.");
                        xmcdaMess.createLogMessagePlotCriteriaComparisons(errCriteria, errCriteriaComparisons, transitiveReduction.warningMessage, errorMessage);
                        String pathOutputMessage = argv[3];
                        xmcdaMess.enregistre(pathOutputMessage);
                    } else {
                        String type2 = "dot";
                        GraphVizCritTransRedu initialGraph = transitiveReduction.createGraphiz(listintersectionCriterIDs, criterCompaToUse);
                        File reduction = initialGraph.getGraph(initialGraph.getDotSource(), type2);
                        CriteriaComparisons criterCompAfterReduction = transitiveReduction.parseDotFile(reduction);
                        XmcdaMessage xmcdaMess = new XmcdaMessage();
                        xmcdaMess.createLogMessagePlotCriteriaComparisons(errCriteria, errCriteriaComparisons, transitiveReduction.warningMessage, errorMessage);
                        String pathOutputMessage = argv[3];
                        xmcdaMess.enregistre(pathOutputMessage);
                        String pathOutputFile = argv[2];
                        String commentToPut = "transitive reduction of criteria comparisons";
                        OutputCriteriaCompReduc outputFile = new OutputCriteriaCompReduc();
                        outputFile.createFile(criterCompAfterReduction, commentToPut);
                        outputFile.saveFile(pathOutputFile);
                    }
                } else {
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    xmcdaMess.createErrorMessage(errorMessage);
                    String pathOutputMessage = argv[3];
                    xmcdaMess.enregistre(pathOutputMessage);
                }
            }
        } else {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            String pathOutputMessage = argv[3];
            xmcdaMess.enregistre(pathOutputMessage);
        }
    }
}

