/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class GraphVizCritTransRedu {
    private static String TRED = "tred";
    private StringBuilder graph = new StringBuilder();

    public String getDotSource() {
        return this.graph.toString();
    }

    public void add(String line) {
        this.graph.append(line);
    }

    public void addln(String line) {
        this.graph.append(String.valueOf(line) + "\n");
    }

    public void addln() {
        this.graph.append('\n');
    }

    public File getGraph(String dot_source, String type2) {
        try {
            File dot = this.writeDotSourceToFile(dot_source);
            if (dot != null) {
                File dotReduc = this.get_dot_stream(dot, type2);
                if (!dot.delete()) {
                    System.err.println("Warning: " + dot.getAbsolutePath() + " could not be deleted.");
                }
                return dotReduc;
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private File get_dot_stream(File dot, String type2) {
        File fileDot = null;
        try {
            fileDot = File.createTempFile("graph_", "." + type2, new File(System.getProperty("java.io.tmpdir")));
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(new String[]{TRED, dot.getAbsolutePath()});
            DataInputStream ls_in = new DataInputStream(p.getInputStream());
            FileWriter fout = new FileWriter(fileDot);
            try {
                String ls_str;
                while ((ls_str = ls_in.readLine()) != null) {
                    fout.write(ls_str);
                }
            }
            catch (IOException e) {
                System.exit(0);
            }
            fout.flush();
            fout.close();
            p.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileDot;
    }

    private File writeDotSourceToFile(String str) throws IOException {
        File temp;
        try {
            temp = File.createTempFile("graph_", ".dot.tmp", new File(System.getProperty("java.io.tmpdir")));
            FileWriter fout = new FileWriter(temp);
            fout.write(str);
            fout.close();
        }
        catch (Exception e) {
            System.err.println("Error: I/O error while writing the dot source to temp file.");
            return null;
        }
        return temp;
    }

    public String start_graph() {
        return "digraph G {";
    }

    public String end_graph() {
        return "}";
    }
}

