/*
 * Decompiled with CFR 0.152.
 */
import Xmcda_by_Dhouha.Alternatives;
import Xmcda_by_Dhouha.AlternativesComparisons;
import Xmcda_by_Dhouha.JDOM_Alternatives;
import Xmcda_by_Dhouha.JDOM_Alternatives_Comparisons;
import Xmcda_by_Dhouha.Main;
import Xmcda_by_Dhouha.XmcdaMessage;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class transReduc {
    private String warningMessage = "";

    public boolean checkFiles(Alternatives alter, AlternativesComparisons alternComp) {
        int size2;
        boolean result = true;
        int diff = 0;
        int size1 = alter.getAlternativeIDs().size();
        if (size1 == (size2 = alternComp.getListAlternativesIDs().size())) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < size2) {
                list.add(alternComp.getListAlternativesIDs().get(i));
                ++i;
            }
            for (String s : alter.getAlternativeIDs()) {
                if (list.contains(s)) continue;
                result = false;
                ++diff;
            }
            if (diff > 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the alternativesComparisons tag. There are " + diff + " different alternatives.");
            }
            if (diff == 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the alternativesComparisons tag. There is one different alternative.");
            }
        } else {
            result = false;
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the alternatives tag:incoherence with the number of alternatives given in the file containing the alternativesComparisons tag.");
        }
        return result;
    }

    public ArrayList<String> getIntersectionAlternativesIDs(Alternatives alter, AlternativesComparisons alternComp) {
        ArrayList<String> listintersection = new ArrayList<String>();
        for (String t : alternComp.getListAlternativesIDs()) {
            if (!alter.getAlternativeIDs().contains(t)) continue;
            listintersection.add(t);
        }
        listintersection = new ArrayList(new TreeSet(listintersection));
        return listintersection;
    }

    public GraphViz createGraphiz(ArrayList<String> AlternIDs, AlternativesComparisons alternComp) {
        GraphViz gv = new GraphViz();
        gv.addln(gv.start_graph());
        int i = 0;
        while (i < AlternIDs.size()) {
            int index_matrix_line = alternComp.getListAlternativesIDs().indexOf(AlternIDs.get(i));
            int j = 0;
            while (j < alternComp.getListAlternativesIDs().size()) {
                if (AlternIDs.contains(alternComp.getListAlternativesIDs().get(j)) && alternComp.getMatrix()[index_matrix_line][j] != -2000.0f) {
                    gv.addln(String.valueOf(AlternIDs.get(i)) + " -> " + alternComp.getListAlternativesIDs().get(j) + ";");
                }
                ++j;
            }
            ++i;
        }
        gv.addln(gv.end_graph());
        return gv;
    }

    public AlternativesComparisons parseDotFile(File dot) {
        AlternativesComparisons altComp = new AlternativesComparisons();
        try {
            FileInputStream fis = new FileInputStream(dot.getAbsolutePath());
            DataInputStream dis = new DataInputStream(fis);
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            StringTokenizer st = new StringTokenizer(br.readLine());
            int i = 0;
            String[] mot = new String[st.countTokens()];
            while (st.hasMoreTokens()) {
                mot[i] = st.nextToken();
                ++i;
            }
            int r = 5;
            while (r < mot.length) {
                mot[r] = mot[r].replaceAll(";", "");
                r += 3;
            }
            mot[mot.length - 1] = mot[mot.length - 1].replaceAll("}", "");
            int debut = 3;
            int fin = 5;
            while (debut < mot.length && fin < mot.length) {
                String initial_ID = mot[debut];
                String final_ID = mot[fin];
                if (!altComp.getListAlternativesIDs().contains(initial_ID)) {
                    altComp.addAlternativeID(initial_ID);
                }
                if (!altComp.getListAlternativesIDs().contains(final_ID)) {
                    altComp.addAlternativeID(final_ID);
                }
                altComp.updateMatrix(altComp.getListAlternativesIDs().indexOf(initial_ID), altComp.getListAlternativesIDs().indexOf(final_ID));
                debut += 3;
                fin += 3;
            }
            br.close();
            dis.close();
            fis.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return altComp;
    }

    public static void main(String[] argv) {
        String pathAlternatives = argv[0];
        String pathAlternativesComparisons = argv[1];
        boolean stopRunning = false;
        String errorMessage = "";
        if (argv[0] == null || argv[1] == null || argv.length != 4 || !new File(argv[0]).exists() || !new File(argv[1]).exists()) {
            stopRunning = true;
            errorMessage = "Error: unable to run the algorithm. Reason: one (or more) missing entry file(s). Please check your entry files.";
        }
        if (!stopRunning) {
            String errAlternativesComparisons;
            Main mainFunction = new Main();
            String errAlternatives = mainFunction.checkEntryFile(pathAlternatives);
            if (errAlternatives != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.");
            }
            if ((errAlternativesComparisons = mainFunction.checkEntryFile(pathAlternativesComparisons)) != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the alternativesComparisons tag is not a valid XMCDA document.");
            }
            if (errAlternatives != "" || errAlternativesComparisons != "") {
                XmcdaMessage xmcdaMess = new XmcdaMessage();
                xmcdaMess.createErrorMessage(errorMessage);
                String pathOutputMessage = argv[3];
                xmcdaMess.enregistre(pathOutputMessage);
            } else {
                transReduc transitiveReduction = new transReduc();
                if (mainFunction.getWarningMessage() != "") {
                    transitiveReduction.warningMessage = transitiveReduction.warningMessage.concat(mainFunction.getWarningMessage());
                }
                mainFunction.PrepareParsing(pathAlternatives);
                Alternatives alternativesToUse = new Alternatives();
                JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
                boolean parseAlternativesNull = false;
                alternativesToUse = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
                if (alternativesToUse == null) {
                    parseAlternativesNull = true;
                    errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
                }
                if (jdomAlter.getWarning() != "") {
                    transitiveReduction.warningMessage = transitiveReduction.warningMessage.concat("\n" + jdomAlter.getWarning());
                }
                mainFunction.PrepareParsing(pathAlternativesComparisons);
                AlternativesComparisons alternCompaToUse = new AlternativesComparisons();
                JDOM_Alternatives_Comparisons jdomAlterComp = new JDOM_Alternatives_Comparisons();
                boolean parseAlternCompNull = false;
                alternCompaToUse = jdomAlterComp.exploreAlternativesComparisonsXML(mainFunction.getRacine());
                if (alternCompaToUse == null) {
                    parseAlternCompNull = true;
                    errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the alternativesComparisons tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the alternativesComparisons tag is erroneous or empty.");
                }
                if (jdomAlterComp.getWarningMessage() != "") {
                    transitiveReduction.warningMessage = transitiveReduction.warningMessage.concat("\n" + jdomAlterComp.getWarningMessage());
                }
                if (!parseAlternCompNull && !parseAlternativesNull) {
                    transitiveReduction.checkFiles(alternativesToUse, alternCompaToUse);
                    ArrayList<String> listintersectionAlternIDs = transitiveReduction.getIntersectionAlternativesIDs(alternativesToUse, alternCompaToUse);
                    if (listintersectionAlternIDs.isEmpty()) {
                        transitiveReduction.warningMessage = transitiveReduction.warningMessage.concat("\nOnly the alternatives IDs in the file containing the alternativesComparisons tag will be considered. Please check your input file containing the alternatives tag.");
                        int i = 0;
                        while (i < alternCompaToUse.getListAlternativesIDs().size()) {
                            listintersectionAlternIDs.add(alternCompaToUse.getListAlternativesIDs().get(i));
                            ++i;
                        }
                    }
                    if (listintersectionAlternIDs.isEmpty()) {
                        XmcdaMessage xmcdaMess = new XmcdaMessage();
                        errorMessage = errorMessage.concat("Failure to run the algorithm because it seems that the file containing the alternativesComparisons tag is empty or erroneous.");
                        xmcdaMess.createLogMessagePlotAlternativesComparisons(errAlternatives, errAlternativesComparisons, transitiveReduction.warningMessage, errorMessage);
                        String pathOutputMessage = argv[3];
                        xmcdaMess.enregistre(pathOutputMessage);
                    } else {
                        String type2 = "dot";
                        GraphViz initialGraph = transitiveReduction.createGraphiz(listintersectionAlternIDs, alternCompaToUse);
                        File reduction = initialGraph.getGraph(initialGraph.getDotSource(), type2);
                        AlternativesComparisons alterCompAfterReduction = transitiveReduction.parseDotFile(reduction);
                        XmcdaMessage xmcdaMess = new XmcdaMessage();
                        xmcdaMess.createLogMessagePlotAlternativesComparisons(errAlternatives, errAlternativesComparisons, transitiveReduction.warningMessage, errorMessage);
                        String pathOutputMessage = argv[3];
                        xmcdaMess.enregistre(pathOutputMessage);
                        String pathOutputFile = argv[2];
                        String commentToPut = "Alternatives comparisons transitive reduction";
                        OutputTransReduc outputFile = new OutputTransReduc();
                        outputFile.createFile(alterCompAfterReduction, commentToPut);
                        outputFile.saveFile(pathOutputFile);
                    }
                } else {
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    xmcdaMess.createErrorMessage(errorMessage);
                    String pathOutputMessage = argv[3];
                    xmcdaMess.enregistre(pathOutputMessage);
                }
            }
        } else {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            String pathOutputMessage = argv[3];
            xmcdaMess.enregistre(pathOutputMessage);
        }
    }
}

