/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.Criterion;
import eu.telecom_bretagne.xmcda.JDOM_Criteria;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.Point;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class PlotValFunction {
    private static final String BY_SQUARE = "By square";
    private static final String BY_LINE = "By line";
    private static final String BY_COLUMN = "By column";
    private String warningMessage = "";

    private static String title(Criterion criterion) {
        if (criterion.name() != null) {
            return String.valueOf(criterion.name()) + " (" + criterion.id() + ")";
        }
        return criterion.id();
    }

    public boolean checkFiles(Criteria criter, Criteria criteriaValFunc) {
        boolean result = true;
        int criterCommun = 0;
        if (criter.getCriteriaIDs().size() != criteriaValFunc.getCriteriaIDs().size()) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the number of criteria given in the file containing the criterionFunction tag.");
            return false;
        }
        int i = 0;
        while (i < criteriaValFunc.getCriteriaIDs().size()) {
            if (criteriaValFunc.getCriteriaIDs().contains(criter.getCriteriaIDs().get(i))) {
                ++criterCommun;
            } else {
                result = false;
            }
            ++i;
        }
        if (criterCommun > 1) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criterionFunction tags. There are only " + criterCommun + " identical criteria in both files.");
        }
        if (criterCommun == 1) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criterionFunction tags. There is one identical criterion in both files.");
        }
        return result;
    }

    public Criteria getIntersectionCriteria(Criteria criteria, Criteria criteriaValFunc) {
        ArrayList<String> listintersection = new ArrayList<String>();
        int i = 0;
        while (i < criteria.getCriteriaIDs().size()) {
            String id = criteria.getCriteriaIDs().get(i);
            if (!listintersection.contains(id)) {
                listintersection.add(id);
            }
            ++i;
        }
        listintersection.retainAll(criteriaValFunc.getCriteriaIDs());
        Criteria criteriaintersection = new Criteria();
        int i2 = 0;
        while (i2 < listintersection.size()) {
            Criterion criterion = new Criterion((String)listintersection.get(i2));
            criteriaintersection.add(criterion);
            int criterion_idx = criteriaValFunc.getCriteriaIDs().indexOf(listintersection.get(i2));
            ArrayList<Point> points = criteriaValFunc.getListCriteria().get(criterion_idx).getCriterionFunction().getPoints();
            int numberOfPoints = points.size();
            int j = 0;
            while (j < numberOfPoints) {
                float x = points.get(j).getAbscissa();
                float y = points.get(j).getOrdinate();
                criterion.getCriterionFunction().addPoint(new Point(x, y));
                ++j;
            }
            ++i2;
        }
        if (criteriaintersection.getCriteriaIDs().size() == 0) {
            this.warningMessage = this.warningMessage.concat("\nOnly the criteriaIDs in the file containing the criterionFunction tag will be considered. Please check your input file containing the criteria tag.");
            criteriaintersection = criteriaValFunc;
        }
        return criteriaintersection;
    }

    public Criteria getCriteriaFromValueFunctions(Criteria criteriaValFunc) {
        ArrayList<String> listintersection = new ArrayList<String>();
        int i = 0;
        while (i < criteriaValFunc.getCriteriaIDs().size()) {
            String id = criteriaValFunc.getCriteriaIDs().get(i);
            if (!listintersection.contains(id)) {
                listintersection.add(id);
            }
            ++i;
        }
        Criteria criteriaintersection = new Criteria();
        int i2 = 0;
        while (i2 < listintersection.size()) {
            Criterion criterion = new Criterion((String)listintersection.get(i2));
            criteriaintersection.add(criterion);
            int criterion_idx = criteriaValFunc.getCriteriaIDs().indexOf(listintersection.get(i2));
            ArrayList<Point> points = criteriaValFunc.getListCriteria().get(criterion_idx).getCriterionFunction().getPoints();
            int numberOfPoints = points.size();
            int j = 0;
            while (j < numberOfPoints) {
                float x = criteriaValFunc.getListCriteria().get(i2).getCriterionFunction().getPoints().get(j).getAbscissa();
                float y = criteriaValFunc.getListCriteria().get(i2).getCriterionFunction().getPoints().get(j).getOrdinate();
                criterion.getCriterionFunction().addPoint(new Point(x, y));
                ++j;
            }
            ++i2;
        }
        return criteriaintersection;
    }

    public void generatedPlot(Criterion criterion, boolean interpolation, Color color, String tempErrorMessage, boolean addBars, OutputStream outputStream) {
        LineChart line = new LineChart("", PlotValFunction.title(criterion), "", criterion, interpolation, color, addBars);
        line.saveChart(outputStream);
    }

    public void generatePlotByColumn(Criteria criteria, boolean interpolation, Color color, String tempErrorMessage, int size, boolean addBars, OutputStream outputStream) {
        ByteArrayOutputStream[] chart_png_image = new ByteArrayOutputStream[size];
        int index = 0;
        for (Criterion criterion : criteria) {
            chart_png_image[index] = new ByteArrayOutputStream();
            LineChartPlotsByLine plotsInLine = new LineChartPlotsByLine("", PlotValFunction.title(criterion), "", criterion, interpolation, color, addBars);
            plotsInLine.saveChart(chart_png_image[index]);
            ++index;
        }
        ImageGenerated imageConvert = new ImageGenerated();
        InputStream[] inputStream = new InputStream[size];
        int i = 0;
        while (i < size) {
            inputStream[i] = new ByteArrayInputStream(chart_png_image[i].toByteArray());
            ++i;
        }
        imageConvert.convertImageByColumn(inputStream, "png", size, outputStream);
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
    }

    public void generatePlotByLine(Criteria criteria, boolean interpolation, Color color, String tempErrorMessage, int size, boolean addBars, OutputStream outputStream) {
        ByteArrayOutputStream[] chart_png_image = new ByteArrayOutputStream[size];
        int index = 0;
        for (Criterion criterion : criteria) {
            chart_png_image[index] = new ByteArrayOutputStream();
            LineChartPlotsByLine plotsInLine = new LineChartPlotsByLine("", PlotValFunction.title(criterion), "", criterion, interpolation, color, addBars);
            plotsInLine.saveChart(chart_png_image[index]);
            ++index;
        }
        ImageGenerated imageConvert = new ImageGenerated();
        InputStream[] inputStream = new InputStream[size];
        int i = 0;
        while (i < size) {
            inputStream[i] = new ByteArrayInputStream(chart_png_image[i].toByteArray());
            ++i;
        }
        imageConvert.convertImageByLine(inputStream, "png", size, outputStream);
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
    }

    public void generatePlotBySquare(Criteria criteria, boolean interpolation, Color color, String tempErrorMessage, int size, boolean addBars, OutputStream outputStream) {
        ByteArrayOutputStream[] chart_png_image = new ByteArrayOutputStream[size];
        int index = 0;
        for (Criterion criterion : criteria) {
            chart_png_image[index] = new ByteArrayOutputStream();
            LineChartPlotsByLine plotsInLine = new LineChartPlotsByLine("", PlotValFunction.title(criterion), "", criterion, interpolation, color, addBars);
            plotsInLine.saveChart(chart_png_image[index]);
            ++index;
        }
        ImageGenerated imageConvert = new ImageGenerated();
        InputStream[] inputStream = new InputStream[size];
        int i = 0;
        while (i < size) {
            inputStream[i] = new ByteArrayInputStream(chart_png_image[i].toByteArray());
            ++i;
        }
        imageConvert.convertImageBySquare(inputStream, "png", size, outputStream);
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
    }

    protected static Color getColorFromOptions(boolean black_and_white, String colorToUse) {
        if (black_and_white) {
            return Color.black;
        }
        Color c = null;
        try {
            c = (Color)Color.class.getField(colorToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            return Color.black;
        }
        return c;
    }

    public static void main(String[] argv) {
        PlotValFunction plotValFunc;
        String errValueFunctions;
        String errCriteria;
        String out_messages;
        String errorMessage;
        block32: {
            String pathCriteria;
            errorMessage = "";
            if (argv.length != 5) {
                System.err.println("Usage: criteria.xml criteriaFunctions.xml parameters.xml criteriaFunctions.png messages.xml");
                System.err.println("       The 3 first files are inputs, the remaining ones are outputs");
                System.err.println("       criteria.xml may not exist.");
                System.exit(-1);
            }
            String in_criteria = new File(argv[0]).exists() ? argv[0] : null;
            String in_criteriaFunctions = argv[1];
            String in_parameters = argv[2];
            String out_criteriaFunctionsPlot = argv[3];
            out_messages = argv[4];
            if (!new File(in_parameters).exists() || !new File(in_criteriaFunctions).exists()) {
                errorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s).Please check your entry files.";
                XmcdaMessage.writeErrorMessage(errorMessage, out_messages);
                return;
            }
            String pathMethodParameters = in_parameters;
            String pathValueFunctions = in_criteriaFunctions;
            Main mainFunction = new Main();
            String errMethodParameters = mainFunction.checkEntryFile(pathMethodParameters);
            if (errMethodParameters != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the parameters is not a valid XMCDA document.");
            }
            errCriteria = "";
            if (in_criteria != null && new File(in_criteria).exists() && (errCriteria = mainFunction.checkEntryFile(pathCriteria = in_criteria)) != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteria is not a valid XMCDA document.");
            }
            if ((errValueFunctions = mainFunction.checkEntryFile(pathValueFunctions)) != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteria functions is not a valid XMCDA document.");
            }
            if (errMethodParameters != "" || errCriteria != "" || errValueFunctions != "") {
                XmcdaMessage.writeErrorMessage(errorMessage, out_messages);
                return;
            }
            plotValFunc = new PlotValFunction();
            if (mainFunction.getWarningMessage() != "") {
                plotValFunc.warningMessage = plotValFunc.warningMessage.concat(mainFunction.getWarningMessage());
            }
            Criteria criteria = new Criteria();
            if (in_criteria != null) {
                if (!new File(in_criteria).exists()) {
                    plotValFunc.warningMessage = String.valueOf(plotValFunc.warningMessage) + "\nCriteria argument specified but not present";
                } else {
                    String pathCriteria2 = in_criteria;
                    mainFunction.PrepareParsing(pathCriteria2);
                    JDOM_Criteria jdomCriter = new JDOM_Criteria();
                    criteria = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
                    if (criteria == null) {
                        errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteria is erroneous or empty.");
                    }
                    if (jdomCriter.getWarning() != "") {
                        plotValFunc.warningMessage = plotValFunc.warningMessage.concat("\n" + jdomCriter.getWarning());
                    }
                }
            }
            ParseFileCriterionFunction parsing = new ParseFileCriterionFunction();
            mainFunction.PrepareParsing(pathValueFunctions);
            Criteria criteriaFromValueFunctions = new Criteria();
            criteriaFromValueFunctions = parsing.exploreCriterionFunction(mainFunction.getRacine());
            if (criteriaFromValueFunctions == null) {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteria functions is erroneous or empty.");
            }
            if (parsing.getWarning() != "") {
                plotValFunc.warningMessage = plotValFunc.warningMessage.concat("\n" + parsing.getWarning());
            }
            methodParameters methodParam = new methodParameters();
            mainFunction.PrepareParsing(pathMethodParameters);
            boolean statusParseMethod = methodParam.parse(mainFunction.getRacine());
            if (!statusParseMethod) {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the parameters is erroneous or empty.");
            }
            if (criteriaFromValueFunctions == null || criteria == null || !statusParseMethod) {
                XmcdaMessage.writeErrorMessage(errorMessage, out_messages);
                return;
            }
            Criteria intersectionCriteria = new Criteria();
            intersectionCriteria = in_criteria != null ? plotValFunc.getIntersectionCriteria(criteria, criteriaFromValueFunctions) : plotValFunc.getCriteriaFromValueFunctions(criteriaFromValueFunctions);
            boolean color = methodParam.getColor();
            boolean linearInterpolation = methodParam.getInterpolation();
            String colorToUse = methodParam.getColorToUse();
            String plotsOrganisation = methodParam.getPlotsOrganisation();
            boolean uniquePlot = methodParam.getUniquePlot();
            boolean addBars = methodParam.getAddBars();
            Color colorPlot = Color.black;
            colorPlot = PlotValFunction.getColorFromOptions(!color, colorToUse);
            if (!uniquePlot) {
                plotsOrganisation = BY_COLUMN;
            }
            if (linearInterpolation) {
                addBars = false;
            }
            int size = intersectionCriteria.getListCriteria().size();
            if (intersectionCriteria.size() != 0) {
                if (!uniquePlot) {
                    String template = String.valueOf(out_criteriaFunctionsPlot.substring(0, out_criteriaFunctionsPlot.indexOf(46))) + "-%02d.png";
                    int idx = 1;
                    for (Criterion criterion : intersectionCriteria) {
                        FileOutputStream pngFOS;
                        File pngFile = new File(String.format(template, idx++));
                        try {
                            pngFOS = new FileOutputStream(pngFile);
                        }
                        catch (IOException ioe) {
                            errorMessage = errorMessage.concat("\nFatal Error: could not create output file " + pngFile.toString());
                            continue;
                        }
                        plotValFunc.generatedPlot(criterion, linearInterpolation, colorPlot, errorMessage, addBars, pngFOS);
                    }
                } else {
                    FileOutputStream pngFOS;
                    try {
                        pngFOS = new FileOutputStream(new File(out_criteriaFunctionsPlot));
                    }
                    catch (IOException ioe) {
                        errorMessage = errorMessage.concat("\nFatal Error: could not create output file " + out_criteriaFunctionsPlot);
                        break block32;
                    }
                    if (plotsOrganisation.equals(BY_COLUMN)) {
                        plotValFunc.generatePlotByColumn(intersectionCriteria, linearInterpolation, colorPlot, errorMessage, size, addBars, pngFOS);
                    } else if (plotsOrganisation.equals(BY_LINE)) {
                        plotValFunc.generatePlotByLine(intersectionCriteria, linearInterpolation, colorPlot, errorMessage, size, addBars, pngFOS);
                    } else if (plotsOrganisation.equals(BY_SQUARE)) {
                        plotValFunc.generatePlotBySquare(intersectionCriteria, linearInterpolation, colorPlot, errorMessage, size, addBars, pngFOS);
                    }
                }
            } else {
                errorMessage = errorMessage.concat("\n We cannot run the algorithm since the criteria list of the PROJECT is empty.\n");
            }
        }
        XmcdaMessage xmcdaMess = new XmcdaMessage();
        xmcdaMess.createLogMessagePlotValueFunctions(errCriteria, errValueFunctions, plotValFunc.warningMessage, errorMessage);
        String pathOutputMessage = out_messages;
        xmcdaMess.enregistre(pathOutputMessage);
    }
}

