/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.GestionIncoherentFiles;
import eu.telecom_bretagne.xmcda.MyValid;
import eu.telecom_bretagne.xmcda.PerformanceTable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class Main {
    static Document document;
    static Element racine;
    private String warningMessage = "";
    private boolean activateMatrixInt = false;
    private boolean activateMatrixReal = false;
    private String tempErrorMessage = "";

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public String getErrorMessage() {
        return this.tempErrorMessage;
    }

    public String checkEntryFile(String path) {
        String error = "";
        try {
            new MyValid().parseXML(path);
        }
        catch (JDOMException e) {
            error = error.concat("File is not well-formed: " + e.getMessage());
        }
        catch (IOException e) {
            error = error.concat("Could not check file because: " + e.getMessage());
        }
        return error;
    }

    public void PrepareParsing(String path) {
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(new File(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        racine = document.getRootElement();
    }

    public PerformanceTable run(PerformanceTable performanceTable, Criteria criteria, Alternatives alternatives) {
        List<Object> intersection;
        GestionIncoherentFiles gest = new GestionIncoherentFiles(criteria, alternatives, performanceTable);
        boolean checkAlt = gest.checkAlternatives(alternatives, performanceTable);
        boolean checkCrit = gest.checkCriteria(criteria, performanceTable);
        if (!checkAlt) {
            this.warningMessage = this.warningMessage.concat(gest.getWarningAlternatives());
        }
        if (!checkCrit) {
            this.warningMessage = this.warningMessage.concat(gest.getWarningCriteria());
        }
        if (checkAlt && checkCrit) {
            return performanceTable;
        }
        performanceTable = new PerformanceTable(performanceTable);
        if (!checkAlt) {
            intersection = performanceTable.alternatives();
            intersection.retainAll(alternatives.getListActiveAlternatives());
            if (intersection.isEmpty()) {
                this.warningMessage = this.warningMessage.concat("\nOnly the alternativesIDs in the file containing the performance table tag were considered. Please check your input file containing the alternatives tag.");
            } else {
                performanceTable.filterBy(alternatives);
            }
        }
        if (!checkCrit) {
            intersection = performanceTable.criteria();
            intersection.retainAll(criteria.getListCriteria());
            if (intersection.isEmpty()) {
                this.warningMessage = this.warningMessage.concat("\nOnly the criterionIDs in the file containing the performance table tag were considered. Please check your input file containing the criteria tag.");
            } else {
                performanceTable.filterBy(criteria);
            }
        }
        return performanceTable;
    }

    public boolean getActivateMatrixInt() {
        return this.activateMatrixInt;
    }

    public boolean getActivateMatrixReal() {
        return this.activateMatrixReal;
    }

    public Element getRacine() {
        return racine;
    }
}

