/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.CriteriaValues;
import eu.telecom_bretagne.xmcda.Criterion;
import eu.telecom_bretagne.xmcda.CriterionValue;
import eu.telecom_bretagne.xmcda.JDOM_Criteria;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.Point;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;

public class PlotValFunction {
    private String warningMessage = "";

    private static String title(Criterion criterion) {
        if (criterion.name() != null) {
            return String.valueOf(criterion.name()) + " (" + criterion.id() + ")";
        }
        return criterion.id();
    }

    public boolean checkFiles(Criteria criter, Criteria criteriaValFunc) {
        boolean result = true;
        int criterCommun = 0;
        if (criter.getCriteriaIDs().size() != criteriaValFunc.getCriteriaIDs().size()) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the number of criteria given in the file containing the criterionFunction tag.");
            return false;
        }
        int i = 0;
        while (i < criteriaValFunc.getCriteriaIDs().size()) {
            if (criteriaValFunc.getCriteriaIDs().contains(criter.getCriteriaIDs().get(i))) {
                ++criterCommun;
            } else {
                result = false;
            }
            ++i;
        }
        if (criterCommun > 1) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criterionFunction tags. There are only " + criterCommun + " identical criteria in both files.");
        }
        if (criterCommun == 1) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criterionFunction tags. There is one identical criterion in both files.");
        }
        return result;
    }

    public Criteria getIntersectionCriteria(Criteria criteria, Criteria criteriaValFunc) {
        ArrayList<String> listintersection = new ArrayList<String>();
        int i = 0;
        while (i < criteria.getCriteriaIDs().size()) {
            String id = criteria.getCriteriaIDs().get(i);
            if (!listintersection.contains(id)) {
                listintersection.add(id);
            }
            ++i;
        }
        listintersection.retainAll(criteriaValFunc.getCriteriaIDs());
        Criteria criteriaintersection = new Criteria();
        int i2 = 0;
        while (i2 < listintersection.size()) {
            Criterion criterion = new Criterion((String)listintersection.get(i2));
            criteriaintersection.add(criterion);
            int criterion_idx = criteriaValFunc.getCriteriaIDs().indexOf(listintersection.get(i2));
            ArrayList<Point> points = criteriaValFunc.getListCriteria().get(criterion_idx).getCriterionFunction().getPoints();
            int numberOfPoints = points.size();
            int j = 0;
            while (j < numberOfPoints) {
                float x = points.get(j).getAbscissa();
                float y = points.get(j).getOrdinate();
                criterion.getCriterionFunction().addPoint(new Point(x, y));
                ++j;
            }
            ++i2;
        }
        if (criteriaintersection.getCriteriaIDs().size() == 0) {
            this.warningMessage = this.warningMessage.concat("\nOnly the criteriaIDs in the file containing the criterionFunction tag will be considered. Please check your input file containing the criteria tag.");
            criteriaintersection = criteriaValFunc;
        }
        return criteriaintersection;
    }

    public Criteria getCriteriaFromValueFunctions(Criteria criteriaValFunc) {
        ArrayList<String> listintersection = new ArrayList<String>();
        int i = 0;
        while (i < criteriaValFunc.getCriteriaIDs().size()) {
            String id = criteriaValFunc.getCriteriaIDs().get(i);
            if (!listintersection.contains(id)) {
                listintersection.add(id);
            }
            ++i;
        }
        Criteria criteriaintersection = new Criteria();
        int i2 = 0;
        while (i2 < listintersection.size()) {
            Criterion criterion = new Criterion((String)listintersection.get(i2));
            criteriaintersection.add(criterion);
            int criterion_idx = criteriaValFunc.getCriteriaIDs().indexOf(listintersection.get(i2));
            ArrayList<Point> points = criteriaValFunc.getListCriteria().get(criterion_idx).getCriterionFunction().getPoints();
            int numberOfPoints = points.size();
            int j = 0;
            while (j < numberOfPoints) {
                float x = criteriaValFunc.getListCriteria().get(i2).getCriterionFunction().getPoints().get(j).getAbscissa();
                float y = criteriaValFunc.getListCriteria().get(i2).getCriterionFunction().getPoints().get(j).getOrdinate();
                criterion.getCriterionFunction().addPoint(new Point(x, y));
                ++j;
            }
            ++i2;
        }
        return criteriaintersection;
    }

    public String generatedPlot(Criterion criterion, boolean interpolation, Color color, String tempErrorMessage, boolean addBars) {
        ByteArrayOutputStream chart_png_image = new ByteArrayOutputStream();
        LineChart line = new LineChart("", PlotValFunction.title(criterion), "", criterion, interpolation, color, addBars);
        line.saveChart(chart_png_image);
        ImageGenerated imageConvert = new ImageGenerated();
        String encodedImage = imageConvert.convertImage(new ByteArrayInputStream(chart_png_image.toByteArray()), "png");
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    public String generatedPlotByColumn(Criteria criteria, boolean interpolation, Color color, String tempErrorMessage, int size, boolean addBars) {
        ByteArrayOutputStream[] chart_png_image = new ByteArrayOutputStream[size];
        int index = 0;
        for (Criterion criterion : criteria) {
            chart_png_image[index] = new ByteArrayOutputStream();
            LineChartPlotsByLine plotsInLine = new LineChartPlotsByLine("", PlotValFunction.title(criterion), "", criterion, interpolation, color, addBars);
            plotsInLine.saveChart(chart_png_image[index]);
            ++index;
        }
        ImageGenerated imageConvert = new ImageGenerated();
        InputStream[] inputStream = new InputStream[size];
        int i = 0;
        while (i < size) {
            inputStream[i] = new ByteArrayInputStream(chart_png_image[i].toByteArray());
            ++i;
        }
        String encodedImage = imageConvert.convertImageByColumn(inputStream, "png", size);
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    public String generatedPlotByLine(Criteria criteria, boolean interpolation, Color color, String tempErrorMessage, int size, boolean addBars) {
        ByteArrayOutputStream[] chart_png_image = new ByteArrayOutputStream[size];
        int index = 0;
        for (Criterion criterion : criteria) {
            chart_png_image[index] = new ByteArrayOutputStream();
            LineChartPlotsByLine plotsInLine = new LineChartPlotsByLine("", PlotValFunction.title(criterion), "", criterion, interpolation, color, addBars);
            plotsInLine.saveChart(chart_png_image[index]);
            ++index;
        }
        ImageGenerated imageConvert = new ImageGenerated();
        InputStream[] inputStream = new InputStream[size];
        int i = 0;
        while (i < size) {
            inputStream[i] = new ByteArrayInputStream(chart_png_image[i].toByteArray());
            ++i;
        }
        String encodedImage = imageConvert.convertImageByLine(inputStream, "png", size);
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    public String generatedPlotBySquare(Criteria criteria, boolean interpolation, Color color, String tempErrorMessage, int size, boolean addBars) {
        ByteArrayOutputStream[] chart_png_image = new ByteArrayOutputStream[size];
        int index = 0;
        for (Criterion criterion : criteria) {
            chart_png_image[index] = new ByteArrayOutputStream();
            LineChartPlotsByLine plotsInLine = new LineChartPlotsByLine("", PlotValFunction.title(criterion), "", criterion, interpolation, color, addBars);
            plotsInLine.saveChart(chart_png_image[index]);
            ++index;
        }
        ImageGenerated imageConvert = new ImageGenerated();
        InputStream[] inputStream = new InputStream[size];
        int i = 0;
        while (i < size) {
            inputStream[i] = new ByteArrayInputStream(chart_png_image[i].toByteArray());
            ++i;
        }
        String encodedImage = imageConvert.convertImageBySquare(inputStream, "png", size);
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    protected static Color getColorFromOptions(boolean black_and_white, String colorToUse) {
        if (black_and_white) {
            return Color.black;
        }
        Color c = null;
        try {
            c = (Color)Color.class.getField(colorToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            return Color.black;
        }
        return c;
    }

    public static void main(String[] argv) {
        String errValueFunctions;
        String pathCriteria;
        String tempErrorMessage = "";
        if (argv.length != 4 && argv.length != 5) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s).Please check your entry files.";
            System.exit(-1);
        }
        String in_methodPlotOptions = argv[0];
        String in_criteria = argv.length == 5 ? argv[1] : null;
        String in_valueFunctions = argv[argv.length - 3];
        String out_valueFunctionsPlot = argv[argv.length - 2];
        String out_messages = argv[argv.length - 1];
        if (!new File(in_methodPlotOptions).exists() || !new File(in_valueFunctions).exists()) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s).Please check your entry files.";
            XmcdaMessage.writeErrorMessage(tempErrorMessage, out_messages);
            return;
        }
        String pathMethodParameters = in_methodPlotOptions;
        String pathValueFunctions = in_valueFunctions;
        Main mainFunction = new Main();
        String errMethodParameters = mainFunction.checkEntryFile(pathMethodParameters);
        if (errMethodParameters != "") {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document.");
        }
        String errCriteria = "";
        if (in_criteria != null && new File(in_criteria).exists() && (errCriteria = mainFunction.checkEntryFile(pathCriteria = in_criteria)) != "") {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
        }
        if ((errValueFunctions = mainFunction.checkEntryFile(pathValueFunctions)) != "") {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag (valueFunctions) is not a valid XMCDA document.");
        }
        if (errMethodParameters != "" || errCriteria != "" || errValueFunctions != "") {
            XmcdaMessage.writeErrorMessage(tempErrorMessage, out_messages);
            return;
        }
        PlotValFunction plotValFunc = new PlotValFunction();
        if (mainFunction.getWarningMessage() != "") {
            plotValFunc.warningMessage = plotValFunc.warningMessage.concat(mainFunction.getWarningMessage());
        }
        Criteria criteria = new Criteria();
        if (in_criteria != null) {
            if (!new File(in_criteria).exists()) {
                plotValFunc.warningMessage = String.valueOf(plotValFunc.warningMessage) + "\nCriteria argument specified but not present";
            } else {
                String pathCriteria2 = in_criteria;
                mainFunction.PrepareParsing(pathCriteria2);
                JDOM_Criteria jdomCriter = new JDOM_Criteria();
                criteria = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
                if (criteria == null) {
                    tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty.");
                }
                if (jdomCriter.getWarning() != "") {
                    plotValFunc.warningMessage = plotValFunc.warningMessage.concat("\n" + jdomCriter.getWarning());
                }
            }
        }
        ParseFileCriterionFunction parsing = new ParseFileCriterionFunction();
        mainFunction.PrepareParsing(pathValueFunctions);
        Criteria criteriaFromValueFunctions = new Criteria();
        criteriaFromValueFunctions = parsing.exploreCriterionFunction(mainFunction.getRacine());
        if (criteriaFromValueFunctions == null) {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criterionFunction tags is erroneous or empty.");
        }
        if (parsing.getWarning() != "") {
            plotValFunc.warningMessage = plotValFunc.warningMessage.concat("\n" + parsing.getWarning());
        }
        methodParameters methodParam = new methodParameters();
        mainFunction.PrepareParsing(pathMethodParameters);
        boolean statusParseMethod = methodParam.parse(mainFunction.getRacine());
        if (!statusParseMethod) {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the methodParameters tag is erroneous or empty.");
        }
        if (criteriaFromValueFunctions == null || criteria == null || !statusParseMethod) {
            XmcdaMessage.writeErrorMessage(tempErrorMessage, out_messages);
            return;
        }
        Criteria intersectionCriteria = new Criteria();
        intersectionCriteria = in_criteria != null ? plotValFunc.getIntersectionCriteria(criteria, criteriaFromValueFunctions) : plotValFunc.getCriteriaFromValueFunctions(criteriaFromValueFunctions);
        boolean color = methodParam.getColor();
        boolean linearInterpolation = methodParam.getInterpolation();
        String colorToUse = methodParam.getColorToUse();
        String plotsOrganisation = methodParam.getPlotsOrganisation();
        boolean uniquePlot = methodParam.getUniquePlot();
        boolean addBars = methodParam.getAddBars();
        Color colorPlot = Color.black;
        colorPlot = PlotValFunction.getColorFromOptions(!color, colorToUse);
        if (!uniquePlot) {
            plotsOrganisation = "By column";
        }
        if (linearInterpolation) {
            addBars = false;
        }
        int size = intersectionCriteria.getListCriteria().size();
        CriteriaValues encodedImages = new CriteriaValues();
        String encodedImageByLine = null;
        String encodedImageBySquare = null;
        String encodedImageByColumn = null;
        boolean checkEncodedImages = true;
        if (intersectionCriteria.size() != 0) {
            if (!uniquePlot) {
                for (Criterion criterion : intersectionCriteria) {
                    CriterionValue critValue = new CriterionValue(criterion);
                    critValue.setObject(plotValFunc.generatedPlot(criterion, linearInterpolation, colorPlot, tempErrorMessage, addBars));
                    encodedImages.add(critValue);
                }
            } else if (plotsOrganisation.equals("By column")) {
                encodedImageByColumn = plotValFunc.generatedPlotByColumn(intersectionCriteria, linearInterpolation, colorPlot, tempErrorMessage, size, addBars);
            } else if (plotsOrganisation.equals("By line")) {
                encodedImageByLine = plotValFunc.generatedPlotByLine(intersectionCriteria, linearInterpolation, colorPlot, tempErrorMessage, size, addBars);
            } else if (plotsOrganisation.equals("By square")) {
                encodedImageBySquare = plotValFunc.generatedPlotBySquare(intersectionCriteria, linearInterpolation, colorPlot, tempErrorMessage, size, addBars);
            }
        } else {
            tempErrorMessage = tempErrorMessage.concat("\n We cannot run the algorithm since the criteria list  of the PROJECT is empty.\n");
        }
        XmcdaMessage xmcdaMess = new XmcdaMessage();
        xmcdaMess.createLogMessagePlotValueFunctions(errCriteria, errValueFunctions, plotValFunc.warningMessage, tempErrorMessage);
        String pathOutputMessage = out_messages;
        xmcdaMess.enregistre(pathOutputMessage);
        String pathOutputFilePlot = out_valueFunctionsPlot;
        String commentToPut = "Value functions plot";
        if (size != 0 && checkEncodedImages) {
            OutputValueFunctions outputPlotFile = new OutputValueFunctions();
            if (plotsOrganisation.equals("By column")) {
                if (!uniquePlot) {
                    outputPlotFile.createOutputValueFunctionsFile(encodedImages, commentToPut, size);
                } else {
                    outputPlotFile.createFileByColumn(intersectionCriteria, encodedImageByColumn, commentToPut, size);
                }
            } else if (plotsOrganisation.equals("By line")) {
                outputPlotFile.createFileByLineOrBySquare(intersectionCriteria, encodedImageByLine, commentToPut, size);
            } else if (plotsOrganisation.equals("By square")) {
                outputPlotFile.createFileByLineOrBySquare(intersectionCriteria, encodedImageBySquare, commentToPut, size);
            }
            outputPlotFile.saveFile(pathOutputFilePlot);
        }
    }
}

