/*
 * Decompiled with CFR 0.152.
 */
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageGenerated {
    private String errorMessage = "";

    public String convertImage(InputStream inputStream, String format) {
        String encodedImage = "";
        try {
            BufferedImage image = ImageIO.read(inputStream);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, format, baos);
            encodedImage = Base64.encode(baos.toByteArray());
        }
        catch (Exception e) {
            this.errorMessage = this.errorMessage.concat("\n Error in the image conversion: " + e.getMessage());
        }
        return encodedImage;
    }

    public String convertImage(String pathImage, String format) {
        String encodedImage = "";
        File fileTodelete = new File(pathImage);
        try {
            BufferedImage image = ImageIO.read(fileTodelete);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, format, baos);
            encodedImage = Base64.encode(baos.toByteArray());
        }
        catch (Exception e) {
            this.errorMessage = this.errorMessage.concat("\n Error in the image conversion: " + e.getMessage());
        }
        fileTodelete.delete();
        return encodedImage;
    }

    public String convertImageByLine(String[] pathImage, String format, int size) {
        String encodedImage = "";
        File[] filesTodelete = new File[size];
        int i = 0;
        while (i < size) {
            filesTodelete[i] = new File(pathImage[i]);
            ++i;
        }
        BufferedImage[] images = new BufferedImage[size];
        int i2 = 0;
        while (i2 < size) {
            try {
                images[i2] = ImageIO.read(filesTodelete[i2]);
            }
            catch (Exception e) {
                this.errorMessage = this.errorMessage.equals("") ? "\n Error in the image conversion: " + e.getMessage() : this.errorMessage.concat("\n Error in the image conversion: " + e.getMessage());
            }
            ++i2;
        }
        int w = images[0].getWidth();
        int i3 = 1;
        while (i3 < size) {
            w += images[i3].getWidth();
            ++i3;
        }
        int h = images[0].getHeight();
        int i4 = 1;
        while (i4 < size) {
            if (images[i4].getHeight() > h) {
                h = images[i4].getHeight();
            }
            ++i4;
        }
        BufferedImage combined = new BufferedImage(w, h, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i5 = 0;
        while (i5 < size) {
            g.drawImage(images[i5], x, y, null);
            x += images[i5].getWidth();
            ++i5;
        }
        File fileCombinedToDelete = new File("combined.png");
        try {
            ImageIO.write((RenderedImage)combined, "PNG", fileCombinedToDelete);
        }
        catch (IOException e1) {
            this.errorMessage = this.errorMessage.equals("") ? "\n Error in images combination (by line): " + e1.getMessage() : this.errorMessage.concat("\n Error in images combination (by line): " + e1.getMessage());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        encodedImage = Base64.encode(baos.toByteArray());
        int i6 = 0;
        while (i6 < size) {
            filesTodelete[i6].delete();
            ++i6;
        }
        fileCombinedToDelete.delete();
        return encodedImage;
    }

    public String convertImageByLine(InputStream[] inputStream, String format, int size) {
        BufferedImage[] images = new BufferedImage[size];
        int i = 0;
        while (i < size) {
            try {
                images[i] = ImageIO.read(inputStream[i]);
            }
            catch (Exception e) {
                this.errorMessage = this.errorMessage.equals("") ? "\n Error in the image conversion: " + e.getMessage() : this.errorMessage.concat("\n Error in the image conversion: " + e.getMessage());
            }
            ++i;
        }
        int w = images[0].getWidth();
        int i2 = 1;
        while (i2 < size) {
            w += images[i2].getWidth();
            ++i2;
        }
        int h = images[0].getHeight();
        int i3 = 1;
        while (i3 < size) {
            if (images[i3].getHeight() > h) {
                h = images[i3].getHeight();
            }
            ++i3;
        }
        BufferedImage combined = new BufferedImage(w, h, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i4 = 0;
        while (i4 < size) {
            g.drawImage(images[i4], x, y, null);
            x += images[i4].getWidth();
            ++i4;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException e) {
            this.errorMessage = this.errorMessage.equals("") ? "\n Error in images combination (by line): " + e.getMessage() : this.errorMessage.concat("\n Error in images combination (by line): " + e.getMessage());
        }
        return Base64.encode(baos.toByteArray());
    }

    public String convertImageByColumn(String[] pathImage, String format, int size) {
        String encodedImage = "";
        File[] filesTodelete = new File[size];
        int i = 0;
        while (i < size) {
            filesTodelete[i] = new File(pathImage[i]);
            ++i;
        }
        BufferedImage[] images = new BufferedImage[size];
        int i2 = 0;
        while (i2 < size) {
            try {
                images[i2] = ImageIO.read(filesTodelete[i2]);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMessage = this.errorMessage.equals("") ? "\n Error in the image conversion: " + e.getMessage() : this.errorMessage.concat("\n Error in the image conversion: " + e.getMessage());
            }
            ++i2;
        }
        int w = images[0].getWidth();
        int i3 = 1;
        while (i3 < size) {
            if (images[i3].getWidth() > w) {
                w = images[i3].getWidth();
            }
            ++i3;
        }
        int h = images[0].getHeight();
        int i4 = 1;
        while (i4 < size) {
            h += images[i4].getHeight();
            ++i4;
        }
        BufferedImage combined = new BufferedImage(w, h, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i5 = 0;
        while (i5 < size) {
            g.drawImage(images[i5], x, y, null);
            y += images[i5].getHeight();
            ++i5;
        }
        File fileCombinedToDelete = new File("combined.png");
        try {
            ImageIO.write((RenderedImage)combined, "PNG", fileCombinedToDelete);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.errorMessage = this.errorMessage.equals("") ? "\n Error in images combination (by column): " + e1.getMessage() : this.errorMessage.concat("\n Error in images combination (by column): " + e1.getMessage());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        encodedImage = Base64.encode(baos.toByteArray());
        int i6 = 0;
        while (i6 < size) {
            filesTodelete[i6].delete();
            ++i6;
        }
        fileCombinedToDelete.delete();
        return encodedImage;
    }

    public String convertImageByColumn(InputStream[] inputStream, String format, int size) {
        String encodedImage = "";
        BufferedImage[] images = new BufferedImage[size];
        int i = 0;
        while (i < size) {
            try {
                images[i] = ImageIO.read(inputStream[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMessage = this.errorMessage.equals("") ? "\n Error in the image conversion: " + e.getMessage() : this.errorMessage.concat("\n Error in the image conversion: " + e.getMessage());
            }
            ++i;
        }
        int w = images[0].getWidth();
        int i2 = 1;
        while (i2 < size) {
            if (images[i2].getWidth() > w) {
                w = images[i2].getWidth();
            }
            ++i2;
        }
        int h = images[0].getHeight();
        int i3 = 1;
        while (i3 < size) {
            h += images[i3].getHeight();
            ++i3;
        }
        BufferedImage combined = new BufferedImage(w, h, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i4 = 0;
        while (i4 < size) {
            g.drawImage(images[i4], x, y, null);
            y += images[i4].getHeight();
            ++i4;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException e1) {
            this.errorMessage = this.errorMessage.equals("") ? "\n Error in images combination (by column): " + e1.getMessage() : this.errorMessage.concat("\n Error in images combination (by column): " + e1.getMessage());
        }
        encodedImage = Base64.encode(baos.toByteArray());
        return encodedImage;
    }

    public String convertImageBySquare(String[] pathImage, String format, int size) {
        String encodedImage = "";
        File[] filesTodelete = new File[size];
        int i = 0;
        while (i < size) {
            filesTodelete[i] = new File(pathImage[i]);
            ++i;
        }
        BufferedImage[] images = new BufferedImage[size];
        int i2 = 0;
        while (i2 < size) {
            try {
                images[i2] = ImageIO.read(filesTodelete[i2]);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMessage = this.errorMessage.equals("") ? "\n Error in the image conversion: " + e.getMessage() : this.errorMessage.concat("\n Error in the image conversion: " + e.getMessage());
            }
            ++i2;
        }
        int maxNumberOfImagesByLine = (int)Math.ceil(Math.sqrt(size));
        int w = images[0].getWidth();
        int i3 = 1;
        while (i3 < size) {
            if (images[i3].getWidth() > w) {
                w = images[i3].getWidth();
            }
            ++i3;
        }
        int maxWidth = w;
        w *= maxNumberOfImagesByLine;
        int h = images[0].getHeight();
        int i4 = 1;
        while (i4 < size) {
            if (images[i4].getHeight() > h) {
                h = images[i4].getHeight();
            }
            ++i4;
        }
        int maxHeight = h;
        BufferedImage combined = new BufferedImage(w, h *= maxNumberOfImagesByLine, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i5 = 0;
        while (i5 < size) {
            g.drawImage(images[i5], x, y, null);
            if ((x += maxWidth) >= w) {
                x = 0;
                y += maxHeight;
            }
            ++i5;
        }
        File fileCombinedToDelete = new File("combined.png");
        try {
            ImageIO.write((RenderedImage)combined, "PNG", fileCombinedToDelete);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.errorMessage = this.errorMessage.equals("") ? "\n Error in images combination (by square): " + e1.getMessage() : this.errorMessage.concat("\n Error in images combination (by square): " + e1.getMessage());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        encodedImage = Base64.encode(baos.toByteArray());
        int i6 = 0;
        while (i6 < size) {
            filesTodelete[i6].delete();
            ++i6;
        }
        fileCombinedToDelete.delete();
        return encodedImage;
    }

    public String convertImageBySquare(InputStream[] inputStream, String format, int size) {
        BufferedImage[] images = new BufferedImage[size];
        int i = 0;
        while (i < size) {
            try {
                images[i] = ImageIO.read(inputStream[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMessage = this.errorMessage.equals("") ? "\n Error in the image conversion: " + e.getMessage() : this.errorMessage.concat("\n Error in the image conversion: " + e.getMessage());
            }
            ++i;
        }
        int maxNumberOfImagesByLine = (int)Math.ceil(Math.sqrt(size));
        int w = images[0].getWidth();
        int i2 = 1;
        while (i2 < size) {
            if (images[i2].getWidth() > w) {
                w = images[i2].getWidth();
            }
            ++i2;
        }
        int maxWidth = w;
        w *= maxNumberOfImagesByLine;
        int h = images[0].getHeight();
        int i3 = 1;
        while (i3 < size) {
            if (images[i3].getHeight() > h) {
                h = images[i3].getHeight();
            }
            ++i3;
        }
        int maxHeight = h;
        BufferedImage combined = new BufferedImage(w, h *= maxNumberOfImagesByLine, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i4 = 0;
        while (i4 < size) {
            g.drawImage(images[i4], x, y, null);
            if ((x += maxWidth) >= w) {
                x = 0;
                y += maxHeight;
            }
            ++i4;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.errorMessage = this.errorMessage.equals("") ? "\n Error in images combination (by square): " + e1.getMessage() : this.errorMessage.concat("\n Error in images combination (by square): " + e1.getMessage());
        }
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException e1) {
            this.errorMessage = this.errorMessage.equals("") ? "\n Error in images combination (by square): " + e1.getMessage() : this.errorMessage.concat("\n Error in images combination (by square): " + e1.getMessage());
        }
        return Base64.encode(baos.toByteArray());
    }

    public String getImageErrorMessage() {
        return this.errorMessage;
    }
}

