/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;

public class BarChartPlot {
    private int size1;
    private int size2;
    private JFreeChart chart;

    public BarChartPlot(double[] ySeries, Color c1, Color c2, String chartTitle, String XaxisLabel, String YaxisLabel, String[] listintersectionIds, String[] listIntersectionNames, String order, String maxMin) {
        this.setSize1(500);
        this.setSize2(270);
        CategoryDataset dataset = this.createDataset(ySeries, listintersectionIds, listIntersectionNames, order, maxMin);
        this.chart = this.createChart(dataset, ySeries.length, c1, c2, chartTitle, XaxisLabel, YaxisLabel);
    }

    public void saveChart(OutputStream outputStream) {
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)this.chart, (int)this.getSize1(), (int)this.getSize2());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveChart(String filepath) {
        File file = new File(filepath);
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)this.getSize1(), (int)this.getSize2());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private CategoryDataset createDataset(double[] ySeries, String[] listIds, String[] listNames, String order, String maxMin) {
        int j;
        String[] rowKeys = new String[]{"Series"};
        String[] columnKeys = new String[ySeries.length];
        int i = 0;
        while (i < ySeries.length) {
            columnKeys[i] = "";
            ++i;
        }
        i = 0;
        while (i < ySeries.length) {
            columnKeys[i] = order.equals("by id") ? (listNames[i] != null && listIds[i] != null ? "(" + listIds[i] + ") " + listNames[i] : listIds[i]) : (listNames[i] != null && listIds[i] != null ? String.valueOf(listNames[i]) + " (" + listIds[i] + ")" : listIds[i]);
            ++i;
        }
        if (order.equals("by id") || order.equals("by name")) {
            i = 0;
            while (i < columnKeys.length - 1) {
                j = i + 1;
                while (j < columnKeys.length) {
                    if (maxMin.equals("increasing")) {
                        if (columnKeys[j].toLowerCase().compareTo(columnKeys[i].toLowerCase()) < 0) {
                            BarChartPlot.exchange(columnKeys, i, j);
                            BarChartPlot.exchange(ySeries, i, j);
                        }
                    } else if (columnKeys[j].toLowerCase().compareTo(columnKeys[i].toLowerCase()) > 0) {
                        BarChartPlot.exchange(columnKeys, i, j);
                        BarChartPlot.exchange(ySeries, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        } else if (order.equals("by values")) {
            i = 0;
            while (i < ySeries.length - 1) {
                j = i + 1;
                while (j < ySeries.length) {
                    if (maxMin.equals("increasing")) {
                        if (ySeries[j] < ySeries[i]) {
                            BarChartPlot.exchange(columnKeys, i, j);
                            BarChartPlot.exchange(ySeries, i, j);
                        }
                    } else if (ySeries[j] > ySeries[i]) {
                        BarChartPlot.exchange(columnKeys, i, j);
                        BarChartPlot.exchange(ySeries, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        }
        double[][] data = new double[1][ySeries.length];
        int i2 = 0;
        while (i2 < ySeries.length) {
            data[0][i2] = ySeries[i2];
            ++i2;
        }
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset((Comparable[])rowKeys, (Comparable[])columnKeys, (double[][])data);
        return dataset;
    }

    protected static void exchange(String[] columnKeys, int i, int j) {
        String tempKey = columnKeys[j];
        columnKeys[j] = columnKeys[i];
        columnKeys[i] = tempKey;
    }

    protected static void exchange(double[] ySeries, int i, int j) {
        double tempVal = ySeries[j];
        ySeries[j] = ySeries[i];
        ySeries[i] = tempVal;
    }

    private JFreeChart createChart(CategoryDataset dataset, int ySeriesLength, Color c1, Color c2, String chartTitle, String XaxisLabel, String YaxisLabel) {
        JFreeChart chart = ChartFactory.createBarChart((String)chartTitle, (String)XaxisLabel, (String)YaxisLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setNoDataMessage("NO DATA!");
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        Paint[] paint = new Paint[ySeriesLength];
        int red1 = c1.getRed();
        int green1 = c1.getGreen();
        int blue1 = c1.getBlue();
        int red2 = c2.getRed();
        int green2 = c2.getGreen();
        int blue2 = c2.getBlue();
        int LARGEUR = ySeriesLength;
        int i = 0;
        while (i < ySeriesLength) {
            paint[i] = new Color((red1 * (LARGEUR - i) + red2 * i) / LARGEUR, (green1 * (LARGEUR - i) + green2 * i) / LARGEUR, (blue1 * (LARGEUR - i) + blue2 * i) / LARGEUR);
            ++i;
        }
        CustomRenderer renderer = new CustomRenderer(paint);
        int i2 = 0;
        while (i2 < ySeriesLength) {
            renderer.setSeriesPaint(i2, paint[i2]);
            ++i2;
        }
        renderer.setSeriesItemLabelsVisible(0, Boolean.FALSE);
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setShadowGenerator(null);
        Font font = new Font("Arial", 1, 12);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setTickLabelFont(font);
        domainAxis.setLabelFont(new Font("Arial", 1, 16));
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setLowerMargin(0.15);
        rangeAxis.setUpperMargin(0.15);
        rangeAxis.setTickLabelFont(font);
        rangeAxis.setLabelFont(new Font("Arial", 1, 16));
        plot.setRangeAxis(rangeAxis);
        return chart;
    }

    public int getSize1() {
        return this.size1;
    }

    public void setSize1(int val) {
        this.size1 = val;
    }

    public int getSize2() {
        return this.size2;
    }

    public void setSize2(int val) {
        this.size2 = val;
    }

    class CustomRenderer
    extends BarRenderer {
        private static final long serialVersionUID = 6850158899421359896L;
        private Paint[] colors;

        public CustomRenderer(Paint[] colors) {
            this.colors = colors;
            super.setShadowVisible(false);
            super.setBarPainter((BarPainter)new StandardBarPainter());
        }

        public Paint getItemPaint(int row, int column) {
            return this.colors[column % this.colors.length];
        }
    }
}

