#! /bin/sh

JAR=../build/plotNumericPerformanceTable-ITTB.jar

OUT=out
TMPF=$("tempfile")

unset DISPLAY

for IN in $1; do
  echo -n "$IN / out${IN#in} "
  /bin/rm -rf $OUT
  mkdir $OUT
  java -jar $JAR $IN/methodParameters.xml $IN/alternatives.xml $IN/criteria.xml $IN/performanceTable.xml $OUT/performanceTablePlot.xml $OUT/messages.xml
  diff -Bqrw --exclude=criteriaValuesPlot.xml out out${IN#in} > $TMPF 2>&1
  if [ $? -ne 0 ]; then
    echo "FAILED"
    cat $TMPF >&2
  else
    echo "SUCCESS"
  fi
  /bin/rm $TMPF
done


# How to extract the images from the XMCDA output:
# grep '<image>' out/alternativesComparisonsPlot.xml | sed -e 's|.*<image>\(.*\)</image>.*|\1|g'|base64 -d > 2.png
