/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.Criterion;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives;
import eu.telecom_bretagne.xmcda.JDOM_Criteria;
import eu.telecom_bretagne.xmcda.JDOM_PerformanceTable;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.PerformanceTable;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;

public class PlotNumPerfTable {
    public PlotNumPerfTable(PerformanceTable projectPerfTable) {
    }

    protected ByteArrayOutputStream createChart(String chartType, PerformanceTable perfTable, Alternatives alternatives, Criterion criterion, String tempErrorMessage, boolean color, Color color1, Color color2, String chartTitle, String XaxisLabel, String YaxisLabel, String order, String maxMin) {
        int nbrAlternatives = perfTable.alternatives().size();
        String[] listAlternativesIDs = new String[nbrAlternatives];
        String[] listAlternativesNames = new String[nbrAlternatives];
        double[] ySeries = new double[nbrAlternatives];
        int idx = 0;
        for (Alternative a : perfTable.alternatives()) {
            listAlternativesIDs[idx] = a.id();
            listAlternativesNames[idx] = alternatives.getAlternative(a.id()).name();
            ySeries[idx] = ((Float)perfTable.getValue(a, criterion)).floatValue();
            ++idx;
        }
        ByteArrayOutputStream chart_png_image = new ByteArrayOutputStream();
        String title = "";
        String id = criterion.id();
        title = criterion.name() != null && id != null ? String.valueOf(criterion.name()) + " (" + id + ")" : id;
        if (chartType.equals("bc")) {
            BarChartPlot barChart = new BarChartPlot(ySeries, color1, color2, title, XaxisLabel, YaxisLabel, listAlternativesIDs, listAlternativesNames, order, maxMin);
            barChart.saveChart(chart_png_image);
        } else {
            PieChartPlot pieChart = new PieChartPlot(ySeries, color1, color2, title, XaxisLabel, YaxisLabel, listAlternativesIDs, listAlternativesNames, order, maxMin);
            pieChart.saveChart(chart_png_image);
        }
        return chart_png_image;
    }

    protected String generateMultiplePlots(String chartType, PerformanceTable perfTable, Alternatives alternatives, Criterion criter, String tempErrorMessage, boolean color, Color color1, Color color2, String chartTitle, String XaxisLabel, String YaxisLabel, String order, String maxMin) {
        ByteArrayOutputStream chart_png_image = new ByteArrayOutputStream();
        chart_png_image = this.createChart(chartType, perfTable, alternatives, criter, tempErrorMessage, color, color1, color2, chartTitle, XaxisLabel, YaxisLabel, order, maxMin);
        ImageConversion imageConvert = new ImageConversion();
        String encodedImage = imageConvert.convertImage(new ByteArrayInputStream(chart_png_image.toByteArray()), "png");
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    protected String generatePlot(String chartType, String plotsOrganisation, PerformanceTable performanceTable, Alternatives alternatives, Criteria criteria, String tempErrorMessage, boolean color, Color color1, Color color2, String chartTitle, String XaxisLabel, String YaxisLabel, String order, String maxMin) {
        int nbrCriteria = performanceTable.nbCriteria();
        ByteArrayOutputStream[] chart_png_image = new ByteArrayOutputStream[nbrCriteria];
        int idx = 0;
        for (Criterion c : performanceTable.criteria()) {
            Criterion criterion = criteria.get(c.id());
            chart_png_image[idx] = this.createChart(chartType, performanceTable, alternatives, criterion, tempErrorMessage, color, color1, color2, chartTitle, XaxisLabel, YaxisLabel, order, maxMin);
            ++idx;
        }
        ImageConversion imageConvert = new ImageConversion();
        String encodedImage = null;
        InputStream[] inputStream = new InputStream[nbrCriteria];
        int i = 0;
        while (i < nbrCriteria) {
            inputStream[i] = new ByteArrayInputStream(chart_png_image[i].toByteArray());
            ++i;
        }
        if (plotsOrganisation.equals("By column")) {
            encodedImage = imageConvert.convertImageByColumn(inputStream, "png", nbrCriteria);
        } else if (plotsOrganisation.equals("By line")) {
            encodedImage = imageConvert.convertImageByLine(inputStream, "png", nbrCriteria);
        } else if (plotsOrganisation.equals("By square")) {
            encodedImage = imageConvert.convertImageBySquare(inputStream, "png", nbrCriteria);
        }
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    protected static Color[] getColorsFromOptions(boolean black_and_white, String colors1ToUse, String colors2ToUse) {
        Color[] colors = new Color[]{Color.black, Color.black};
        if (black_and_white) {
            return colors;
        }
        Color c1 = null;
        Color c2 = null;
        try {
            c1 = (Color)Color.class.getField(colors1ToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c1 == null) {
            return colors;
        }
        try {
            c2 = (Color)Color.class.getField(colors2ToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c2 == null) {
            return colors;
        }
        colors[0] = c1;
        colors[1] = c2;
        return colors;
    }

    public static void main(String[] argv) {
        if (argv.length != 5 && argv.length != 6) {
            System.err.println("Usage: methodPlotOptions.xml criteria.xml criteriaValues.xml criteriaValuesPlot.xml [criteriaValuesPlot.dot] messages.xml");
            System.err.println("       The 3 first files are inputs, the remaining ones are outputs");
            System.exit(-1);
        }
        String pathMethodParameters = argv[0];
        String pathAlternatives = argv[1];
        String pathCriteria = argv[2];
        String pathPerfTable = argv[3];
        String pathOutputFile = argv[4];
        String pathOutputMessage = argv[5];
        String tempErrorMessage = "";
        String warningMessage = "";
        if (!(new File(pathMethodParameters).exists() && new File(pathAlternatives).exists() && new File(pathCriteria).exists() && new File(pathPerfTable).exists())) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        Main mainFunction = new Main();
        PerformanceTable test = new PerformanceTable();
        String errParam = mainFunction.checkEntryFile(pathMethodParameters);
        String errAltern = mainFunction.checkEntryFile(pathAlternatives);
        String errCriter = mainFunction.checkEntryFile(pathCriteria);
        String errPerfTable = mainFunction.checkEntryFile(pathPerfTable);
        if (!"".equals(errParam)) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document.";
        }
        if (!"".equals(errAltern)) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.";
        }
        if (!"".equals(errCriter)) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.";
        }
        if (!"".equals(errPerfTable)) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the performanceTable tag is not a valid XMCDA document.";
        }
        if (!("".equals(errParam) && "".equals(errAltern) && "".equals(errCriter) && "".equals(errPerfTable))) {
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        JDOM_Criteria jdomCriter = new JDOM_Criteria();
        mainFunction.PrepareParsing(pathCriteria);
        Criteria criteria = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
        if (criteria == null) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the criteria tag is erroneous or empty.";
        }
        if (jdomCriter.getWarning() != "") {
            warningMessage = String.valueOf(warningMessage) + "\n" + jdomCriter.getWarning();
        }
        mainFunction.PrepareParsing(pathAlternatives);
        JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
        Alternatives alternatives = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
        if (alternatives == null) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the alternatives tag is erroneous or empty.";
        }
        if (jdomAlter.getWarning() != "") {
            warningMessage = String.valueOf(warningMessage) + "\n" + jdomAlter.getWarning();
        }
        mainFunction.PrepareParsing(pathPerfTable);
        JDOM_PerformanceTable jdomPerfTable = new JDOM_PerformanceTable();
        PerformanceTable performanceTable = jdomPerfTable.explorePerformanceTable(mainFunction.getRacine());
        if (performanceTable == null) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the performanceTable tag is erroneous or empty.";
        }
        if (jdomPerfTable.getErrorMessage() != "") {
            warningMessage = warningMessage.concat("\n" + jdomPerfTable.getErrorMessage());
        }
        if (jdomPerfTable.getWarningMessage() != "") {
            warningMessage = warningMessage.concat(jdomPerfTable.getWarningMessage());
        }
        OptionsMethodParameters parseMethodParam = new OptionsMethodParameters();
        mainFunction.PrepareParsing(pathMethodParameters);
        boolean statusParseMethod = parseMethodParam.parse(mainFunction.getRacine());
        if (!statusParseMethod) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the methodParameters tag is erroneous or empty.";
        }
        if (criteria == null || alternatives == null || performanceTable == null || !statusParseMethod) {
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        performanceTable = mainFunction.run(performanceTable, criteria, alternatives);
        warningMessage = warningMessage.concat(mainFunction.getWarningMessage());
        tempErrorMessage = mainFunction.getErrorMessage();
        String chartType = parseMethodParam.getChartType();
        if (parseMethodParam.getError() != "") {
            warningMessage = warningMessage.concat(parseMethodParam.getError());
        }
        boolean uniquePlot = parseMethodParam.getUniquePlot();
        String plotsOrganisation = parseMethodParam.getPlotsOrganisation();
        String order = parseMethodParam.getOrder();
        String maxMin = parseMethodParam.getMaxMin();
        boolean color = parseMethodParam.getColor();
        String colors1ToUse = parseMethodParam.getInitialColor();
        String colors2ToUse = parseMethodParam.getFinalColor();
        Color[] colors = PlotNumPerfTable.getColorsFromOptions(!color, colors1ToUse, colors2ToUse);
        String chartTitle = parseMethodParam.getChartTitle();
        String XaxisLabel = parseMethodParam.getDomainAxisLabel();
        String YaxisLabel = parseMethodParam.getRangeAxisLabel();
        String[] encodedImage = new String[performanceTable.nbCriteria()];
        String image = null;
        PlotNumPerfTable plot = new PlotNumPerfTable(test);
        PlotPerfTableFile outputFile = new PlotPerfTableFile();
        String commentToPut = "performance table plot";
        if (chartTitle.length() != 0) {
            commentToPut = chartTitle.toLowerCase();
        }
        if (performanceTable.nbAlternatives() == 0 || performanceTable.nbCriteria() == 0) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\n We cannot run the algorithm since the criteria list or the alternatives list of the PROJECT is empty.\n";
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createLogMessage(errCriter, errAltern, errPerfTable, warningMessage, tempErrorMessage);
            xmcdaMess.enregistre(pathOutputMessage);
            return;
        }
        if (!uniquePlot) {
            int idx = 0;
            ArrayList<String> criteriaIDs = new ArrayList<String>();
            for (Criterion c : performanceTable.criteria()) {
                Criterion criterion = criteria.get(c.id());
                encodedImage[idx] = plot.generateMultiplePlots(chartType, performanceTable, alternatives, criterion, tempErrorMessage, color, colors[0], colors[1], chartTitle, XaxisLabel, YaxisLabel, order, maxMin);
                criteriaIDs.add(criterion.id());
                ++idx;
            }
            outputFile.createFileMultiplePlots(criteriaIDs, encodedImage, commentToPut);
        } else {
            image = plot.generatePlot(chartType, plotsOrganisation, performanceTable, alternatives, criteria, tempErrorMessage, color, colors[0], colors[1], chartTitle, XaxisLabel, YaxisLabel, order, maxMin);
            outputFile.createFile(performanceTable.criteria(), image, commentToPut);
        }
        XmcdaMessage xmcdaMess = new XmcdaMessage();
        xmcdaMess.createLogMessage(errCriter, errAltern, errPerfTable, warningMessage, tempErrorMessage);
        xmcdaMess.enregistre(pathOutputMessage);
        outputFile.saveFile(pathOutputFile);
    }
}

