/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.utils.GraphViz;
import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.AlternativeValue;
import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.AlternativesValues;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives;
import eu.telecom_bretagne.xmcda.JDOM_AlternativesValues;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.io.File;
import java.util.ArrayList;

public class plotPreorder {
    private static String warningMessage = "";

    public boolean checkFiles(Alternatives alter, AlternativesValues alternVal) {
        boolean result = true;
        int diff = 0;
        if (alter.getAlternativesIDs().size() != alternVal.size()) {
            warningMessage = String.valueOf(warningMessage) + "\nPlease check the file containing the alternatives tag:incoherence with the number of alternatives given in the file containing the alternativesValues tag.";
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (AlternativeValue av : alternVal) {
            list.add(av.getAlternativeValueId());
        }
        for (String s : alter.getAlternativesIDs()) {
            if (list.contains(s)) continue;
            result = false;
            ++diff;
        }
        if (diff > 1) {
            warningMessage = String.valueOf(warningMessage) + "\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the alternativesValues tag. There are " + diff + " different alternatives.";
        }
        if (diff == 1) {
            warningMessage = String.valueOf(warningMessage) + "\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the alternativesValues tag. There is one different alternative.";
        }
        return result;
    }

    public Alternatives getIntersectionAlternativesIDs(Alternatives alter, AlternativesValues alternVal) {
        Alternatives intersection = new Alternatives();
        for (AlternativeValue av : alternVal) {
            Alternative a;
            if (!alter.contains(av.getAlternative()) || !(a = alter.getAlternative(av.getAlternativeValueId())).isActive()) continue;
            intersection.addAlternative(a);
        }
        return intersection;
    }

    public ArrayList<String> getIntersectionAlternativesNames(Alternatives alter, AlternativesValues alternVal, ArrayList<String> listintersectionIds) {
        ArrayList<String> listintersectionNames = new ArrayList<String>();
        int i = 0;
        while (i < listintersectionIds.size()) {
            if (alter.getAlternativesIDs().contains(listintersectionIds.get(i))) {
                int index = alter.getAlternativesIDs().indexOf(listintersectionIds.get(i));
                if (alter.getListAlternativesNames().get(index) != null) {
                    listintersectionNames.add(alter.getListAlternativesNames().get(index));
                } else {
                    listintersectionNames.add(null);
                }
            } else {
                listintersectionNames.add(null);
            }
            ++i;
        }
        return listintersectionNames;
    }

    protected static void echange(double[] values, int element1, int element2) {
        double temp = values[element1];
        values[element1] = values[element2];
        values[element2] = temp;
    }

    protected static void exchangeIDs(String[] listIds, int index1, int index2) {
        String temp = listIds[index1];
        listIds[index1] = listIds[index2];
        listIds[index2] = temp;
    }

    public GraphViz createGraph(String[] listintersectionIds, String[] listintersectionNames, String color, String node_shape, boolean namesToPlace, int size) {
        GraphViz gv = new GraphViz();
        gv.addln(gv.start_graph(color, node_shape));
        char guillemet = '\"';
        String[] temp = new String[size];
        int i = 0;
        while (i < size) {
            temp[i] = listintersectionIds[i];
            if (listintersectionIds[i].contains(", ")) {
                temp[i] = temp[i].replaceAll(", ", "");
            }
            ++i;
        }
        if (!namesToPlace) {
            i = 0;
            while (i < size) {
                gv.addln(String.valueOf(temp[i]) + " [label = " + guillemet + listintersectionIds[i] + guillemet + ", fontcolor=" + color + "];");
                ++i;
            }
        } else {
            i = 0;
            while (i < size) {
                if (listintersectionNames[i] != null) {
                    gv.addln(String.valueOf(temp[i]) + "[label=" + guillemet + listintersectionNames[i] + guillemet + ", fontcolor=" + color + "]");
                } else {
                    gv.addln(String.valueOf(temp[i]) + " [label = " + guillemet + listintersectionIds[i] + guillemet + ", fontcolor=" + color + "];");
                    warningMessage = warningMessage.concat("\n Warning: the attribute 'name' of the alternative ID: " + listintersectionIds[i] + " does " + "not exist. Please check the entry file containing the alternatives tag.");
                }
                ++i;
            }
        }
        i = 0;
        while (i < size - 1) {
            gv.addln(String.valueOf(temp[i]) + " -> " + temp[i + 1] + ";");
            ++i;
        }
        gv.addln(gv.end_graph());
        return gv;
    }

    protected static int existsInTab(double[] alternValuesToUse, int size, double value) {
        int exists = -1;
        int i = 0;
        while (i < size && exists == -1) {
            if (alternValuesToUse[i] == value) {
                exists = i;
            }
            ++i;
        }
        return exists;
    }

    public GraphViz generatePlot(AlternativesValues alternativesValuesToPlot, Alternatives alter, Alternatives intersection, String tempErrorMessage, String order, String color, String node_shape, boolean namesToPlace) {
        int j;
        double[] ySeriesAlternValues = new double[intersection.size()];
        String tempId = "";
        String tempName = "";
        String[] listOrderIds = new String[intersection.size()];
        String[] listOrderNames = new String[intersection.size()];
        int idx = 0;
        for (Alternative a : intersection) {
            if (alternativesValuesToPlot.getListAlternativesIDs().contains(a.id())) {
                ySeriesAlternValues[idx] = alternativesValuesToPlot.getListAlternativesValues().get(alternativesValuesToPlot.getListAlternativesIDs().indexOf(a.id())).getRealValue();
                listOrderIds[idx] = tempId = alternativesValuesToPlot.getListAlternativesIDs().get(alternativesValuesToPlot.getListAlternativesIDs().indexOf(a.id()));
                listOrderNames[idx] = tempName = a.name();
            }
            ++idx;
        }
        double[] alternValuesToUse = new double[intersection.size()];
        String[] listIdsToUse = new String[intersection.size()];
        String[] listNamesToUse = new String[intersection.size()];
        int index = 0;
        int i = 0;
        while (i < intersection.size()) {
            int existTest = plotPreorder.existsInTab(alternValuesToUse, index, ySeriesAlternValues[i]);
            if (existTest == -1) {
                alternValuesToUse[index] = ySeriesAlternValues[i];
                listIdsToUse[index] = listOrderIds[i];
                listNamesToUse[index] = listOrderNames[i];
                ++index;
            } else {
                listIdsToUse[existTest] = listIdsToUse[existTest].concat(", " + listOrderIds[i]);
                if (listOrderNames[i] != null) {
                    listNamesToUse[existTest] = listNamesToUse[existTest].concat(", " + listOrderNames[i]);
                }
            }
            ++i;
        }
        if (order.equals("increasing")) {
            i = 0;
            while (i < index - 1) {
                j = i + 1;
                while (j < index) {
                    if (alternValuesToUse[j] < alternValuesToUse[i]) {
                        plotPreorder.echange(alternValuesToUse, j, i);
                        plotPreorder.exchangeIDs(listIdsToUse, j, i);
                        plotPreorder.exchangeIDs(listNamesToUse, j, i);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < index - 1) {
                j = i + 1;
                while (j < index) {
                    if (alternValuesToUse[j] > alternValuesToUse[i]) {
                        plotPreorder.echange(alternValuesToUse, j, i);
                        plotPreorder.exchangeIDs(listIdsToUse, j, i);
                        plotPreorder.exchangeIDs(listNamesToUse, j, i);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.createGraph(listIdsToUse, listNamesToUse, color, node_shape, namesToPlace, index);
    }

    protected static String getColorFromOptions(boolean black_and_white, String colorToUse) {
        String color = "";
        color = black_and_white ? "black" : colorToUse.toLowerCase();
        return color;
    }

    public static void main(String[] argv) {
        String errAlternativesValues;
        String errAlternatives;
        if (argv.length != 5 && argv.length != 6) {
            System.err.println("Usage: methodPlotOptions.xml alternatives.xml alternativesValues.xml alternativesValuesPlot.xml messages.xml");
            System.err.println("       The 3 first files are inputs, the remaining ones are outputs");
            System.exit(-1);
        }
        String pathOptions = argv[0];
        String pathAlternatives = argv[1];
        String pathAlternativesValues = argv[2];
        File pathOutputFilePlot = new File(argv[3]);
        File pathOutputDotFile = argv.length == 6 ? new File(argv[4]) : null;
        String pathOutputMessage = argv[argv.length - 1];
        String tempErrorMessage = "";
        if (!(new File(pathOptions).exists() && new File(pathAlternatives).exists() && new File(pathAlternativesValues).exists())) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        Main mainFunction = new Main();
        String errMethodParameters = mainFunction.checkEntryFile(pathOptions);
        if (errMethodParameters != "") {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document.";
        }
        if ((errAlternatives = mainFunction.checkEntryFile(pathAlternatives)) != "") {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.";
        }
        if ((errAlternativesValues = mainFunction.checkEntryFile(pathAlternativesValues)) != "") {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the alternativesValues tag is not a valid XMCDA document.";
        }
        if (errMethodParameters != "" || errAlternatives != "" || errAlternativesValues != "") {
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        plotPreorder plot = new plotPreorder();
        if (mainFunction.getWarningMessage() != "") {
            warningMessage = warningMessage.concat(mainFunction.getWarningMessage());
        }
        mainFunction.PrepareParsing(pathAlternatives);
        Alternatives alternativesToUse = new Alternatives();
        JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
        alternativesToUse = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
        if (alternativesToUse == null) {
            tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
        }
        if (jdomAlter.getWarning() != "") {
            warningMessage = warningMessage.concat("\n" + jdomAlter.getWarning());
        }
        mainFunction.PrepareParsing(pathAlternativesValues);
        AlternativesValues alternativesValuesToUse = new AlternativesValues();
        JDOM_AlternativesValues jdomAlternVal = new JDOM_AlternativesValues();
        alternativesValuesToUse = jdomAlternVal.parseAlternativesValuesXML(mainFunction.getRacine());
        if (alternativesValuesToUse == null) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the alternativesValues tag is erroneous or empty.";
        }
        if (jdomAlternVal.getWarningMessage() != "") {
            warningMessage = warningMessage.concat("\n" + jdomAlternVal.getWarningMessage());
        }
        Options options = new Options();
        mainFunction.PrepareParsing(pathOptions);
        boolean statusOptions = options.parse(mainFunction.getRacine());
        if (!statusOptions) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the methodParameters tag is erroneous or empty.";
        }
        if (alternativesValuesToUse == null || alternativesToUse == null || !statusOptions) {
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        plot.checkFiles(alternativesToUse, alternativesValuesToUse);
        Alternatives intersection = plot.getIntersectionAlternativesIDs(alternativesToUse, alternativesValuesToUse);
        if (intersection.isEmpty()) {
            warningMessage = warningMessage.concat("\nOnly the alternatives IDs in the file containing the alternativesValues tag were considered. Please check your input file containing the alternatives tag.");
            for (AlternativeValue av : alternativesValuesToUse) {
                intersection.addAlternative(av.getAlternative());
            }
        }
        if (intersection.isEmpty()) {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            String errorMessage = "Failure to run the algorithm because it seems that the file containing the alternativesValues tag is empty or erroneous.";
            xmcdaMess.createErrorMessage(errorMessage);
            xmcdaMess.enregistre(pathOutputMessage);
        } else {
            if (options.getWarning() != "") {
                warningMessage = warningMessage.concat(options.getWarning());
            }
            String plotTitle = options.getTitle();
            String order = options.getOrder();
            boolean color = options.getColor();
            String colorOptions = options.getColorToUse();
            if (!color && colorOptions != "Black") {
                warningMessage = warningMessage.concat("\nWarning: the selected color '" + colorOptions + "' was ignored " + "because you have chosen a black and white plot.");
            }
            String colorToUse = plotPreorder.getColorFromOptions(!color, colorOptions);
            String node_shape = options.getShape();
            boolean namesToPlace = options.getNamesOrIDs();
            GraphViz gv = null;
            if (!intersection.isEmpty()) {
                gv = plot.generatePlot(alternativesValuesToUse, alternativesToUse, intersection, tempErrorMessage, order, colorToUse, node_shape, namesToPlace);
            } else {
                tempErrorMessage = String.valueOf(tempErrorMessage) + "\n We cannot run the algorithm since the alternatives list of the PROJECT is empty.\n";
            }
            if (plotTitle.length() == 0) {
                plotTitle = "Alternatives values preorder plot";
                warningMessage = String.valueOf(warningMessage) + "\n The title field is empty or erroneous. The title was set to 'Alternatives values preorder plot'. You can check the file containing the method parameters tag.";
            }
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createLogMessageForAlternativesValPlot(errAlternatives, errAlternativesValues, warningMessage, tempErrorMessage);
            xmcdaMess.enregistre(pathOutputMessage);
            if (intersection.size() != 0 && gv != null) {
                PlotPreorderFile.createFiles(intersection, gv, plotTitle, pathOutputFilePlot, pathOutputDotFile);
            }
        }
    }
}

