/*
 * Decompiled with CFR 0.152.
 */
package plotAlternValues;

import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.AlternativesValues;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.SortOrder;

public class PieChart {
    private JFreeChart chart;

    public PieChart(String title, double[] ySeries, AlternativesValues alternativesValuesToPlot, Alternatives alter, Color c1, Color c2, String chartTitle, ArrayList<String> listintersectionIds, ArrayList<String> listintersectionNames, String order, String maxMin) {
        int j;
        String[] listIds = new String[ySeries.length];
        int i = 0;
        while (i < ySeries.length) {
            listIds[i] = listintersectionIds.get(i);
            ++i;
        }
        String[] listNames = new String[ySeries.length];
        int i2 = 0;
        while (i2 < ySeries.length) {
            listNames[i2] = listintersectionNames.get(i2);
            ++i2;
        }
        String[] columnKeys = new String[ySeries.length];
        int i3 = 0;
        while (i3 < ySeries.length) {
            columnKeys[i3] = "";
            ++i3;
        }
        i3 = 0;
        while (i3 < ySeries.length) {
            columnKeys[i3] = order.equals("by id") ? (listintersectionNames.get(i3) != null && listintersectionIds != null ? "(" + listintersectionIds.get(i3) + ") " + listintersectionNames.get(i3) : listintersectionIds.get(i3)) : (listintersectionNames.get(i3) != null && listintersectionIds != null ? String.valueOf(listintersectionNames.get(i3)) + " (" + listintersectionIds.get(i3) + ")" : listintersectionIds.get(i3));
            ++i3;
        }
        if (order.equals("by id") || order.equals("by name")) {
            i3 = 0;
            while (i3 < ySeries.length - 1) {
                j = i3 + 1;
                while (j < ySeries.length) {
                    if (maxMin.equals("increasing")) {
                        if (listIds[j].toLowerCase().compareTo(listIds[i3].toLowerCase()) < 0) {
                            PieChart.exchange(columnKeys, i3, j);
                            PieChart.exchange(ySeries, i3, j);
                        }
                    } else if (listIds[j].toLowerCase().compareTo(listIds[i3].toLowerCase()) > 0) {
                        PieChart.exchange(columnKeys, i3, j);
                        PieChart.exchange(ySeries, i3, j);
                    }
                    ++j;
                }
                ++i3;
            }
        } else if (order.equals("by values")) {
            i3 = 0;
            while (i3 < ySeries.length - 1) {
                j = i3 + 1;
                while (j < ySeries.length) {
                    if (maxMin.equals("increasing")) {
                        if (ySeries[j] < ySeries[i3]) {
                            PieChart.exchange(columnKeys, i3, j);
                            PieChart.exchange(ySeries, i3, j);
                        }
                    } else if (ySeries[j] > ySeries[i3]) {
                        PieChart.exchange(columnKeys, i3, j);
                        PieChart.exchange(ySeries, i3, j);
                    }
                    ++j;
                }
                ++i3;
            }
        }
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        int i4 = 0;
        while (i4 < ySeries.length) {
            pieDataset.setValue((Comparable)((Object)columnKeys[i4]), ySeries[i4]);
            ++i4;
        }
        if (order.equals("by name") || order.equals("by id")) {
            if (maxMin.equals("increasing")) {
                pieDataset.sortByKeys(SortOrder.ASCENDING);
            } else {
                pieDataset.sortByKeys(SortOrder.DESCENDING);
            }
        } else if (order.equals("by values")) {
            if (maxMin.equals("increasing")) {
                pieDataset.sortByValues(SortOrder.ASCENDING);
            } else {
                pieDataset.sortByValues(SortOrder.DESCENDING);
            }
        }
        this.chart = ChartFactory.createPieChart((String)chartTitle, (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)false);
        this.chart.setBackgroundPaint((Paint)Color.white);
        PiePlot plot = (PiePlot)this.chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setCircular(true);
        plot.setLabelFont(new Font("Arial", 1, 12));
        Paint[] paint = new Paint[ySeries.length];
        int red1 = c1.getRed();
        int green1 = c1.getGreen();
        int blue1 = c1.getBlue();
        int red2 = c2.getRed();
        int green2 = c2.getGreen();
        int blue2 = c2.getBlue();
        int LARGEUR = ySeries.length;
        int i5 = 0;
        while (i5 < ySeries.length) {
            paint[i5] = new Color((red1 * (LARGEUR - i5) + red2 * i5) / LARGEUR, (green1 * (LARGEUR - i5) + green2 * i5) / LARGEUR, (blue1 * (LARGEUR - i5) + blue2 * i5) / LARGEUR);
            plot.setSectionPaint(i5, paint[i5]);
            ++i5;
        }
        plot.setLabelOutlinePaint(null);
        plot.setLabelShadowPaint(null);
        plot.setLabelBackgroundPaint((Paint)Color.WHITE);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setNoDataMessage("No data available");
    }

    protected static void exchange(String[] columnKeys, int i, int j) {
        String tempKey = columnKeys[j];
        columnKeys[j] = columnKeys[i];
        columnKeys[i] = tempKey;
    }

    protected static void exchange(double[] ySeries, int i, int j) {
        double tempVal = ySeries[j];
        ySeries[j] = ySeries[i];
        ySeries[i] = tempVal;
    }

    public void saveChart(String filepath) {
        File file = new File(filepath);
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)500, (int)270);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveChart(File file) {
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)500, (int)270);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveChart(OutputStream outputStream) {
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)this.chart, (int)500, (int)270);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class Rotator
    extends Timer
    implements ActionListener {
        private static final long serialVersionUID = 4386931737069481352L;
        private PiePlot plot;
        private int angle = 270;

        Rotator(PiePlot plot) {
            super(100, null);
            this.plot = plot;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.plot.setStartAngle((double)this.angle);
            ++this.angle;
            if (this.angle == 360) {
                this.angle = 0;
            }
        }
    }
}

