/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.utils;

import eu.telecom_bretagne.utils.StreamGobbler;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class GraphViz {
    private static String DOT = "dot";
    private static String TRED = "tred";
    private StringBuilder graph = new StringBuilder();
    private boolean transitiveReduction = false;

    public void setTransitiveReduction(boolean transitiveReduction) {
        this.transitiveReduction = transitiveReduction;
    }

    public boolean getTransitiveReduction() {
        return this.transitiveReduction;
    }

    public String getDotSource() {
        return this.graph.toString();
    }

    public void add(String line) {
        this.graph.append(line);
    }

    public void addln(String line) {
        this.graph.append(String.valueOf(line) + "\n");
    }

    public void addln() {
        this.graph.append('\n');
    }

    public int writeGraphToFile(byte[] img, String file) {
        File to = new File(file);
        return this.writeGraphToFile(img, to);
    }

    public int writeGraphToFile(byte[] img, File to) {
        try {
            FileOutputStream fos = new FileOutputStream(to);
            fos.write(img);
            fos.close();
        }
        catch (IOException ioe) {
            return -1;
        }
        return 1;
    }

    public byte[] getGraph(String dot_source, String type2) {
        byte[] img_stream = null;
        try {
            File dot = this.writeDotSourceToFile(dot_source);
            if (dot != null) {
                img_stream = this.get_img_stream(dot, type2, this.transitiveReduction);
                if (!dot.delete()) {
                    System.err.println("Warning: " + dot.getAbsolutePath() + " could not be deleted!");
                }
                return img_stream;
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private byte[] get_img_stream(File dot, String type2, boolean transitive) {
        byte[] img_stream;
        block10: {
            img_stream = null;
            Process p = null;
            try {
                File img = File.createTempFile("graph_", "." + type2, new File(System.getProperty("java.io.tmpdir")));
                if (transitive) {
                    Runtime rt = Runtime.getRuntime();
                    Process p1 = rt.exec(new String[]{TRED, dot.getAbsolutePath()});
                    Process p2 = rt.exec(new String[]{DOT, "-T" + type2, "-o" + img.getAbsolutePath()});
                    StreamGobbler str1 = new StreamGobbler(p2.getInputStream(), null);
                    StreamGobbler str2 = new StreamGobbler(p2.getErrorStream(), null);
                    StreamGobbler str3 = new StreamGobbler(p1.getErrorStream(), null);
                    OutputStreamWriter writer = new OutputStreamWriter(p2.getOutputStream());
                    StreamGobbler str4 = new StreamGobbler(p1.getInputStream(), writer);
                    str1.start();
                    str2.start();
                    str3.start();
                    str4.start();
                    p1.waitFor();
                    try {
                        ((Writer)writer).flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    p2.waitFor();
                    FileInputStream in = new FileInputStream(img.getAbsolutePath());
                    img_stream = new byte[in.available()];
                    in.read(img_stream);
                    if (in != null) {
                        in.close();
                    }
                    if (!img.delete()) {
                        System.err.println("Warning: " + img.getAbsolutePath() + " could not be deleted!");
                    }
                    p1.destroy();
                    p2.destroy();
                    str1.join();
                    str2.join();
                    str3.join();
                    str4.join();
                    break block10;
                }
                String[] args = new String[]{DOT, "-T" + type2, dot.getAbsolutePath(), "-o" + img.getAbsolutePath()};
                Runtime rt = Runtime.getRuntime();
                p = rt.exec(args);
                p.waitFor();
                FileInputStream in = new FileInputStream(img.getAbsolutePath());
                img_stream = new byte[in.available()];
                in.read(img_stream);
                if (in != null) {
                    in.close();
                }
                if (!img.delete()) {
                    System.err.println("Warning: " + img.getAbsolutePath() + " could not be deleted!");
                }
                p.destroy();
            }
            catch (IOException ioe) {
                System.err.println("Error:    in I/O processing of tempfile in java.io.tmpdir \n");
                System.err.println("       or in calling external command");
                ioe.printStackTrace();
            }
            catch (InterruptedException ie) {
                System.err.println("Error: the execution of the external program was interrupted");
                ie.printStackTrace();
            }
        }
        return img_stream;
    }

    private File writeDotSourceToFile(String str) throws IOException {
        File temp;
        try {
            temp = File.createTempFile("graph_", ".dot.tmp", new File(System.getProperty("java.io.tmpdir")));
            FileWriter fout = new FileWriter(temp);
            fout.write(str);
            fout.close();
        }
        catch (Exception e) {
            System.err.println("Error: I/O error while writing the dot source to temp file!");
            return null;
        }
        return temp;
    }

    public String start_graph() {
        return "digraph G {\n";
    }

    public String start_graph(String color, String node_shape) {
        return "digraph G {\nnode [shape=" + node_shape + ", color=" + color + "];\nedge [color=" + color + "];";
    }

    public String end_graph() {
        return "}";
    }

    public void readSource(String input) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            FileInputStream fis = new FileInputStream(input);
            DataInputStream dis = new DataInputStream(fis);
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            dis.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        this.graph = sb;
    }
}

