/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class Graph {
    private static String DOT = "dot";
    private StringBuilder graph = new StringBuilder();

    public String getDotSource() {
        return this.graph.toString();
    }

    public void add(String line) {
        this.graph.append(line);
    }

    public void addln(String line) {
        this.graph.append(String.valueOf(line) + "\n");
    }

    public void addln() {
        this.graph.append('\n');
    }

    public int writeGraphToFile(byte[] img, File to) {
        try {
            FileOutputStream fos = new FileOutputStream(to);
            fos.write(img);
            fos.close();
        }
        catch (IOException ioe) {
            return -1;
        }
        return 1;
    }

    public byte[] getGraph(String dot_source, String type) {
        byte[] img_stream = null;
        try {
            File dot = this.writeDotSourceToFile(dot_source);
            if (dot != null) {
                img_stream = this.get_img_stream(dot, type);
                if (!dot.delete()) {
                    System.err.println("Warning: " + dot.getAbsolutePath() + " could not be deleted!");
                }
                return img_stream;
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private byte[] get_img_stream(File dot, String type) {
        byte[] img_stream = null;
        Process p = null;
        try {
            File img = File.createTempFile("graph_", "." + type, new File(System.getProperty("java.io.tmpdir")));
            String[] args = new String[]{DOT, "-T" + type, dot.getAbsolutePath(), "-o" + img.getAbsolutePath()};
            Runtime rt = Runtime.getRuntime();
            p = rt.exec(args);
            p.waitFor();
            FileInputStream in = new FileInputStream(img.getAbsolutePath());
            img_stream = new byte[in.available()];
            in.read(img_stream);
            if (in != null) {
                in.close();
            }
            if (!img.delete()) {
                System.err.println("Warning: " + img.getAbsolutePath() + " could not be deleted!");
            }
            p.destroy();
        }
        catch (IOException ioe) {
            System.err.println("Error:    in I/O processing of tempfile in java.io.tmpdir \n");
            System.err.println("       or in calling external command");
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            System.err.println("Error: the execution of the external program was interrupted");
            ie.printStackTrace();
        }
        return img_stream;
    }

    private File writeDotSourceToFile(String str) throws IOException {
        File temp;
        try {
            temp = File.createTempFile("graph_", ".dot.tmp", new File(System.getProperty("java.io.tmpdir")));
            FileWriter fout = new FileWriter(temp);
            fout.write(str);
            fout.close();
        }
        catch (Exception e) {
            System.err.println("Error: I/O error while writing the dot source to temp file!");
            return null;
        }
        return temp;
    }

    public String start_graph(String color, String node_shape) {
        return "digraph G {\n node [shape=" + node_shape + ", color=" + color + "];\n edge [color=" + color + "];";
    }

    public String end_graph() {
        return "}";
    }
}

