/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckEntryFiles {
    private String warningMessage = "";

    public boolean checkIDs(Alternatives alternativesToUse, ArrayList<String> list) {
        boolean result = true;
        int diff = 0;
        int size = alternativesToUse.getAlternativeIDs().size();
        if (list.size() != size) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the 'alternatives' tag: incoherence with the number of alternatives given in the file containing the 'alternativesAffectations' tag.");
            result = false;
        } else {
            for (String s : list) {
                if (alternativesToUse.getAlternativeIDs().contains(s)) continue;
                result = false;
                ++diff;
            }
            if (diff > 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the 'alternatives' tag:incoherence with the alternatives given in the file containing the 'alternativesAffectations' tag. There are " + diff + " different alternatives.");
            } else if (diff == 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the 'alternatives' tag:incoherence with the alternatives given in the file containing the 'alternativesAffectations' tag. There is one different alternative.");
            }
        }
        return result;
    }

    public String getWarning() {
        return this.warningMessage;
    }

    public Alternatives getIntersectionIDs(Alternatives alternativesToUse, ArrayList<String> list) {
        Alternatives result = new Alternatives();
        for (String t : alternativesToUse.getListAlternativesIDs()) {
            if (!list.contains(t)) continue;
            int index = alternativesToUse.getListAlternativesIDs().indexOf(t);
            result.addAlternative(new Alternative(alternativesToUse.getListAlternativesIDs().get(index), alternativesToUse.getListAlternativesNames().get(index)));
            result.getAlternativeIDs().add(alternativesToUse.getListAlternativesIDs().get(index));
        }
        return result;
    }

    public ArrayList<String> getIntersectionAffectations(ArrayList<String> intersectAlternatives, ArrayList<String> listAlternIDs, ArrayList<String> listAffectations) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < intersectAlternatives.size()) {
            int indexAltern = listAlternIDs.indexOf(intersectAlternatives.get(i));
            result.add(listAffectations.get(indexAltern));
            ++i;
        }
        return result;
    }
}

