/*
 * Decompiled with CFR 0.152.
 */
import Xmcda_by_Dhouha.Alternatives;
import Xmcda_by_Dhouha.Criteria;
import Xmcda_by_Dhouha.JDOM_Alternatives;
import Xmcda_by_Dhouha.JDOM_Criteria;
import Xmcda_by_Dhouha.JDOM_PerformanceTable;
import Xmcda_by_Dhouha.Main;
import Xmcda_by_Dhouha.PerformanceTable_Config2;
import Xmcda_by_Dhouha.XmcdaMessage;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class transformation {
    protected float getMaximum(PerformanceTable_Config2 test, int indexCriter) {
        float max = test.getMatrixElement(0, indexCriter);
        int i = 0;
        while (i < test.getAlternativeIDs().size()) {
            float courant = test.getMatrixElement(i, indexCriter);
            if (courant > max) {
                max = courant;
            }
            ++i;
        }
        return max;
    }

    protected float getMinimum(PerformanceTable_Config2 test, int indexCriter) {
        float min = test.getMatrixElement(0, indexCriter);
        int i = 0;
        while (i < test.getAlternativeIDs().size()) {
            float courant = test.getMatrixElement(i, indexCriter);
            if (courant < min) {
                min = courant;
            }
            ++i;
        }
        return min;
    }

    protected float getMean(PerformanceTable_Config2 test, int indexCriter) {
        float mean = 0.0f;
        int nbrAltern = test.getAlternativeIDs().size();
        int i = 0;
        while (i < nbrAltern) {
            mean += test.getMatrixElement(i, indexCriter);
            ++i;
        }
        return mean /= (float)nbrAltern;
    }

    protected float getVariance(PerformanceTable_Config2 test, int indexCriter, float mean) {
        float var = 0.0f;
        int i = 0;
        while (i < test.getAlternativeIDs().size()) {
            float courant = test.getMatrixElement(i, indexCriter);
            var = (float)((double)var + Math.pow(courant - mean, 2.0));
            ++i;
        }
        return var;
    }

    protected float[][] divideByMax(PerformanceTable_Config2 test, int indexCriter, boolean allTheCriteria, float[][] matrixToUse) {
        int nbrAltern = test.getAlternativeIDs().size();
        int nbrCriter = test.getCriterionIDs().size();
        float[][] matricePerf = new float[nbrAltern][nbrCriter];
        if (allTheCriteria) {
            int j = 0;
            while (j < nbrCriter) {
                float max = this.getMaximum(test, j);
                int i = 0;
                while (i < nbrAltern) {
                    matricePerf[i][j] = test.getMatrixElement(i, j) / max;
                    ++i;
                }
                ++j;
            }
        } else {
            float max = this.getMaximum(test, indexCriter);
            int i = 0;
            while (i < nbrAltern) {
                matrixToUse[i][indexCriter] = test.getMatrixElement(i, indexCriter) / max;
                ++i;
            }
        }
        if (allTheCriteria) {
            return matricePerf;
        }
        return matrixToUse;
    }

    protected float[][] minMax(PerformanceTable_Config2 test, int indexCriter, boolean allTheCriteria, float[][] matrixToUse) {
        int nbrAltern = test.getAlternativeIDs().size();
        int nbrCriter = test.getCriterionIDs().size();
        float[][] matricePerf = new float[nbrAltern][nbrCriter];
        if (allTheCriteria) {
            int j = 0;
            while (j < nbrCriter) {
                float max = this.getMaximum(test, j);
                float min = this.getMinimum(test, j);
                int i = 0;
                while (i < nbrAltern) {
                    matricePerf[i][j] = (test.getMatrixElement(i, j) - min) / (max - min);
                    ++i;
                }
                ++j;
            }
        } else {
            float max = this.getMaximum(test, indexCriter);
            float min = this.getMinimum(test, indexCriter);
            int i = 0;
            while (i < nbrAltern) {
                matrixToUse[i][indexCriter] = (test.getMatrixElement(i, indexCriter) - min) / (max - min);
                ++i;
            }
        }
        if (allTheCriteria) {
            return matricePerf;
        }
        return matrixToUse;
    }

    protected float[][] meanStdv(PerformanceTable_Config2 test, int indexCriter, boolean allTheCriteria, float[][] matrixToUse) {
        int nbrAltern = test.getAlternativeIDs().size();
        int nbrCriter = test.getCriterionIDs().size();
        float[][] matricePerf = new float[nbrAltern][nbrCriter];
        if (allTheCriteria) {
            int j = 0;
            while (j < nbrCriter) {
                float mean = this.getMean(test, j);
                float var = this.getVariance(test, j, mean);
                float stdv = (float)Math.sqrt(var);
                int i = 0;
                while (i < nbrAltern) {
                    matricePerf[i][j] = (float)(1.0 / ((double)stdv * Math.sqrt(Math.PI * 2)) * Math.exp(-Math.pow(test.getMatrixElement(i, j) - mean, 2.0) / (double)(2.0f * var)));
                    ++i;
                }
                ++j;
            }
        } else {
            float mean = this.getMean(test, indexCriter);
            float var = this.getVariance(test, indexCriter, mean);
            float stdv = (float)Math.sqrt(var);
            int i = 0;
            while (i < nbrAltern) {
                matrixToUse[i][indexCriter] = (float)(1.0 / ((double)stdv * Math.sqrt(Math.PI * 2)) * Math.exp(-Math.pow(test.getMatrixElement(i, indexCriter) - mean, 2.0) / (double)(2.0f * var)));
                ++i;
            }
        }
        if (allTheCriteria) {
            return matricePerf;
        }
        return matrixToUse;
    }

    public PerformanceTable_Config2 uniqueTransform(PerformanceTable_Config2 test, String transf_type) {
        int nbrAltern = test.getAlternativeIDs().size();
        int nbrCriter = test.getCriterionIDs().size();
        float[][] matricePerf = new float[nbrAltern][nbrCriter];
        int i = 0;
        while (i < nbrAltern) {
            int j = 0;
            while (j < nbrCriter) {
                matricePerf[i][j] = test.getMatrixElement(i, j);
                ++j;
            }
            ++i;
        }
        if (transf_type.equals("by max")) {
            matricePerf = this.divideByMax(test, Integer.MIN_VALUE, true, null);
        } else if (transf_type.equals("min max")) {
            matricePerf = this.minMax(test, Integer.MIN_VALUE, true, null);
        } else if (transf_type.equals("by mean and stdv")) {
            matricePerf = this.meanStdv(test, Integer.MIN_VALUE, true, null);
        }
        PerformanceTable_Config2 result = new PerformanceTable_Config2(test.getAlternativeIDs(), test.getCriterionIDs(), matricePerf);
        return result;
    }

    public String UniqueTransformWarning(PerformanceTable_Config2 test, String transf_type) {
        String warning = "";
        if (!(transf_type.equals("by max") || transf_type.equals("min max") || transf_type.equals("by mean and stdv"))) {
            warning = "You have not entered a specific transformation for criteria. No transformation was applied.";
        }
        return warning;
    }

    public PerformanceTable_Config2 MultipleTransform(PerformanceTable_Config2 test, String warningMessage, ArrayList<String> listCriter, ArrayList<String> listTransform) {
        int nbrAltern = test.getAlternativeIDs().size();
        int nbrCriter = test.getCriterionIDs().size();
        float[][] matricePerf = new float[nbrAltern][nbrCriter];
        int i = 0;
        while (i < nbrAltern) {
            int j = 0;
            while (j < nbrCriter) {
                matricePerf[i][j] = test.getMatrixElement(i, j);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < nbrCriter) {
            if (listCriter.contains(test.getCriterionIDs().get(j))) {
                int index = listCriter.indexOf(test.getCriterionIDs().get(j));
                String transformation2 = listTransform.get(index);
                if (transformation2.equals("by max")) {
                    matricePerf = this.divideByMax(test, j, false, matricePerf);
                } else if (transformation2.equals("min max")) {
                    matricePerf = this.minMax(test, j, false, matricePerf);
                } else if (transformation2.equals("by mean and stdv")) {
                    matricePerf = this.meanStdv(test, j, false, matricePerf);
                }
            } else {
                warningMessage = warningMessage.concat("You have not entered a specific transformation for criterion " + test.getCriterionIDs().get(j) + ". No transformation was applied.");
            }
            ++j;
        }
        PerformanceTable_Config2 result = new PerformanceTable_Config2(test.getAlternativeIDs(), test.getCriterionIDs(), matricePerf);
        return result;
    }

    public String MultipleTransformWarning(PerformanceTable_Config2 test, ArrayList<String> listCriter, ArrayList<String> listTransform) {
        String warningMessage = "";
        int nbrCriter = test.getCriterionIDs().size();
        int j = 0;
        while (j < nbrCriter) {
            if (listCriter.contains(test.getCriterionIDs().get(j))) {
                int index = listCriter.indexOf(test.getCriterionIDs().get(j));
                String transformation2 = listTransform.get(index);
                if (!(transformation2.equals("by max") || transformation2.equals("min max") || transformation2.equals("by mean and stdv"))) {
                    warningMessage = warningMessage.concat("You have not entered a correct transformation for criterion " + test.getCriterionIDs().get(j) + ". No transformation was applied.");
                }
            } else {
                warningMessage = warningMessage.concat("You have not entered a specific transformation for criterion " + test.getCriterionIDs().get(j) + ". No transformation was applied.");
            }
            ++j;
        }
        return warningMessage;
    }

    public static void main(String[] argv) {
        boolean stopRunning = false;
        String tempErrorMessage = "";
        String warningMessage = "";
        if (argv.length == 6) {
            if (!(new File(argv[0]).exists() && new File(argv[1]).exists() && new File(argv[2]).exists() && new File(argv[3]).exists())) {
                stopRunning = true;
            } else if (argv.length == 7) {
                stopRunning = !new File(argv[0]).exists() || !new File(argv[1]).exists() || !new File(argv[2]).exists() || !new File(argv[3]).exists() || !new File(argv[4]).exists() ? true : true;
            }
        }
        if (stopRunning) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
        }
        if (!stopRunning) {
            Main mainFunction = new Main();
            PerformanceTable_Config2 test = new PerformanceTable_Config2();
            String pathParameters = argv[0];
            String pathAlternatives = argv[argv.length - 5];
            String pathCriteria = argv[argv.length - 4];
            String pathPerfTable = argv[argv.length - 3];
            String errParam = mainFunction.checkEntryFile(pathParameters);
            String errAltern = mainFunction.checkEntryFile(pathAlternatives);
            String errCriter = mainFunction.checkEntryFile(pathCriteria);
            String errPerfTable = mainFunction.checkEntryFile(pathPerfTable);
            if (errParam != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document.");
            }
            if (errAltern != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.");
            }
            if (errCriter != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
            }
            if (errPerfTable != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the performanceTable tag is not a valid XMCDA document.");
            }
            if (errParam != "" || errAltern != "" || errCriter != "" || errPerfTable != "") {
                XmcdaMessage xmcdaMess = new XmcdaMessage();
                xmcdaMess.createErrorMessage(tempErrorMessage);
                String pathOutputMessage = argv[5];
                xmcdaMess.enregistre(pathOutputMessage);
            } else {
                ParametersPerCriter paramPerCriter = new ParametersPerCriter();
                mainFunction.PrepareParsing(pathParameters);
                boolean statusUserParam = paramPerCriter.parse(mainFunction.getRacine());
                boolean uniqueTransform = paramPerCriter.getUniqueTransformation();
                if (paramPerCriter.getWarning() != "") {
                    warningMessage = warningMessage.equals("") ? "\n" + paramPerCriter.getWarning() : warningMessage.concat("\n" + paramPerCriter.getWarning());
                }
                if (!statusUserParam) {
                    tempErrorMessage = tempErrorMessage.equals("") ? (paramPerCriter.getWarning() != "" ? "\nFatal Error: the file containing the methodParameters tag is erroneous or empty (" + paramPerCriter.getWarning() + ")." : "\nFatal Error: the file containing the methodParameters tag is erroneous or empty.") : (paramPerCriter.getWarning() != "" ? tempErrorMessage.concat("\nFatal Error: the file containing the methodParameters tag is erroneous or empty (" + paramPerCriter.getWarning() + ").") : tempErrorMessage.concat("\nFatal Error: the file containing the methodParameters tag is erroneous or empty."));
                }
                JDOM_Criteria jdomCriter = new JDOM_Criteria();
                mainFunction.PrepareParsing(pathCriteria);
                boolean parseCriterNull = false;
                Criteria criter = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
                if (jdomCriter.getWarning() != "") {
                    warningMessage = warningMessage.equals("") ? "\n" + jdomCriter.getWarning() : warningMessage.concat("\n" + jdomCriter.getWarning());
                }
                if (criter == null) {
                    parseCriterNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the criteria tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty.");
                }
                mainFunction.PrepareParsing(pathAlternatives);
                JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
                boolean parseAlternativesNull = false;
                Alternatives alter = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
                if (jdomAlter.getWarning() != "") {
                    warningMessage = warningMessage.equals("") ? "\n" + jdomAlter.getWarning() : warningMessage.concat("\n" + jdomAlter.getWarning());
                }
                if (alter == null) {
                    parseAlternativesNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
                }
                mainFunction.PrepareParsing(pathPerfTable);
                JDOM_PerformanceTable jdomPerfTable = new JDOM_PerformanceTable();
                boolean parsePerfTableNull = false;
                PerformanceTable_Config2 perfTable = jdomPerfTable.explorePerformanceTable(mainFunction.getRacine());
                if (jdomPerfTable.getErrorMessage() != "") {
                    warningMessage = warningMessage.concat("\n" + jdomPerfTable.getErrorMessage());
                }
                if (perfTable == null) {
                    parsePerfTableNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the performanceTable tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the performanceTable tag is erroneous or empty.");
                }
                if (!parseCriterNull && !parseAlternativesNull && !parsePerfTableNull && statusUserParam) {
                    test = mainFunction.run(test, pathCriteria, pathAlternatives, pathPerfTable);
                    warningMessage = warningMessage.concat(mainFunction.getWarningMessage());
                    tempErrorMessage = tempErrorMessage.concat(mainFunction.getErrorMessage());
                    transformation transf = new transformation();
                    if (test.getAlternativeIDs().size() != 0 && test.getCriterionIDs().size() != 0) {
                        if (uniqueTransform) {
                            String transf_type = paramPerCriter.getGlobalTransform();
                            warningMessage = warningMessage.concat(transf.UniqueTransformWarning(test, transf_type));
                            test = transf.uniqueTransform(test, transf_type);
                        } else {
                            warningMessage = warningMessage.concat(transf.MultipleTransformWarning(test, paramPerCriter.getListCriteria(), paramPerCriter.getAllTransforms()));
                            test = transf.MultipleTransform(test, warningMessage, paramPerCriter.getListCriteria(), paramPerCriter.getAllTransforms());
                        }
                    } else {
                        tempErrorMessage = tempErrorMessage.concat("\n We cannot run the algorithm since the criteria list or the alternatives list of the PROJECT is empty.\n");
                    }
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    xmcdaMess.createLogMessage(errCriter, errAltern, errPerfTable, warningMessage, tempErrorMessage);
                    String pathOutputMessage = argv[argv.length - 1];
                    xmcdaMess.enregistre(pathOutputMessage);
                    if (test.getAlternativeIDs().size() != 0 && test.getCriterionIDs().size() != 0) {
                        OutputPerfTableFile outputPerfTable = new OutputPerfTableFile();
                        outputPerfTable.createOutputFile(test, "Transformed performance table");
                        String pathOutputFile = argv[argv.length - 2];
                        outputPerfTable.save(pathOutputFile);
                    }
                } else {
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    xmcdaMess.createErrorMessage(tempErrorMessage);
                    String pathOutputMessage = argv[argv.length - 1];
                    xmcdaMess.enregistre(pathOutputMessage);
                }
            }
        } else {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(tempErrorMessage);
            String pathOutputMessage = argv[argv.length - 1];
            xmcdaMess.enregistre(pathOutputMessage);
        }
    }
}

