/*
 * Decompiled with CFR 0.152.
 */
package Xmcda_by_Dhouha;

import Xmcda_by_Dhouha.AlternativesValues;
import Xmcda_by_Dhouha.CriteriaValues;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.swtchart.Chart;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class BarChartExample {
    private double[] ySeries;

    public BarChartExample() {
    }

    public BarChartExample(double[] ySeries) {
        this.ySeries = ySeries;
    }

    public void representBarChart(AlternativesValues alternaValuesToPlot) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Bar Chart ");
        shell.setSize(500, 400);
        shell.setLayout((Layout)new FillLayout());
        this.createChart((Composite)shell, alternaValuesToPlot);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Chart representBarChartCriteriaValues(CriteriaValues criteriaValuesToPlot, int format, String pathImage, boolean color) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Bar Chart ");
        shell.setSize(500, 400);
        shell.setLayout((Layout)new FillLayout());
        Chart result = this.createChartCriterValues((Composite)shell, criteriaValuesToPlot, color);
        shell.open();
        result.save(pathImage, format);
        shell.close();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        return result;
    }

    public Chart createChart(Composite parent, AlternativesValues alternaValuesToPlot) {
        int size = alternaValuesToPlot.getListAlternativesValues().size();
        int i = 0;
        while (i < size) {
            this.ySeries[i] = alternaValuesToPlot.getListAlternativesValues().get(i).getRealValue();
            ++i;
        }
        Chart chart = new Chart(parent, 0);
        chart.getTitle().setText("Bar Chart for the AlternativesValues");
        String temp = "";
        int i2 = 0;
        while (i2 < size) {
            temp = temp.concat(alternaValuesToPlot.getListAlternativesValues().get(i2).getAlternativeValueId());
            if (i2 < size - 2) {
                temp = temp.concat(", ");
            }
            if (i2 == size - 2) {
                temp = temp.concat(" and ");
            }
            ++i2;
        }
        chart.getAxisSet().getXAxis(0).getTitle().setText("Alternatives ID:   " + temp);
        chart.getAxisSet().getYAxis(0).getTitle().setText("Alternatives Values");
        IBarSeries barSeries = (IBarSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.BAR, "bar series");
        barSeries.setYSeries(this.ySeries);
        barSeries.setBarColor(new Color(null, 150, 10, 100));
        chart.getAxisSet().adjustRange();
        return chart;
    }

    public Chart createChartCriterValues(Composite parent, CriteriaValues criteriaValuesToPlot, boolean color) {
        int size = criteriaValuesToPlot.getListCriteriaValues().size();
        Color blackWhite = new Color(null, 10, 10, 10);
        int i = 0;
        while (i < size) {
            this.ySeries[i] = criteriaValuesToPlot.getListCriteriaValues().get(i).getRealValue();
            ++i;
        }
        Chart chart = new Chart(parent, 0);
        chart.getTitle().setText("Bar Chart for the CriteriaValues");
        if (!color) {
            chart.getTitle().setForeground(blackWhite);
        }
        String temp = "";
        int i2 = 0;
        while (i2 < size) {
            temp = temp.concat(criteriaValuesToPlot.getListCriteriaValues().get(i2).getCriterionId());
            if (i2 < size - 2) {
                temp = temp.concat(", ");
            }
            if (i2 == size - 2) {
                temp = temp.concat(" and ");
            }
            ++i2;
        }
        chart.getAxisSet().getXAxis(0).getTitle().setText("Criterion ID:   " + temp);
        if (!color) {
            chart.getAxisSet().getXAxis(0).getTitle().setForeground(blackWhite);
            chart.getAxisSet().getXAxis(0).getTick().setForeground(blackWhite);
            chart.getAxisSet().getXAxis(0).getTick().setFont(new Font((Device)parent.getDisplay(), "Times", 10, 1));
        }
        chart.getAxisSet().getYAxis(0).getTitle().setText("Criteria Values");
        if (!color) {
            chart.getAxisSet().getYAxis(0).getTitle().setForeground(blackWhite);
            chart.getAxisSet().getYAxis(0).getTick().setForeground(blackWhite);
            chart.getAxisSet().getYAxis(0).getTick().setFont(new Font((Device)parent.getDisplay(), "Times", 10, 1));
        }
        IBarSeries barSeries = (IBarSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.BAR, "bar series");
        barSeries.setYSeries(this.ySeries);
        if (color) {
            barSeries.setBarColor(new Color(null, 150, 10, 100));
        } else {
            barSeries.setBarColor(blackWhite);
        }
        chart.getAxisSet().adjustRange();
        return chart;
    }
}

