/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.AlternativesValues;
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.GestionIncoherentFiles;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives;
import eu.telecom_bretagne.xmcda.JDOM_Criteria;
import eu.telecom_bretagne.xmcda.JDOM_PerformanceTable;
import eu.telecom_bretagne.xmcda.MyValid;
import eu.telecom_bretagne.xmcda.PerformanceTable_Config2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Main {
    static Document document;
    static Element racine;
    private AlternativesValues alternaValuesToPlot;
    private Alternatives alternativesToUse;
    private Criteria criteriaToUse = new Criteria();
    private String warningMessage = "";
    private boolean activateMatrixInt = false;
    private boolean activateMatrixReal = false;
    private String tempErrorMessage = "";

    public Main() {
        this.alternativesToUse = new Alternatives();
        this.alternaValuesToPlot = new AlternativesValues();
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public String getErrorMessage() {
        return this.tempErrorMessage;
    }

    public String checkEntryFile(String path) {
        String error = "";
        try {
            new MyValid().parseXML(path);
        }
        catch (JDOMException e) {
            error = error.concat("File is not well-formed: " + e.getMessage());
        }
        catch (IOException e) {
            error = error.concat("Could not check file because: " + e.getMessage());
        }
        return error;
    }

    public void PrepareParsing(String path) {
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(new File(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        racine = document.getRootElement();
    }

    public PerformanceTable_Config2 run(PerformanceTable_Config2 perfTableAfterParsingXML, String pathCriteria, String pathAlternatives, String pathPerfTable) {
        ArrayList<String> listintersectionCriteria;
        ArrayList<String> listintersectionAlternatives;
        JDOM_Criteria jdomCriter = new JDOM_Criteria();
        JDOM_Alternatives jdomAltern = new JDOM_Alternatives();
        JDOM_PerformanceTable jdomPerfTable = new JDOM_PerformanceTable();
        this.PrepareParsing(pathCriteria);
        this.criteriaToUse = jdomCriter.parseCriteriaXML(racine);
        this.PrepareParsing(pathAlternatives);
        this.alternativesToUse = jdomAltern.exploreAlternativesXML(racine);
        this.PrepareParsing(pathPerfTable);
        perfTableAfterParsingXML = jdomPerfTable.explorePerformanceTable(racine);
        if (jdomPerfTable.getErrorMessage() != "") {
            this.tempErrorMessage = this.tempErrorMessage.concat(jdomPerfTable.getErrorMessage());
        }
        if (jdomPerfTable.getWarningMessage() != "") {
            this.warningMessage = this.warningMessage.concat(jdomPerfTable.getWarningMessage());
        }
        GestionIncoherentFiles gest = new GestionIncoherentFiles(this.criteriaToUse, this.alternativesToUse, perfTableAfterParsingXML);
        boolean checkAlt = gest.checkAlternatives(this.alternativesToUse, perfTableAfterParsingXML);
        boolean checkCrit = gest.checkCriteria(this.criteriaToUse, perfTableAfterParsingXML);
        if (!checkAlt) {
            this.warningMessage = this.warningMessage.concat(gest.getWarningAlternatives());
        }
        if (!checkCrit) {
            this.warningMessage = this.warningMessage.concat(gest.getWarningCriteria());
        }
        if ((listintersectionAlternatives = gest.getIntersectionAlternativesIDs()).isEmpty()) {
            this.warningMessage = this.warningMessage.concat("\nOnly the alternativesIDs in the file containing the performance table tag were considered. Please check your input file containing the alternatives tag.");
            listintersectionAlternatives = perfTableAfterParsingXML.getAlternativeIDs();
        }
        if ((listintersectionCriteria = gest.getIntersectionCriteriaIDs()).isEmpty()) {
            this.warningMessage = this.warningMessage.concat("\nOnly the criterionIDs in the file containing the performance table tag were considered. Please check your input file containing the criteria tag.");
            listintersectionCriteria = perfTableAfterParsingXML.getCriterionIDs();
        }
        float[][] matricePerf = new float[listintersectionAlternatives.size()][listintersectionCriteria.size()];
        int l = 0;
        while (l < listintersectionAlternatives.size()) {
            int c = 0;
            while (c < listintersectionCriteria.size()) {
                matricePerf[l][c] = perfTableAfterParsingXML.getMatrixElement(perfTableAfterParsingXML.getAlternativeIDs().indexOf(listintersectionAlternatives.get(l)), perfTableAfterParsingXML.getCriterionIDs().indexOf(listintersectionCriteria.get(c)));
                ++c;
            }
            ++l;
        }
        perfTableAfterParsingXML = new PerformanceTable_Config2(listintersectionAlternatives, listintersectionCriteria, matricePerf);
        return perfTableAfterParsingXML;
    }

    public boolean getActivateMatrixInt() {
        return this.activateMatrixInt;
    }

    public boolean getActivateMatrixReal() {
        return this.activateMatrixReal;
    }

    public Element getRacine() {
        return racine;
    }
}

