/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import eu.telecom_bretagne.xmcda.PerformanceTable_Config2;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DisplayMatrix {
    private static final int MAX_ALTERNATIVES = 10;
    private String[] CRITERIA_IDs;
    private Font font;
    private Color[] colors = new Color[10];

    public void run(PerformanceTable_Config2 perfTableToRun) {
        int sizeColumns = perfTableToRun.getCriterionIDs().size();
        this.CRITERIA_IDs = new String[sizeColumns + 1];
        int i = 0;
        while (i < perfTableToRun.getAlternativeIDs().size()) {
            int j = 0;
            while (j <= sizeColumns) {
                if (j == 0) {
                    this.CRITERIA_IDs[0] = "";
                } else {
                    this.CRITERIA_IDs[j] = perfTableToRun.getCriterionIDs().get(j - 1);
                }
                ++j;
            }
            ++i;
        }
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("This is the performance table:");
        this.createContents((Composite)shell, perfTableToRun);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.dispose();
        display.dispose();
    }

    private void dispose() {
        if (this.font != null) {
            this.font.dispose();
        }
        int i = 0;
        int n = this.colors.length;
        while (i < n) {
            if (this.colors[i] != null) {
                this.colors[i].dispose();
            }
            ++i;
        }
    }

    private void createFont() {
        this.font = new Font((Device)Display.getCurrent(), "Terminal", 10, 0);
    }

    private TableColumn[] createColumns(Table table) {
        TableColumn[] columns = new TableColumn[this.CRITERIA_IDs.length];
        int i = 0;
        int n = columns.length;
        while (i < n) {
            columns[i] = new TableColumn(table, 131072);
            columns[i].setText(this.CRITERIA_IDs[i]);
            ++i;
        }
        return columns;
    }

    private void createContents(Composite composite, PerformanceTable_Config2 perfTable) {
        composite.setLayout((Layout)new FillLayout());
        this.createFont();
        Table table = new Table(composite, 65538);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setRedraw(false);
        table.setFont(this.font);
        TableColumn[] columns = this.createColumns(table);
        int i = 0;
        while (i < 10) {
            this.colors[i] = new Color((Device)table.getDisplay(), 250, 250, 250);
            int c = 0;
            TableItem item = new TableItem(table, 0);
            item.setText(c++, i < perfTable.getAlternativeIDs().size() ? perfTable.getAlternativeIDs().get(i) : "");
            int j = 0;
            while (j < perfTable.getCriterionIDs().size()) {
                item.setText(j + 1, Double.toString(perfTable.getMatrixElement(perfTable.getAlternativeIDs().indexOf(perfTable.getAlternativeIDs().get(i)), perfTable.getAlternativeIDs().indexOf(perfTable.getAlternativeIDs().get(j)))));
                ++j;
            }
            item.setBackground(this.colors[i]);
            ++i;
        }
        i = 0;
        int n = columns.length;
        while (i < n) {
            columns[i].pack();
            ++i;
        }
        table.setRedraw(true);
    }
}

