/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.AlternativeValue;
import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.AlternativesComparisons;
import eu.telecom_bretagne.xmcda.AlternativesValues;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives_Comparisons;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Distillation {
    private String warningMessage = "";

    public ArrayList<Set<Alternative>> createDownDistillation(AlternativesComparisons alternComp) {
        return this.createDistillation(alternComp, new Comparator<AlternativeValue>(){

            @Override
            public int compare(AlternativeValue a1, AlternativeValue a2) {
                return Float.compare(a2.getRealValue(), a1.getRealValue());
            }
        }, false);
    }

    public ArrayList<Set<Alternative>> createUpDistillation(AlternativesComparisons alternComp) {
        return this.createDistillation(alternComp, new Comparator<AlternativeValue>(){

            @Override
            public int compare(AlternativeValue a1, AlternativeValue a2) {
                return Float.compare(a1.getRealValue(), a2.getRealValue());
            }
        }, true);
    }

    protected ArrayList<Set<Alternative>> createDistillation(AlternativesComparisons alternComp, Comparator<AlternativeValue> comparator, boolean inverse) {
        AlternativesComparisons currentAltComp = new AlternativesComparisons(alternComp);
        ArrayList<Set<Alternative>> distillation = new ArrayList<Set<Alternative>>();
        while (currentAltComp.nbRows() > 0) {
            ArrayList<AlternativeValue> qualifications = Distillation.getQualification(currentAltComp).getListAlternativesValues();
            Collections.sort(qualifications, comparator);
            float first = qualifications.get(0).getRealValue();
            HashSet<Alternative> set = new HashSet<Alternative>();
            for (AlternativeValue av : qualifications) {
                if (av.getRealValue() != first) break;
                set.add(av.getAlternative());
                currentAltComp.removeAlternative(av.getAlternative());
            }
            if (inverse) {
                distillation.add(0, set);
                continue;
            }
            distillation.add(set);
        }
        return distillation;
    }

    protected static AlternativesValues getQualification(AlternativesComparisons alternativesComparisons) {
        AlternativesValues qualification = new AlternativesValues();
        for (Alternative a : alternativesComparisons.rows()) {
            float puissance = 0.0f;
            float faiblesse = 0.0f;
            for (Alternative b : alternativesComparisons.rows()) {
                if (alternativesComparisons.isSet(a, b)) {
                    puissance += ((Float)alternativesComparisons.getValue(a, b)).floatValue();
                }
                if (!alternativesComparisons.isSet(b, a)) continue;
                faiblesse += ((Float)alternativesComparisons.getValue(b, a)).floatValue();
            }
            qualification.addAlternative(new AlternativeValue(a, puissance - faiblesse));
        }
        return qualification;
    }

    public AlternativesComparisons getPreorder(AlternativesComparisons alternativesComparisons, ArrayList<Set<Alternative>> downDistill, ArrayList<Set<Alternative>> upDistill) {
        Iterator<Alternative> a;
        AlternativesComparisons preorder = new AlternativesComparisons();
        for (Alternative alternative : alternativesComparisons.columns()) {
            preorder.addAlternative(alternative, false);
        }
        HashMap<Alternative, Integer> orderDown = new HashMap<Alternative, Integer>();
        HashMap<Alternative, Integer> orderUp = new HashMap<Alternative, Integer>();
        int rank = 1;
        for (Set<Alternative> s : downDistill) {
            a = s.iterator();
            while (a.hasNext()) {
                orderDown.put(a.next(), rank);
            }
            rank += s.size();
        }
        rank = 1;
        for (Set<Alternative> s : upDistill) {
            a = s.iterator();
            while (a.hasNext()) {
                orderUp.put(a.next(), rank);
            }
            rank += s.size();
        }
        for (Alternative a_i : alternativesComparisons.rows()) {
            for (Alternative a_j : alternativesComparisons.rows()) {
                boolean i_equivalent_to_j_in_up;
                if (a_i == a_j) continue;
                boolean i_prefered_to_j_in_down = (Integer)orderDown.get(a_i) < (Integer)orderDown.get(a_j);
                boolean i_prefered_to_j_in_up = (Integer)orderUp.get(a_i) < (Integer)orderUp.get(a_j);
                boolean i_equivalent_to_j_in_down = orderDown.get(a_i) == orderDown.get(a_j);
                boolean bl = i_equivalent_to_j_in_up = orderUp.get(a_i) == orderUp.get(a_j);
                if (i_prefered_to_j_in_up && (i_prefered_to_j_in_down || i_equivalent_to_j_in_down)) {
                    preorder.setValue(a_i, a_j, Float.valueOf(1.0f));
                    continue;
                }
                if (!i_equivalent_to_j_in_up) continue;
                if (i_prefered_to_j_in_down) {
                    preorder.setValue(a_i, a_j, Float.valueOf(1.0f));
                    continue;
                }
                if (!i_equivalent_to_j_in_down) continue;
                preorder.setValue(a_i, a_j, Float.valueOf(1.0f));
            }
        }
        return preorder;
    }

    public static void main(String[] argv) {
        String pathOutputMessage;
        XmcdaMessage xmcdaMess;
        String errAlternativesComparisons;
        String errorMessage = "";
        if (argv.length != 6 || !new File(argv[0]).exists() || !new File(argv[1]).exists()) {
            errorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
            XmcdaMessage xmcdaMess2 = new XmcdaMessage();
            xmcdaMess2.createErrorMessage(errorMessage);
            String pathOutputMessage2 = argv[5];
            xmcdaMess2.enregistre(pathOutputMessage2);
            return;
        }
        String pathAlternatives = argv[0];
        String pathAlternativesComparisons = argv[1];
        Main mainFunction = new Main();
        Distillation distillation = new Distillation();
        String errAlternatives = mainFunction.checkEntryFile(pathAlternatives);
        if (errAlternatives != "") {
            errorMessage = errorMessage.concat("\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.");
        }
        if ((errAlternativesComparisons = mainFunction.checkEntryFile(pathAlternativesComparisons)) != "") {
            errorMessage = errorMessage.concat("\nFatal Error: the file containing the alternativesComparisons tag is not a valid XMCDA document.");
        }
        if (errAlternatives != "" || errAlternativesComparisons != "") {
            XmcdaMessage xmcdaMess3 = new XmcdaMessage();
            xmcdaMess3.createErrorMessage(errorMessage);
            String pathOutputMessage3 = argv[5];
            xmcdaMess3.enregistre(pathOutputMessage3);
            return;
        }
        if (mainFunction.getWarningMessage() != "") {
            distillation.warningMessage = distillation.warningMessage.concat(mainFunction.getWarningMessage());
        }
        mainFunction.PrepareParsing(pathAlternatives);
        Alternatives alternativesToUse = new Alternatives();
        JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
        boolean parseAlternativesNull = false;
        alternativesToUse = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
        if (alternativesToUse == null) {
            parseAlternativesNull = true;
            errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
        }
        if (jdomAlter.getWarning() != "") {
            distillation.warningMessage = distillation.warningMessage.concat("\n" + jdomAlter.getWarning());
        }
        mainFunction.PrepareParsing(pathAlternativesComparisons);
        JDOM_Alternatives_Comparisons jdomAlterComp = new JDOM_Alternatives_Comparisons();
        boolean parseAlternCompNull = false;
        AlternativesComparisons alternCompaToUse = jdomAlterComp.exploreAlternativesComparisonsXML(mainFunction.getRacine(), alternativesToUse, true);
        if (alternCompaToUse == null) {
            parseAlternCompNull = true;
            errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the alternativesComparisons tag (outrankingRelation) is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the alternativesComparisons tag (outrankingRelation) is erroneous or empty.");
        }
        if (jdomAlterComp.getWarningMessage() != "") {
            distillation.warningMessage = distillation.warningMessage.concat("\n" + jdomAlterComp.getWarningMessage());
        }
        if (parseAlternCompNull || parseAlternativesNull) {
            xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            pathOutputMessage = argv[5];
            xmcdaMess.enregistre(pathOutputMessage);
        }
        if (alternCompaToUse.nbRows() == 0) {
            xmcdaMess = new XmcdaMessage();
            errorMessage = errorMessage.concat("Failure to run the algorithm because it seems that the file containing the alternativesComparisons tag (outrankingRelation) is empty or erroneous.");
            xmcdaMess.createLogMessagePlotAlternativesComparisons(errAlternatives, errAlternativesComparisons, distillation.warningMessage, errorMessage);
            pathOutputMessage = argv[2];
            xmcdaMess.enregistre(pathOutputMessage);
            return;
        }
        ArrayList<Set<Alternative>> downDistil = distillation.createDownDistillation(alternCompaToUse);
        ArrayList<Set<Alternative>> upDistil = distillation.createUpDistillation(alternCompaToUse);
        AlternativesComparisons intersDistill = distillation.getPreorder(alternCompaToUse, downDistil, upDistil);
        XmcdaMessage xmcdaMess4 = new XmcdaMessage();
        xmcdaMess4.createLogMessagePlotAlternativesComparisons(errAlternatives, errAlternativesComparisons, distillation.warningMessage, errorMessage);
        String pathOutputMessage4 = argv[5];
        xmcdaMess4.enregistre(pathOutputMessage4);
        String pathDownDistil = argv[2];
        OutputFile downOutputFile = new OutputFile();
        downOutputFile.createOutputFile(downDistil, "downwards distillation");
        downOutputFile.saveFile(pathDownDistil);
        String pathUpDistil = argv[3];
        OutputFile upOutputFile = new OutputFile();
        upOutputFile.createOutputFile(upDistil, "upwards distillation");
        upOutputFile.saveFile(pathUpDistil);
        String pathInterDistil = argv[4];
        OutputFile intersOutputFile = new OutputFile();
        intersOutputFile.createIntersection(intersDistill, "intersection of upwards and downwards distillation");
        intersOutputFile.saveFile(pathInterDistil);
    }
}

