/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.optimization.linear.LinearConstraint;
import org.junit.Assert;
import org.junit.Test;
import utafx.Alternative;
import utafx.Criterion;
import utafx.LinearFunction;
import utafx.Ranking;
import utafx.UtaStarSolver;
import utafx.WVariablesRepresentation;

public class UtaStarSolverTest {
    @Test
    public void testDoPostOptimalAnalysis() {
        UtaStarSolver tested = new UtaStarSolver();
        WVariablesRepresentation[] wReps = new WVariablesRepresentation[5];
        double[][] wCoefficients = new double[][]{{1.0, 0.93}, {1.0, 1.0, 1.0}, {1.0, 0.0, 0.0}};
        wReps[0] = new WVariablesRepresentation(wCoefficients, null);
        wCoefficients = new double[][]{{1.0, 0.86}, {1.0, 1.0, 0.0}, {1.0, 1.0, 0.0}};
        wReps[1] = new WVariablesRepresentation(wCoefficients, null);
        wCoefficients = new double[][]{{1.0, 1.0}, {1.0, 1.0, 0.0}, {0.0, 0.0, 0.0}};
        wReps[2] = new WVariablesRepresentation(wCoefficients, null);
        wCoefficients = new double[][]{{1.0, 0.71}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        wReps[3] = new WVariablesRepresentation(wCoefficients, null);
        wCoefficients = new double[][]{{0.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 1.0, 1.0}};
        wReps[4] = new WVariablesRepresentation(wCoefficients, null);
        Criterion price = new Criterion(30.0, 2.0, 2);
        Criterion time = new Criterion(40.0, 10.0, 3);
        Criterion comfort = new Criterion(0.0, 3.0, 3);
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(price);
        criteria.add(time);
        criteria.add(comfort);
        Alternative rer = new Alternative(new double[]{3.0, 10.0, 1.0}, criteria);
        Alternative metro1 = new Alternative(new double[]{4.0, 20.0, 2.0}, criteria);
        Alternative metro2 = new Alternative(new double[]{2.0, 20.0, 0.0}, criteria);
        Alternative bus = new Alternative(new double[]{6.0, 40.0, 0.0}, criteria);
        Alternative taxi = new Alternative(new double[]{30.0, 30.0, 3.0}, criteria);
        List<Alternative> alternatives = Arrays.asList(rer, metro1, metro2, bus, taxi);
        List<LinearConstraint> constraints = tested.prepareConstraints(wReps, new Ranking<Alternative>(new double[]{1.0, 2.0, 2.0, 3.0, 4.0}, rer, metro1, metro2, bus, taxi));
        double precision = 0.001;
        LinearFunction[] result = tested.doPostOptimalAnalysis(0.0, wReps, constraints, alternatives, criteria);
        Double[] vals = result[0].getValues();
        Assert.assertEquals((double)0.0, (double)vals[0], (double)1.0E-4);
        Assert.assertEquals((double)0.387, (double)vals[1], (double)0.001);
        Assert.assertEquals((double)0.502, (double)vals[2], (double)0.001);
        vals = result[1].getValues();
        Assert.assertEquals((double)0.0, (double)vals[0], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)vals[1], (double)1.0E-4);
        Assert.assertEquals((double)0.0166, (double)vals[2], (double)0.001);
        Assert.assertEquals((double)0.341, (double)vals[3], (double)0.001);
        vals = result[2].getValues();
        Assert.assertEquals((double)0.0, (double)vals[0], (double)1.0E-4);
        Assert.assertEquals((double)0.016, (double)vals[1], (double)0.001);
        Assert.assertEquals((double)0.016, (double)vals[2], (double)0.001);
        Assert.assertEquals((double)0.155, (double)vals[3], (double)0.001);
    }
}

