/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.LinearConstraint;
import org.apache.commons.math.optimization.linear.LinearObjectiveFunction;
import org.apache.commons.math.optimization.linear.Relationship;
import org.apache.commons.math.optimization.linear.SimplexSolver;
import utafx.Alternative;
import utafx.Criterion;
import utafx.IUtaSolver;
import utafx.LinearFunction;
import utafx.MarginalValuesRepresentation;
import utafx.Ranking;
import utafx.RankingUtils;
import utafx.WVariablesRepresentation;

public class UtaStarSolver
implements IUtaSolver {
    private static final RankingUtils RANKING_UTILS = new RankingUtils();
    private double indifferenceThreshold = 0.05;
    private final boolean doPostOptimalAnalysis;
    private LinearFunction[] bestFunctions;
    private double bestKendall;

    public UtaStarSolver() {
        this(true);
    }

    public UtaStarSolver(boolean doPostOptimalAnalysis) {
        this.doPostOptimalAnalysis = doPostOptimalAnalysis;
    }

    @Override
    public LinearFunction[] solve(Ranking<Alternative> ranking, List<Criterion> criteria, List<Alternative> alternatives) {
        this.setMinMaxValuesOfCriteria(criteria, alternatives);
        return this.solve(ranking, criteria);
    }

    @Override
    public LinearFunction[] solve(Ranking<Alternative> ranking, Criterion[] criteria, Alternative[] alternatives) {
        return this.solve(ranking, Arrays.asList(criteria), Arrays.asList(alternatives));
    }

    private void setMinMaxValuesOfCriteria(List<Criterion> criteria, List<Alternative> alternatives) {
        for (Criterion criterion : criteria) {
            double maxValue = Double.MIN_VALUE;
            double minValue = Double.MAX_VALUE;
            for (Alternative alt : alternatives) {
                double val = alt.getValueOn(criterion);
                if (val > maxValue) {
                    maxValue = val;
                }
                if (!(val < minValue)) continue;
                minValue = val;
            }
            if (criterion.isGain()) {
                criterion.setBestValue(maxValue);
                criterion.setWorstValue(minValue);
                continue;
            }
            criterion.setBestValue(minValue);
            criterion.setWorstValue(maxValue);
        }
    }

    public LinearFunction[] solve(Ranking<Alternative> ranking, List<Criterion> criteria) {
        if (!this.doPostOptimalAnalysis) {
            return this.solve_OldImplementation(ranking, criteria);
        }
        this.bestFunctions = null;
        this.bestKendall = -2.0;
        double initialThreshold = 1.0 / ((double)ranking.getNumberOfRanks() - 1.0);
        this.setIndifferenceThreshold(initialThreshold);
        this.solve_NewImplementation(ranking, criteria);
        this.setIndifferenceThreshold(initialThreshold / 2.0);
        this.solve_NewImplementation(ranking, criteria);
        this.setIndifferenceThreshold(0.0);
        this.solve_NewImplementation(ranking, criteria);
        return this.bestFunctions;
    }

    LinearFunction[] solve_OldImplementation(Ranking<Alternative> ranking, List<Criterion> criteria) {
        List<Alternative> alternatives = ranking.getAlternatives();
        LinearFunction[] functions = this.createResultFunctions(criteria);
        WVariablesRepresentation[] wReps = this.createWVariablesRepresentations(alternatives, functions);
        List<LinearConstraint> constraints = this.prepareConstraints(wReps, ranking);
        int wOffset = wReps[0].getFlattenedCoefficients().length;
        double[] objectiveCoefficients = new double[wOffset + alternatives.size() * 2];
        int i = wOffset;
        while (i < objectiveCoefficients.length) {
            objectiveCoefficients[i] = 1.0;
            ++i;
        }
        LinearObjectiveFunction objectiveFunction = new LinearObjectiveFunction(objectiveCoefficients, 0.0);
        SimplexSolver optimizer = new SimplexSolver();
        try {
            RealPointValuePair solution = optimizer.optimize(objectiveFunction, constraints, GoalType.MINIMIZE, true);
            this.populateFunctions(functions, solution);
        }
        catch (OptimizationException e) {
            this.handleOptimizationException(e);
        }
        return functions;
    }

    LinearFunction[] solve_NewImplementation(Ranking<Alternative> ranking, List<Criterion> criteria) {
        List<Alternative> alternatives = ranking.getAlternatives();
        LinearFunction[] functions = this.createResultFunctions(criteria);
        WVariablesRepresentation[] wReps = this.createWVariablesRepresentations(alternatives, functions);
        List<LinearConstraint> constraints = this.prepareConstraints(wReps, ranking);
        int wOffset = wReps[0].getFlattenedCoefficients().length;
        double[] objectiveCoefficients = new double[wOffset + alternatives.size() * 2];
        int i = wOffset;
        while (i < objectiveCoefficients.length) {
            objectiveCoefficients[i] = 1.0;
            ++i;
        }
        LinearObjectiveFunction objectiveFunction = new LinearObjectiveFunction(objectiveCoefficients, 0.0);
        SimplexSolver optimizer = new SimplexSolver();
        try {
            RealPointValuePair solution = optimizer.optimize(objectiveFunction, constraints, GoalType.MINIMIZE, true);
            this.populateFunctions(functions, solution);
            this.checkKendall(ranking, functions);
            double distance = solution.getValue() + 0.1 * solution.getValue();
            LinearFunction[] optimizedFunctions = this.doPostOptimalAnalysis(distance, wReps, constraints, alternatives, criteria);
            this.checkKendall(ranking, optimizedFunctions);
        }
        catch (OptimizationException e) {
            this.handleOptimizationException(e);
        }
        return this.bestFunctions;
    }

    private void checkKendall(Ranking<Alternative> ranking, LinearFunction[] functions) {
        Ranking<Alternative> rankFromUtil = this.buildRank(functions, ranking.getAlternatives());
        double kendallsCoefficient = RANKING_UTILS.getKendallsCoefficient(ranking, rankFromUtil);
        if (kendallsCoefficient > this.bestKendall) {
            this.bestFunctions = functions;
            this.bestKendall = kendallsCoefficient;
        }
    }

    private void setIndifferenceThreshold(double value) {
        this.indifferenceThreshold = value;
    }

    LinearFunction[] doPostOptimalAnalysis(double searchDistance, WVariablesRepresentation[] wReps, List<LinearConstraint> constraints, List<Alternative> alternatives, List<Criterion> criteria) {
        int j;
        int numberOfLinearFunctions = wReps[0].getCoefficients().length;
        LinearFunction[] result = this.createResultFunctions(criteria);
        RealPointValuePair[] intermediateSolutions = new RealPointValuePair[numberOfLinearFunctions];
        int wOffset = wReps[0].getFlattenedCoefficients().length;
        int numberOfAllCoefficients = wOffset + alternatives.size() * 2;
        double[] coefficients = new double[numberOfAllCoefficients];
        int i = wOffset;
        while (i < coefficients.length) {
            coefficients[i] = 1.0;
            ++i;
        }
        LinearConstraint additionalConstraint = new LinearConstraint(coefficients, Relationship.LEQ, searchDistance);
        constraints.add(additionalConstraint);
        int offset = 0;
        int i2 = 0;
        while (i2 < numberOfLinearFunctions) {
            double[] objectiveCoefficients = new double[numberOfAllCoefficients];
            j = offset;
            j = offset;
            while (j < offset + wReps[0].getCoefficients()[i2].length) {
                objectiveCoefficients[j] = 1.0;
                ++j;
            }
            offset = j;
            LinearObjectiveFunction objectiveFunction = new LinearObjectiveFunction(objectiveCoefficients, 0.0);
            try {
                intermediateSolutions[i2] = new SimplexSolver().optimize(objectiveFunction, constraints, GoalType.MAXIMIZE, true);
            }
            catch (OptimizationException e) {
                this.handleOptimizationException(e);
            }
            ++i2;
        }
        double[] d = new double[numberOfAllCoefficients];
        int i3 = 0;
        while (i3 < numberOfLinearFunctions) {
            j = 0;
            while (j < wOffset) {
                int n = j;
                d[n] = d[n] + intermediateSolutions[i3].getPoint()[j];
                ++j;
            }
            ++i3;
        }
        int j2 = 0;
        while (j2 < wOffset) {
            int n = j2++;
            d[n] = d[n] / (double)numberOfLinearFunctions;
        }
        RealPointValuePair solution = new RealPointValuePair(d, -1.0);
        this.populateFunctions(result, solution);
        return result;
    }

    private void handleOptimizationException(OptimizationException e) {
        throw new RuntimeException("Simplex solver has thrown an OptimizationException, this should never happen and indicates an error in the program", e);
    }

    private void populateFunctions(LinearFunction[] functions, RealPointValuePair solution) {
        int varOffset = 0;
        int i = 0;
        while (i < functions.length) {
            double increment = 0.0;
            int j = 1;
            while (j < functions[i].getNoOfPoints()) {
                functions[i].addValue(increment += solution.getPoint()[varOffset], j);
                ++j;
                ++varOffset;
            }
            ++i;
        }
    }

    private LinearFunction[] createResultFunctions(List<Criterion> criteria) {
        LinearFunction[] functions = new LinearFunction[criteria.size()];
        int i = 0;
        while (i < criteria.size()) {
            functions[i] = new LinearFunction(criteria.get(i));
            ++i;
        }
        return functions;
    }

    List<LinearConstraint> prepareConstraints(WVariablesRepresentation[] wReps, Ranking<Alternative> ranking) {
        ArrayList<LinearConstraint> result = new ArrayList<LinearConstraint>();
        List<Alternative> alts = ranking.getAlternatives();
        int wCoefficientsCount = wReps[0].getFlattenedCoefficients().length;
        double[] errorCoefficients = new double[]{-1.0, 1.0, 1.0, -1.0};
        int errorCoefficientsCount = alts.size() * 2;
        int i = 0;
        while (i < alts.size()) {
            Alternative successor = ranking.getSuccessor(alts.get(i));
            if (successor != null) {
                int errorCoefficientsOffset;
                double[] coefficients = new double[wCoefficientsCount + errorCoefficientsCount];
                Double[] firstAlternativeCoefficients = wReps[i].getFlattenedCoefficients();
                Double[] secondAlternativeCoefficients = wReps[i + 1].getFlattenedCoefficients();
                int j = 0;
                while (j < wCoefficientsCount) {
                    coefficients[j] = firstAlternativeCoefficients[j] - secondAlternativeCoefficients[j];
                    ++j;
                }
                int j2 = errorCoefficientsOffset = wCoefficientsCount + 2 * i;
                int k = 0;
                while (j2 < errorCoefficientsOffset + errorCoefficients.length) {
                    coefficients[j2] = errorCoefficients[k];
                    ++j2;
                    ++k;
                }
                if (ranking.sameRank(alts.get(i), successor)) {
                    result.add(new LinearConstraint(coefficients, Relationship.EQ, 0.0));
                } else {
                    result.add(new LinearConstraint(coefficients, Relationship.GEQ, this.indifferenceThreshold));
                }
            }
            ++i;
        }
        double[] lastConstraint = new double[wCoefficientsCount + errorCoefficientsCount];
        int i2 = 0;
        while (i2 < wCoefficientsCount) {
            lastConstraint[i2] = 1.0;
            ++i2;
        }
        result.add(new LinearConstraint(lastConstraint, Relationship.EQ, 1.0));
        return result;
    }

    private WVariablesRepresentation[] createWVariablesRepresentations(List<Alternative> alternatives, LinearFunction[] functions) {
        MarginalValuesRepresentation[] mvReps = new MarginalValuesRepresentation[alternatives.size()];
        WVariablesRepresentation[] wvReps = new WVariablesRepresentation[alternatives.size()];
        int i = 0;
        while (i < alternatives.size()) {
            mvReps[i] = new MarginalValuesRepresentation(alternatives.get(i), functions);
            wvReps[i] = new WVariablesRepresentation(mvReps[i].getCoefficients());
            ++i;
        }
        return wvReps;
    }

    Ranking<Alternative> buildRank(LinearFunction[] functions, List<Alternative> alts) {
        return this.buildRank(functions, alts.toArray(new Alternative[0]));
    }

    public Ranking<Alternative> buildRank(LinearFunction[] functions, Alternative[] alts) {
        return RANKING_UTILS.buildRank(functions, alts);
    }

    public double getGeneralUtil(LinearFunction[] functions, Alternative alternative) {
        return alternative.getGeneralUtil(functions);
    }
}

