/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import utafx.Constraint;
import utafx.LinearFunction;
import utafx.Point;
import utafx.StandardConstraintsManager;

public class StandardConstraintsManagerTest {
    private static final double PRECISION = 1.0E-4;

    @Test
    public void testConstraintsManager_simpleTest() {
        LinearFunction f1 = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.4, 0.6}, null);
        LinearFunction f2 = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.3, 0.4}, null);
        LinearFunction[] functions = new LinearFunction[]{f1, f2};
        StandardConstraintsManager tested = new StandardConstraintsManager(functions);
        List<Point> points = f1.getPoints();
        Constraint c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.6, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.4, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)c.getUpperBound(), (double)1.0E-4);
        points = f2.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.4, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.6, (double)c.getUpperBound(), (double)1.0E-4);
    }

    @Test
    public void testConstraintsManager_sophisticatedTest() {
        LinearFunction f1 = new LinearFunction(new double[]{21.0, 9.0}, new double[]{0.0, 0.3}, null);
        LinearFunction f2 = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.3, 0.4}, null);
        LinearFunction f3 = new LinearFunction(new double[]{2.0, 9.0, 15.0}, new double[]{0.1, 0.3, 0.3}, null);
        LinearFunction[] functions = new LinearFunction[]{f1, f2, f3};
        StandardConstraintsManager tested = new StandardConstraintsManager(functions);
        List<Point> points = f1.getPoints();
        Constraint c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.4, (double)c.getUpperBound(), (double)1.0E-4);
        points = f2.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.4, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)c.getUpperBound(), (double)1.0E-4);
        points = f3.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.1, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)c.getUpperBound(), (double)1.0E-4);
    }

    @Test
    public void testUpdate_increaseBest() {
        LinearFunction f1 = new LinearFunction(new double[]{21.0, 9.0}, new double[]{0.0, 0.3}, null);
        LinearFunction f2 = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.3, 0.4}, null);
        LinearFunction f3 = new LinearFunction(new double[]{2.0, 9.0, 15.0}, new double[]{0.0, 0.3, 0.3}, null);
        LinearFunction[] functions = new LinearFunction[]{f1, f2, f3};
        StandardConstraintsManager tested = new StandardConstraintsManager(functions);
        Point f2BestPoint = f2.getBestPoint();
        f2BestPoint.setY(0.6);
        tested.update(f2, f2BestPoint);
        Assert.assertEquals((double)0.1, (double)f1.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.6, (double)f2BestPoint.getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)f3.getBestPoint().getY(), (double)1.0E-4);
        List<Point> points = f1.getPoints();
        Constraint c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.4, (double)c.getUpperBound(), (double)1.0E-4);
        points = f2.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.6, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)c.getUpperBound(), (double)1.0E-4);
        points = f3.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)c.getUpperBound(), (double)1.0E-4);
    }

    @Test
    public void testUpdate_increaseBest02() {
        LinearFunction f1 = new LinearFunction(new double[]{21.0, 9.0}, new double[]{0.0, 0.3}, null);
        LinearFunction f2 = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.3, 0.4}, null);
        LinearFunction f3 = new LinearFunction(new double[]{2.0, 9.0, 15.0}, new double[]{0.0, 0.2, 0.3}, null);
        LinearFunction[] functions = new LinearFunction[]{f1, f2, f3};
        StandardConstraintsManager tested = new StandardConstraintsManager(functions);
        Point f2BestPoint = f2.getBestPoint();
        f2BestPoint.setY(0.6);
        tested.update(f2, f2BestPoint);
        Assert.assertEquals((double)0.2, (double)f1.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.6, (double)f2BestPoint.getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.2, (double)f3.getBestPoint().getY(), (double)1.0E-4);
        List<Point> points = f1.getPoints();
        Constraint c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)c.getUpperBound(), (double)1.0E-4);
        points = f2.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.6, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.6, (double)points.get(2).getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.8, (double)c.getUpperBound(), (double)1.0E-4);
        points = f3.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.2, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.2, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)c.getUpperBound(), (double)1.0E-4);
    }

    @Test
    public void testUpdate_decreaseBest() {
        LinearFunction f1 = new LinearFunction(new double[]{21.0, 9.0}, new double[]{0.0, 0.3}, null);
        LinearFunction f2 = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.3, 0.4}, null);
        LinearFunction f3 = new LinearFunction(new double[]{2.0, 9.0, 15.0}, new double[]{0.0, 0.2, 0.3}, null);
        LinearFunction[] functions = new LinearFunction[]{f1, f2, f3};
        StandardConstraintsManager tested = new StandardConstraintsManager(functions);
        Point f2BestPoint = f2.getBestPoint();
        f2BestPoint.setY(0.35);
        tested.update(f2, f2BestPoint);
        Assert.assertEquals((double)0.325, (double)f1.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.35, (double)f2BestPoint.getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.325, (double)f3.getBestPoint().getY(), (double)1.0E-4);
        List<Point> points = f1.getPoints();
        Constraint c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)c.getUpperBound(), (double)1.0E-4);
        points = f2.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.35, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.35, (double)f2.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.8, (double)c.getUpperBound(), (double)1.0E-4);
        points = f3.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.325, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.2, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)c.getUpperBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.325, (double)f3.getBestPoint().getY(), (double)1.0E-4);
    }

    @Test
    public void testUpdate_increaseBest03() {
        LinearFunction f1 = new LinearFunction(new double[]{21.0, 9.0}, new double[]{0.0, 0.3}, null);
        LinearFunction f2 = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.1, 0.4}, null);
        LinearFunction f3 = new LinearFunction(new double[]{2.0, 9.0, 15.0}, new double[]{0.0, 0.2, 0.3}, null);
        LinearFunction[] functions = new LinearFunction[]{f1, f2, f3};
        StandardConstraintsManager tested = new StandardConstraintsManager(functions);
        Point f2BestPoint = f2.getBestPoint();
        f2BestPoint.setY(0.7);
        tested.update(f2, f2BestPoint);
        Assert.assertEquals((double)0.1, (double)f1.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)f2BestPoint.getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.2, (double)f3.getBestPoint().getY(), (double)1.0E-4);
    }

    @Test
    public void testUpdate_increaseBest04() {
        LinearFunction f1 = new LinearFunction(new double[]{21.0, 9.0}, new double[]{0.0, 0.1}, null);
        LinearFunction f2 = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.1, 0.4}, null);
        LinearFunction f3 = new LinearFunction(new double[]{2.0, 9.0, 15.0}, new double[]{0.0, 0.2, 0.3}, null);
        LinearFunction f4 = new LinearFunction(new double[]{2.0, 9.0, 15.0}, new double[]{0.0, 0.2, 0.2}, null);
        LinearFunction[] functions = new LinearFunction[]{f1, f2, f3, f4};
        StandardConstraintsManager tested = new StandardConstraintsManager(functions);
        Point f2BestPoint = f2.getBestPoint();
        f2BestPoint.setY(0.6);
        tested.update(f2, f2BestPoint);
        Assert.assertEquals((double)0.0, (double)f1.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.6, (double)f2BestPoint.getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.2, (double)f3.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.2, (double)f4.getBestPoint().getY(), (double)1.0E-4);
    }

    @Test
    public void testUpdate_increaseMiddle() {
        LinearFunction f1 = new LinearFunction(new double[]{21.0, 9.0}, new double[]{0.0, 0.3}, null);
        LinearFunction f2 = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.3, 0.4}, null);
        LinearFunction f3 = new LinearFunction(new double[]{2.0, 9.0, 15.0}, new double[]{0.0, 0.3, 0.3}, null);
        LinearFunction[] functions = new LinearFunction[]{f1, f2, f3};
        StandardConstraintsManager tested = new StandardConstraintsManager(functions);
        Point f2MiddlePoint = f2.getPoints().get(1);
        f2MiddlePoint.setY(0.35);
        tested.update(f2, f2MiddlePoint);
        Assert.assertEquals((double)0.3, (double)f1.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.4, (double)f2.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)f3.getBestPoint().getY(), (double)1.0E-4);
        List<Point> points = f1.getPoints();
        Constraint c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.35, (double)c.getUpperBound(), (double)1.0E-4);
        points = f2.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.4, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.35, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)c.getUpperBound(), (double)1.0E-4);
        points = f3.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.65, (double)c.getUpperBound(), (double)1.0E-4);
    }

    @Test
    public void testUpdate_decreaseMiddle4Segments() {
        LinearFunction f1 = new LinearFunction(new double[]{21.0, 9.0}, new double[]{0.0, 0.3}, null);
        LinearFunction f2 = new LinearFunction(new double[]{21.0, 9.0, 5.0, 1.0}, new double[]{0.0, 0.3, 0.4, 0.4}, null);
        LinearFunction f3 = new LinearFunction(new double[]{2.0, 9.0, 15.0}, new double[]{0.0, 0.3, 0.3}, null);
        LinearFunction[] functions = new LinearFunction[]{f1, f2, f3};
        StandardConstraintsManager tested = new StandardConstraintsManager(functions);
        Point f2MiddlePoint = f2.getPoints().get(2);
        f2MiddlePoint.setY(0.35);
        tested.update(f2, f2MiddlePoint);
        Assert.assertEquals((double)0.3, (double)f1.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.4, (double)f2.getBestPoint().getY(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)f3.getBestPoint().getY(), (double)1.0E-4);
        List<Point> points = f1.getPoints();
        Constraint c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.35, (double)c.getUpperBound(), (double)1.0E-4);
        points = f2.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.35, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.4, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(3));
        Assert.assertEquals((double)0.35, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.7, (double)c.getUpperBound(), (double)1.0E-4);
        points = f3.getPoints();
        c = tested.getConstraintFor(points.get(0));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(1));
        Assert.assertEquals((double)0.0, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)c.getUpperBound(), (double)1.0E-4);
        c = tested.getConstraintFor(points.get(2));
        Assert.assertEquals((double)0.3, (double)c.getLowerBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.65, (double)c.getUpperBound(), (double)1.0E-4);
    }
}

