/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import utafx.AbstractConstraintsManager;
import utafx.Constraint;
import utafx.LinearFunction;
import utafx.Point;

class StandardConstraintsManager
extends AbstractConstraintsManager {
    private static final double PRECISION = 1.0E-12;

    StandardConstraintsManager(LinearFunction[] functions) {
        super(functions);
        this.buildConstraints();
    }

    protected void updateOrCreateConstraint(Map<Point, Constraint> constraints, Point p, double lowerBound, double upperBound) {
        Constraint constraint = constraints.get(p);
        if (constraint == null) {
            constraints.put(p, new Constraint(p, lowerBound, upperBound));
        } else {
            constraint.setLowerBound(lowerBound);
            constraint.setUpperBound(upperBound);
        }
    }

    protected void buildConstraints() {
        LinearFunction f;
        LinearFunction[] linearFunctionArray = this.functions;
        int n = this.functions.length;
        int n2 = 0;
        while (n2 < n) {
            f = linearFunctionArray[n2];
            for (Point p : f.getPoints()) {
                double upperBound;
                double lowerBound;
                Point betterNeighbor = f.getBetterNeighbor(p);
                Point worseNeighbor = f.getWorseNeighbor(p);
                if (worseNeighbor == null) {
                    lowerBound = 0.0;
                    upperBound = 0.0;
                } else if (betterNeighbor == null) {
                    lowerBound = worseNeighbor.getY();
                    upperBound = p.getY();
                } else {
                    upperBound = betterNeighbor.getY();
                    lowerBound = worseNeighbor.getY();
                }
                this.updateOrCreateConstraint(this.constraints, p, lowerBound, upperBound);
            }
            ++n2;
        }
        linearFunctionArray = this.functions;
        n = this.functions.length;
        n2 = 0;
        while (n2 < n) {
            Point p;
            f = linearFunctionArray[n2];
            p = f.getBestPoint();
            double upperBound = this.calculateUpperBound(f);
            ((Constraint)this.constraints.get(p)).setUpperBound(upperBound);
            ++n2;
        }
    }

    private double calculateUpperBound(LinearFunction currentFun) {
        double upperBound = 1.0;
        LinearFunction[] linearFunctionArray = this.functions;
        int n = this.functions.length;
        int n2 = 0;
        while (n2 < n) {
            LinearFunction f = linearFunctionArray[n2];
            if (!currentFun.equals(f)) {
                upperBound -= ((Constraint)this.constraints.get(f.getBestPoint())).getLowerBound();
            }
            ++n2;
        }
        return upperBound;
    }

    @Override
    public void update(LinearFunction function, Point changedPoint) {
        Point betterNeighbor = function.getBetterNeighbor(changedPoint);
        Point worseNeighbor = function.getWorseNeighbor(changedPoint);
        if (worseNeighbor == null) {
            throw new RuntimeException("Changing value of the point with worst evaluation is not permitted!");
        }
        if (betterNeighbor == null) {
            if (function.getWorseNeighbor(worseNeighbor) != null) {
                ((Constraint)this.constraints.get(worseNeighbor)).setUpperBound(changedPoint.getY());
            }
            this.doBestPointUpdate(function, this.functions, true, this.constraints);
        } else {
            Constraint c = null;
            if (function.getWorseNeighbor(worseNeighbor) != null) {
                c = (Constraint)this.constraints.get(worseNeighbor);
                c.setUpperBound(changedPoint.getY());
            }
            c = (Constraint)this.constraints.get(betterNeighbor);
            c.setLowerBound(changedPoint.getY());
            if (function.getBetterNeighbor(betterNeighbor) == null) {
                LinearFunction[] linearFunctionArray = this.functions;
                int n = this.functions.length;
                int n2 = 0;
                while (n2 < n) {
                    LinearFunction f = linearFunctionArray[n2];
                    if (!f.equals(function)) {
                        double upperBound = this.calculateUpperBound(f);
                        ((Constraint)this.constraints.get(f.getBestPoint())).setUpperBound(upperBound);
                    }
                    ++n2;
                }
            }
        }
    }

    void doBestPointUpdate(LinearFunction function, LinearFunction[] functions, boolean modifyConstraints, Map<Point, Constraint> constraints) {
        double sumOfAllBestPointsValues = 0.0;
        LinearFunction[] linearFunctionArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            LinearFunction f = linearFunctionArray[n2];
            sumOfAllBestPointsValues += f.getBestPoint().getY();
            ++n2;
        }
        this.compensate(function, functions, sumOfAllBestPointsValues, modifyConstraints, constraints);
    }

    void compensate(LinearFunction function, LinearFunction[] functions, double sumOfAllBestPointsValues, boolean modifyConstraints, Map<Point, Constraint> constraints) {
        double missingValue = sumOfAllBestPointsValues - 1.0;
        ArrayList<LinearFunction> funcs = new ArrayList<LinearFunction>();
        funcs.addAll(Arrays.asList(functions));
        while (Math.abs(missingValue) > 1.0E-12) {
            missingValue = this.subtractMissingValue(funcs, function, missingValue, modifyConstraints, constraints);
        }
    }

    double subtractMissingValue(List<LinearFunction> funcs, LinearFunction function, double missingValue, boolean modifyConstraints, Map<Point, Constraint> constraints) {
        int divisor = funcs.size() > 1 ? funcs.size() - 1 : 1;
        double singleModificationSize = Math.abs(missingValue / (double)divisor);
        ArrayList<LinearFunction> toRemove = new ArrayList<LinearFunction>();
        for (LinearFunction f : funcs) {
            if (f.equals(function)) continue;
            Point p = f.getBestPoint();
            Constraint c = constraints.get(p);
            if (missingValue < 0.0) {
                if (singleModificationSize < c.getUpperBound() - p.getY()) {
                    p.setY(p.getY() + singleModificationSize);
                    missingValue += singleModificationSize;
                } else {
                    missingValue += c.getUpperBound() - p.getY();
                    p.setY(c.getUpperBound());
                    toRemove.add(f);
                }
            } else if (singleModificationSize < p.getY() - c.getLowerBound()) {
                p.setY(p.getY() - singleModificationSize);
                missingValue -= singleModificationSize;
            } else {
                missingValue -= p.getY() - c.getLowerBound();
                p.setY(c.getLowerBound());
                toRemove.add(f);
            }
            Point worseNeighbor = f.getWorseNeighbor(p);
            if (!modifyConstraints || f.getWorseNeighbor(worseNeighbor) == null) continue;
            constraints.get(worseNeighbor).setUpperBound(p.getY());
        }
        funcs.removeAll(toRemove);
        return missingValue;
    }
}

