/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;
import utafx.Alternative;
import utafx.Criterion;
import utafx.LinearFunction;
import utafx.Ranking;
import utafx.RankingUtils;

public class RankingUtilsTest {
    @Test
    public void test1() {
        RankingUtils tested = new RankingUtils();
        Alternative bus = new Alternative(null, null, null);
        Alternative metro1 = new Alternative(null, null, null);
        Alternative rer = new Alternative(null, null, null);
        Ranking<Alternative> rankRef = new Ranking<Alternative>(new double[]{1.0, 2.0, 3.0}, bus, rer, metro1);
        Ranking<Alternative> rank2 = new Ranking<Alternative>(new double[]{1.0, 2.0, 3.0}, bus, rer, metro1);
        double result = tested.getKendallsCoefficient(rankRef, rank2);
        Assert.assertEquals((Object)result, (Object)1.0);
    }

    @Test
    public void test2() {
        RankingUtils tested = new RankingUtils();
        Alternative bus = new Alternative(null, null, null);
        Alternative metro1 = new Alternative(null, null, null);
        Alternative rer = new Alternative(null, null, null);
        Ranking<Alternative> rankRef = new Ranking<Alternative>(new double[]{1.0, 2.0, 3.0}, bus, rer, metro1);
        Ranking<Alternative> rank2 = new Ranking<Alternative>(new double[]{3.0, 2.0, 1.0}, bus, rer, metro1);
        double result = tested.getKendallsCoefficient(rankRef, rank2);
        Assert.assertEquals((Object)result, (Object)-1.0);
    }

    @Test
    public void test3_irrelevantOrder() {
        RankingUtils tested = new RankingUtils();
        Alternative bus = new Alternative(null, null, null);
        Alternative metro1 = new Alternative(null, null, null);
        Alternative rer = new Alternative(null, null, null);
        Ranking<Alternative> rankRef = new Ranking<Alternative>(new double[]{1.0, 2.0, 3.0}, bus, metro1, rer);
        Ranking<Alternative> rank2 = new Ranking<Alternative>(new double[]{1.0, 3.0, 2.0}, bus, rer, metro1);
        double result = tested.getKendallsCoefficient(rankRef, rank2);
        Assert.assertEquals((Object)result, (Object)1.0);
    }

    @Test
    public void testBuildRank() {
        RankingUtils tested = new RankingUtils();
        Criterion price = new Criterion(30.0, 2.0, 2);
        Criterion time = new Criterion(40.0, 10.0, 3);
        Criterion comfort = new Criterion(0.0, 3.0, 3);
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(price);
        criteria.add(time);
        criteria.add(comfort);
        Alternative rer = new Alternative(new double[]{3.0, 10.0, 1.0}, criteria);
        Alternative metro1 = new Alternative(new double[]{4.0, 20.0, 2.0}, criteria);
        Alternative metro2 = new Alternative(new double[]{2.0, 20.0, 0.0}, criteria);
        Alternative metro3 = new Alternative(new double[]{2.0, 20.0, 0.0}, criteria);
        Alternative bus = new Alternative(new double[]{6.0, 40.0, 0.0}, criteria);
        Alternative taxi = new Alternative(new double[]{30.0, 30.0, 3.0}, criteria);
        double[][] expecteds = new double[][]{{0.0, 0.5, 0.5}, {0.0, 0.05, 0.05, 0.1}, {0.0, 0.0, 0.0, 0.4}};
        LinearFunction f1 = new LinearFunction(new double[]{30.0, 16.0, 2.0}, new double[]{0.0, 0.5, 0.5}, price);
        LinearFunction f2 = new LinearFunction(new double[]{40.0, 30.0, 20.0, 10.0}, new double[]{0.0, 0.05, 0.05, 0.1}, time);
        LinearFunction f3 = new LinearFunction(new double[]{0.0, 1.0, 2.0, 3.0}, new double[]{0.0, 0.0, 0.0, 0.4}, comfort);
        Ranking<Alternative> result = tested.buildRank(new LinearFunction[]{f1, f2, f3}, new Alternative[]{metro3, bus, taxi, rer, metro2, metro1});
        Assert.assertEquals((Object)1.0, (Object)result.getRank(rer));
        Assert.assertEquals((Object)2.0, (Object)result.getRank(metro1));
        Assert.assertEquals((Object)2.0, (Object)result.getRank(metro2));
        Assert.assertEquals((Object)2.0, (Object)result.getRank(metro3));
        Assert.assertEquals((Object)3.0, (Object)result.getRank(bus));
        Assert.assertEquals((Object)4.0, (Object)result.getRank(taxi));
    }
}

