/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import utafx.Alternative;
import utafx.LinearFunction;
import utafx.Pair;
import utafx.Ranking;

public class RankingUtils {
    private static final Comparator<Alternative> COMPARATOR = new Comparator<Alternative>(){

        @Override
        public int compare(Alternative o1, Alternative o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public double getKendallsCoefficient(Ranking<Alternative> referenceRank, Ranking<Alternative> finalRank) {
        return this.getCoefficient(referenceRank, finalRank);
    }

    public double getCoefficient(Ranking<Alternative> rankRef, Ranking<Alternative> rankFromUtil) {
        List<Alternative> alternatives = rankRef.getAlternatives();
        List<Alternative> alternativesFromUtil = rankFromUtil.getAlternatives();
        this.stripRank(rankFromUtil, alternatives, alternativesFromUtil);
        Collections.sort(alternatives, COMPARATOR);
        Collections.sort(alternativesFromUtil, COMPARATOR);
        int matrixSize = alternatives.size();
        double[][] matrix1 = new double[matrixSize][matrixSize];
        this.populateMatrix(rankRef, alternatives, matrix1);
        double[][] matrix2 = new double[matrixSize][matrixSize];
        this.populateMatrix(rankFromUtil, alternativesFromUtil, matrix2);
        double sum = 0.0;
        int i = 0;
        while (i < matrix2.length) {
            int j = 0;
            while (j < matrix2.length) {
                sum += Math.abs(matrix1[i][j] - matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        double result = 1.0 - 4.0 * (0.5 * sum / (double)(matrixSize * (matrixSize - 1)));
        return result;
    }

    private void stripRank(Ranking<Alternative> rankFromUtil, List<Alternative> alternatives, List<Alternative> alternativesFromUtil) {
        List<Alternative> copyOfalternativesFromUtil = rankFromUtil.getAlternatives();
        for (Alternative alt : copyOfalternativesFromUtil) {
            if (alternatives.contains(alt)) continue;
            alternativesFromUtil.remove(alt);
        }
    }

    private void populateMatrix(Ranking<Alternative> rank, List<Alternative> alternatives, double[][] matrix) {
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix.length) {
                matrix[i][j] = i == j || rank.getRank(alternatives.get(j)) > rank.getRank(alternatives.get(i)) ? 0.0 : (rank.getRank(alternatives.get(j)) == rank.getRank(alternatives.get(i)) ? 0.5 : 1.0);
                ++j;
            }
            ++i;
        }
    }

    public Ranking<Alternative> buildRank(LinearFunction[] functions, List<Alternative> alts) {
        return this.buildRank(functions, alts.toArray(new Alternative[alts.size()]));
    }

    public Ranking<Alternative> buildRank(LinearFunction[] functions, Alternative[] alts) {
        TreeSet<Pair<Alternative, Double>> altsAndUtils = new TreeSet<Pair<Alternative, Double>>(new Comparator<Pair<Alternative, Double>>(){

            @Override
            public int compare(Pair<Alternative, Double> o1, Pair<Alternative, Double> o2) {
                int result = Double.compare(o2.getSecond(), o1.getSecond());
                if (result == 0) {
                    return 1;
                }
                return result;
            }
        });
        Alternative[] alternativeArray = alts;
        int n = alts.length;
        int n2 = 0;
        while (n2 < n) {
            Alternative alternative = alternativeArray[n2];
            double util = alternative.getGeneralUtil(functions);
            altsAndUtils.add(new Pair<Alternative, Double>(alternative, util));
            ++n2;
        }
        Iterator iterator = altsAndUtils.iterator();
        Alternative[] alts2 = new Alternative[alts.length];
        double[] ranking = new double[alts.length];
        double prevUtil = 2.0;
        int rank = 0;
        int i = 0;
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            pair.getFirst();
            if ((Double)pair.getSecond() < prevUtil) {
                ++rank;
                prevUtil = (Double)pair.getSecond();
            }
            ranking[i] = rank;
            alts2[i] = (Alternative)pair.getFirst();
            ++i;
        }
        return new Ranking<Alternative>(ranking, alts2);
    }
}

