/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import utafx.Pair;

public class Ranking<T> {
    private List<Pair<T, Double>> pairs = new ArrayList<Pair<T, Double>>();

    public Ranking() {
    }

    public Ranking(double[] ranking, T ... alts) {
        this();
        int i = 0;
        while (i < alts.length) {
            this.pairs.add(new Pair<T, Double>(alts[i], ranking[i]));
            ++i;
        }
    }

    public List<T> getAlternatives() {
        ArrayList<T> result = new ArrayList<T>();
        int i = 0;
        while (i < this.pairs.size()) {
            result.add(this.pairs.get(i).getFirst());
            ++i;
        }
        return result;
    }

    public T getSuccessor(T alternative) {
        double rankOfCurrent = this.getRank(alternative);
        T result = null;
        double previousRank = 9.223372036854776E18;
        boolean currentPassed = false;
        int i = 0;
        while (i < this.pairs.size()) {
            Pair<T, Double> processed = this.pairs.get(i);
            if (!processed.getFirst().equals(alternative)) {
                if (currentPassed) {
                    if (processed.getSecond() >= rankOfCurrent && processed.getSecond() < previousRank) {
                        previousRank = processed.getSecond();
                        result = processed.getFirst();
                    }
                } else if (processed.getSecond() > rankOfCurrent && processed.getSecond() < previousRank) {
                    previousRank = processed.getSecond();
                    result = processed.getFirst();
                }
            } else {
                currentPassed = true;
            }
            ++i;
        }
        return result;
    }

    public boolean sameRank(T alt1, T alt2) {
        return this.getRank(alt1) == this.getRank(alt2);
    }

    public double getRank(T a) {
        int i = 0;
        while (i < this.pairs.size()) {
            if (this.pairs.get(i).getFirst().equals(a)) {
                return this.pairs.get(i).getSecond();
            }
            ++i;
        }
        return -1.0;
    }

    public int getNumberOfRanks() {
        HashSet<Double> set = new HashSet<Double>();
        for (Pair<T, Double> pair : this.pairs) {
            set.add(pair.getSecond());
        }
        return set.size();
    }

    public void add(T t, double rank) {
        this.pairs.add(new Pair<T, Double>(t, rank));
    }

    public String toString() {
        Collections.sort(this.pairs, new Comparator<Pair<T, Double>>(){

            @Override
            public int compare(Pair<T, Double> o1, Pair<T, Double> o2) {
                return o1.getSecond().compareTo(o2.getSecond());
            }
        });
        StringBuilder out = new StringBuilder();
        for (Pair<T, Double> p : this.pairs) {
            out.append(p.getFirst().toString());
            out.append(" ");
            out.append(p.getSecond().toString());
            out.append("\n");
        }
        return out.toString();
    }
}

