/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.Arrays;
import java.util.List;
import utafx.Alternative;
import utafx.LinearFunction;

class MarginalValuesRepresentation {
    private final Alternative alternative;
    private final List<LinearFunction> functions;
    private final double[][] coefficients;

    public MarginalValuesRepresentation(Alternative alternative, LinearFunction[] functions) {
        this(alternative, Arrays.asList(functions));
    }

    public MarginalValuesRepresentation(Alternative alternative, List<LinearFunction> functions) {
        this.alternative = alternative;
        this.functions = functions;
        this.coefficients = new double[functions.size()][];
        this.create();
    }

    private void create() {
        int i = 0;
        while (i < this.functions.size()) {
            this.coefficients[i] = new double[this.functions.get(i).getNoOfPoints()];
            ++i;
        }
        i = 0;
        while (i < this.functions.size()) {
            LinearFunction currentFunction = this.functions.get(i);
            double evaluation = this.alternative.getValueOn(currentFunction.getCriterion());
            Double[] charPoints = currentFunction.getCharacteristicPoints();
            boolean increasingFunction = currentFunction.isIncreasing();
            int j = 0;
            while (j < charPoints.length) {
                double interval;
                if (evaluation == charPoints[j]) {
                    this.coefficients[i][j] = 1.0;
                    break;
                }
                if (increasingFunction) {
                    if (evaluation < charPoints[j]) {
                        interval = charPoints[j] - charPoints[j - 1];
                        this.coefficients[i][j - 1] = 1.0 - (evaluation - charPoints[j - 1]) / interval;
                        this.coefficients[i][j] = (evaluation - charPoints[j]) / interval;
                    }
                } else if (evaluation > charPoints[j]) {
                    interval = charPoints[j - 1] - charPoints[j];
                    this.coefficients[i][j - 1] = (evaluation - charPoints[j]) / interval;
                    this.coefficients[i][j] = (charPoints[j - 1] - evaluation) / interval;
                }
                ++j;
            }
            ++i;
        }
    }

    double[][] getCoefficients() {
        return this.coefficients;
    }
}

