/*
 * Decompiled with CFR 0.152.
 */
package utafx;

public class Criterion {
    private String name;
    private double worstValue;
    private double bestValue;
    private int noOfSegments;
    private Boolean isGain;

    public Criterion(String name, boolean isGain, int noOfSegents) {
        this(noOfSegents, isGain);
        this.name = name;
    }

    public Criterion(int noOfSegments, boolean gain) {
        this.noOfSegments = noOfSegments;
        this.isGain = gain;
    }

    public Criterion(double worstValue, double bestValue, int noOfSegments) {
        this.worstValue = worstValue;
        this.bestValue = bestValue;
        this.noOfSegments = noOfSegments;
    }

    public Criterion(String name, double worstValue, double bestValue, int noOfSegments) {
        this.worstValue = worstValue;
        this.bestValue = bestValue;
        this.noOfSegments = noOfSegments;
        this.name = name;
    }

    public Criterion(String name, int noOfSegments, boolean isGain) {
        this(name, isGain, noOfSegments);
    }

    public int getNoOfSegments() {
        return this.noOfSegments;
    }

    public double getWorstValue() {
        return this.worstValue;
    }

    public double getBestValue() {
        return this.bestValue;
    }

    public void setBestValue(double value) {
        this.bestValue = value;
    }

    public void setWorstValue(double value) {
        this.worstValue = value;
    }

    public boolean isGain() {
        if (this.isGain == null) {
            this.isGain = this.bestValue > this.worstValue;
            return this.isGain;
        }
        return this.isGain;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.bestValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isGain == null ? 0 : this.isGain.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.noOfSegments;
        temp = Double.doubleToLongBits(this.worstValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Criterion other = (Criterion)obj;
        if (Double.doubleToLongBits(this.bestValue) != Double.doubleToLongBits(other.bestValue)) {
            return false;
        }
        if (this.isGain == null ? other.isGain != null : !this.isGain.equals(other.isGain)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.noOfSegments != other.noOfSegments) {
            return false;
        }
        return Double.doubleToLongBits(this.worstValue) == Double.doubleToLongBits(other.worstValue);
    }
}

