/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import utafx.Alternative;
import utafx.ConstantKendallConstraintsManager;
import utafx.Constraint;
import utafx.Criterion;
import utafx.IUtaSolver;
import utafx.LinearFunction;
import utafx.Ranking;
import utafx.RankingUtils;
import utafx.StandardConstraintsManager;
import utafx.UtaStarSolver;

public class ConstantKendallConstraintsManagerTest {
    private static final double PRECISION = 1.0E-10;
    private static IUtaSolver starSolver;
    private static Ranking<Alternative> referenceRank;
    private static Alternative[] alts;
    private static Criterion[] criteria;
    private LinearFunction[] functions;

    @BeforeClass
    public static void init() {
        starSolver = new UtaStarSolver();
        Criterion price = new Criterion("price", 2, false);
        Criterion time = new Criterion("time", 3, false);
        Criterion comfort = new Criterion("comfort", 3, true);
        criteria = new Criterion[]{price, time, comfort};
        Alternative rer = new Alternative(new double[]{3.0, 10.0, 1.0}, criteria);
        Alternative metro1 = new Alternative(new double[]{4.0, 20.0, 2.0}, criteria);
        Alternative metro2 = new Alternative(new double[]{2.0, 20.0, 0.0}, criteria);
        Alternative bus = new Alternative(new double[]{6.0, 40.0, 0.0}, criteria);
        Alternative taxi = new Alternative(new double[]{30.0, 30.0, 3.0}, criteria);
        alts = new Alternative[]{rer, metro1, metro2, bus, taxi};
        referenceRank = new Ranking<Alternative>(new double[]{1.0, 2.0, 2.0, 3.0, 4.0}, rer, metro1, metro2, bus, taxi);
    }

    @Before
    public void setUp() {
        this.functions = starSolver.solve(referenceRank, criteria, alts);
    }

    @After
    public void tearDown() {
        this.functions = null;
    }

    @Test
    public void testOverallFunctionality_WithoutConstraintsOfBestPoints() {
        Ranking<Alternative> finalRank = new RankingUtils().buildRank(this.functions, alts);
        ConstantKendallConstraintsManager tested = new ConstantKendallConstraintsManager(this.functions, referenceRank, finalRank);
        StandardConstraintsManager mgr = new StandardConstraintsManager(this.functions);
        LinearFunction[] linearFunctionArray = this.functions;
        int n = this.functions.length;
        int n2 = 0;
        while (n2 < n) {
            LinearFunction linearFunction = linearFunctionArray[n2];
            Constraint constraint = mgr.getConstraintFor(linearFunction.getPoints().get(0));
            junit.framework.Assert.assertEquals((Object)0.0, (Object)constraint.getLowerBound());
            junit.framework.Assert.assertEquals((Object)0.0, (Object)constraint.getUpperBound());
            constraint = tested.getConstraintFor(linearFunction.getPoints().get(0));
            junit.framework.Assert.assertEquals((Object)0.0, (Object)constraint.getLowerBound());
            junit.framework.Assert.assertEquals((Object)0.0, (Object)constraint.getUpperBound());
            ++n2;
        }
        Constraint stdConstraint = mgr.getConstraintFor(mgr.functions[0].getPoints().get(1));
        Constraint constKendallConstraint = tested.getConstraintFor(tested.functions[0].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.333333333333333, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((Object)stdConstraint.getUpperBound(), (Object)constKendallConstraint.getUpperBound());
        constKendallConstraint = tested.getConstraintFor(tested.functions[2].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[2].getPoints().get(2));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[1].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.33333333333333, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[1].getPoints().get(2));
        junit.framework.Assert.assertEquals((double)5.0E-15, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.666666666666666, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
    }

    @Test
    public void testOverallFunctionality_OnlyBestPoints() {
        Ranking<Alternative> finalRank = new RankingUtils().buildRank(this.functions, alts);
        ConstantKendallConstraintsManager tested = new ConstantKendallConstraintsManager(this.functions, referenceRank, finalRank);
        Assert.assertEquals((double)0.333333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.333333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.666666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333333, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getUpperBound(), (double)1.0E-10);
    }

    @Test
    public void testUpdate_BestPoint() {
        Ranking<Alternative> finalRank = new RankingUtils().buildRank(this.functions, alts);
        ConstantKendallConstraintsManager tested = new ConstantKendallConstraintsManager(this.functions, referenceRank, finalRank);
        Assert.assertEquals((double)0.3333333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333333, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getUpperBound(), (double)1.0E-10);
        this.functions[2].getBestPoint().setY(0.1);
        tested.update(this.functions[2], this.functions[2].getBestPoint());
        Assert.assertEquals((double)0.566666666666666, (double)this.functions[1].getBestPoint().getY(), (double)1.0E-10);
        Assert.assertEquals((double)0.1, (double)this.functions[2].getBestPoint().getY(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.5666666666666667, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.1, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333333, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getUpperBound(), (double)1.0E-10);
    }

    @Test
    public void testUpdate_MiddlePoint() {
        Ranking<Alternative> finalRank = new RankingUtils().buildRank(this.functions, alts);
        ConstantKendallConstraintsManager tested = new ConstantKendallConstraintsManager(this.functions, referenceRank, finalRank);
        Assert.assertEquals((double)0.3333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.666666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.666666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333333, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getUpperBound(), (double)1.0E-10);
        this.functions[1].getPoints().get(2).setY(0.1);
        tested.update(this.functions[1], this.functions[1].getPoints().get(2));
        Assert.assertEquals((double)0.333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getUpperBound(), (double)1.0E-10);
        LinearFunction[] linearFunctionArray = this.functions;
        int n = this.functions.length;
        int n2 = 0;
        while (n2 < n) {
            LinearFunction linearFunction = linearFunctionArray[n2];
            Constraint constraint = tested.getConstraintFor(linearFunction.getPoints().get(0));
            junit.framework.Assert.assertEquals((Object)0.0, (Object)constraint.getLowerBound());
            junit.framework.Assert.assertEquals((Object)0.0, (Object)constraint.getUpperBound());
            ++n2;
        }
        Constraint constKendallConstraint = tested.getConstraintFor(tested.functions[0].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.3333333333333, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[2].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[2].getPoints().get(2));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[1].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.1, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[1].getPoints().get(2));
        junit.framework.Assert.assertEquals((double)1.0E-15, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.66666666666666, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
    }

    @Test
    public void testUpdate_MiddlePoint_SetValueAndRestorePrevious() {
        Ranking<Alternative> finalRank = new RankingUtils().buildRank(this.functions, alts);
        ConstantKendallConstraintsManager tested = new ConstantKendallConstraintsManager(this.functions, referenceRank, finalRank);
        Constraint[] constraintsBefore = tested.getConstraints();
        Assert.assertEquals((double)0.333333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.333333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.666666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.666666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.333333333333333, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getUpperBound(), (double)1.0E-10);
        double previousValue = this.functions[1].getPoints().get(2).getY();
        this.functions[1].getPoints().get(2).setY(0.1);
        tested.update(this.functions[1], this.functions[1].getPoints().get(2));
        Assert.assertEquals((double)0.3333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.3333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.66666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.333333333333333, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getUpperBound(), (double)1.0E-10);
        LinearFunction[] linearFunctionArray = this.functions;
        int n = this.functions.length;
        int n2 = 0;
        while (n2 < n) {
            LinearFunction linearFunction = linearFunctionArray[n2];
            Constraint constraint = tested.getConstraintFor(linearFunction.getPoints().get(0));
            junit.framework.Assert.assertEquals((Object)0.0, (Object)constraint.getLowerBound());
            junit.framework.Assert.assertEquals((Object)0.0, (Object)constraint.getUpperBound());
            ++n2;
        }
        Constraint constKendallConstraint = tested.getConstraintFor(tested.functions[0].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.333333333333, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[2].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[2].getPoints().get(2));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[1].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.1, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[1].getPoints().get(2));
        junit.framework.Assert.assertEquals((double)1.0E-15, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.666666666666666, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        this.functions[1].getPoints().get(2).setY(previousValue);
        tested.update(this.functions[1], this.functions[1].getPoints().get(2));
        Assert.assertEquals((double)0.33333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.33333333333333, (double)tested.getConstraintFor(this.functions[0].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.66666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.66666666666666, (double)tested.getConstraintFor(this.functions[1].getBestPoint()).getUpperBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getLowerBound(), (double)1.0E-10);
        Assert.assertEquals((double)0.33333333333333, (double)tested.getConstraintFor(this.functions[2].getBestPoint()).getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[0].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.3333333333333, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[2].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[2].getPoints().get(2));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[1].getPoints().get(1));
        junit.framework.Assert.assertEquals((double)0.0, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.33333333333333, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        constKendallConstraint = tested.getConstraintFor(tested.functions[1].getPoints().get(2));
        junit.framework.Assert.assertEquals((double)5.0E-14, (double)constKendallConstraint.getLowerBound(), (double)1.0E-10);
        junit.framework.Assert.assertEquals((double)0.66666666666666, (double)constKendallConstraint.getUpperBound(), (double)1.0E-10);
        Constraint[] constraintsAfter = tested.getConstraints();
        int i = 0;
        while (i < constraintsBefore.length) {
            junit.framework.Assert.assertEquals((Object)constraintsBefore[i], (Object)constraintsAfter[i]);
            ++i;
        }
    }
}

