/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.utils;

import java.util.HashMap;
import org.xmcda.utils.IValueConverter;
import org.xmcda.value.Rational;

public class ValueConverters {
    private static HashMap<Class, HashMap<Class, IValueConverter>> converters = new HashMap();

    public static <SOURCE, DESTINATION> void register(Class<SOURCE> srcClass, Class<DESTINATION> dstClass, IValueConverter<SOURCE, DESTINATION> converter) {
        HashMap srcMap = converters.get(srcClass);
        if (srcMap == null) {
            srcMap = new HashMap();
            converters.put(srcClass, srcMap);
        }
        srcMap.put(dstClass, converter);
    }

    public static <SOURCE, DESTINATION> IValueConverter<SOURCE, DESTINATION> get(Class<SOURCE> srcClass, Class<DESTINATION> dstClass) throws NoConverterError {
        if (srcClass == dstClass) {
            return new IdentityConverter();
        }
        IValueConverter converter = null;
        try {
            converter = converters.get(srcClass).get(dstClass);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (converter == null) {
            throw new NoConverterError(srcClass + " to: " + dstClass);
        }
        return converter;
    }

    public static <SOURCE, DESTINATION> DESTINATION convert(SOURCE object, Class<DESTINATION> dstClass) throws ConversionException {
        return ValueConverters.get(object.getClass(), dstClass).convert(object);
    }

    static {
        ValueConverters.register(String.class, Double.class, new StringToDoubleConverter());
        ValueConverters.register(Integer.class, Double.class, new IntegerToDoubleConverter());
        ValueConverters.register(String.class, Integer.class, new StringToIntegerConverter());
        ValueConverters.register(Rational.class, Double.class, new RationalToDoubleConverter());
    }

    public static class RationalToDoubleConverter
    implements IValueConverter<Rational, Double> {
        @Override
        public Double convert(Rational object) throws ConversionException {
            try {
                int denominator = object.getDenominator();
                if (denominator == 0) {
                    throw new ConversionException("Rational denominator is zero");
                }
                return ((Number)object.getDenominator()).doubleValue() / ((Number)object.getDenominator()).doubleValue();
            }
            catch (NullPointerException e) {
                throw new ConversionError(e);
            }
        }
    }

    public static class IntegerToDoubleConverter
    implements IValueConverter<Integer, Double> {
        @Override
        public Double convert(Integer object) throws ConversionException {
            try {
                return object.doubleValue();
            }
            catch (NullPointerException e) {
                throw new ConversionError(e);
            }
        }
    }

    public static class StringToIntegerConverter
    implements IValueConverter<String, Integer> {
        @Override
        public Integer convert(String object) throws ConversionException {
            try {
                return Integer.parseInt(object);
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new ConversionError(e);
            }
        }
    }

    public static class StringToDoubleConverter
    implements IValueConverter<String, Double> {
        @Override
        public Double convert(String object) throws ConversionException {
            try {
                return Double.parseDouble(object);
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new ConversionError(e);
            }
        }
    }

    public static class IdentityConverter
    implements IValueConverter {
        public Object convert(Object object) throws ConversionException {
            return object;
        }
    }

    public static class NoConverterError
    extends ConversionException {
        private static final long serialVersionUID = 1L;

        public NoConverterError() {
        }

        public NoConverterError(String message) {
            super(message);
        }

        public NoConverterError(Throwable cause) {
            super(cause);
        }

        public NoConverterError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ConversionError
    extends ConversionException {
        private static final long serialVersionUID = 1L;

        public ConversionError() {
        }

        public ConversionError(String message) {
            super(message);
        }

        public ConversionError(Throwable cause) {
            super(cause);
        }

        public ConversionError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ConversionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ConversionException() {
        }

        public ConversionException(String message) {
            super(message);
        }

        public ConversionException(Throwable cause) {
            super(cause);
        }

        public ConversionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

