/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;

public class XMLStreamWriter
implements javax.xml.stream.XMLStreamWriter {
    private javax.xml.stream.XMLStreamWriter writer;
    private int indent_level = 0;
    private String indent_str = "\t";
    private boolean mayIndent = false;

    public XMLStreamWriter(javax.xml.stream.XMLStreamWriter proxiedXMLStreamWriter) {
        this.writer = proxiedXMLStreamWriter;
    }

    public void increaseIndentLevel() {
        ++this.indent_level;
    }

    public void decreaseIndentLevel() {
        if (this.indent_level > 0) {
            --this.indent_level;
        }
    }

    protected String indentation() {
        if (this.indent_level == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(this.indent_level * this.indent_str.length());
        for (int i = 0; i < this.indent_level; ++i) {
            sb.append(this.indent_str);
        }
        return sb.toString();
    }

    public void writeIndentation() throws XMLStreamException {
        if (this.mayIndent) {
            this.writeCharacters(this.indentation());
        }
        this.mayIndent = false;
    }

    public void writeNonNullAttribute(String localName, String value) throws XMLStreamException {
        if (value != null) {
            this.writeAttribute(localName, value);
        }
    }

    public void writeElementChars(String localName, String string) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeCharacters(string);
        this.writeEndElement();
        this.writeln();
    }

    public void writeElementBoolean(String localName, boolean value) throws XMLStreamException {
        this.writeStartElement(localName);
        if (value) {
            this.writeCharacters("true");
        } else {
            this.writeCharacters("false");
        }
        this.writeEndElement();
        this.writeln();
    }

    public void writeln() throws XMLStreamException {
        this.writeCharacters("\n");
        this.mayIndent = true;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeStartElement(localName);
        this.increaseIndentLevel();
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeStartElement(namespaceURI, localName);
        this.increaseIndentLevel();
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeStartElement(prefix, localName, namespaceURI);
        this.increaseIndentLevel();
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.decreaseIndentLevel();
        this.writeIndentation();
        this.writer.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.writer.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.writer.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.writer.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writer.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writer.getProperty(name);
    }
}

