/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.QualifiedValue;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.FuzzyNumberParser;
import org.xmcda.parsers.xml.xmcda_v3.IntervalParser;
import org.xmcda.parsers.xml.xmcda_v3.RationalParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.ValuedLabelParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;
import org.xmcda.value.FuzzyNumber;
import org.xmcda.value.Interval;
import org.xmcda.value.NA;
import org.xmcda.value.Rational;
import org.xmcda.value.ValuedLabel;

public class ValueParser<VALUE_TYPE> {
    public VALUE_TYPE fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        String initialTag = startElement.getName().getLocalPart();
        FuzzyNumber<?, ?> value = null;
        XMLEvent event = startElement;
        while (!(!eventReader.hasNext() || event.isEndElement() && initialTag.equals(event.asEndElement().getName().getLocalPart()) || value != null)) {
            if (!event.isStartElement()) {
                event = eventReader.nextEvent();
                continue;
            }
            String currentTag = event.asStartElement().getName().getLocalPart();
            if (QualifiedValue.XMCDATypes.INTEGER.getTag().equals(currentTag)) {
                value = Integer.parseInt(Utils.getTextContent(startElement, eventReader));
                continue;
            }
            if (QualifiedValue.XMCDATypes.REAL.getTag().equals(currentTag)) {
                value = Double.parseDouble(Utils.getTextContent(startElement, eventReader));
                continue;
            }
            if (QualifiedValue.XMCDATypes.INTERVAL.getTag().equals(currentTag)) {
                value = new IntervalParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (QualifiedValue.XMCDATypes.RATIONAL.getTag().equals(currentTag)) {
                value = new RationalParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (QualifiedValue.XMCDATypes.LABEL.getTag().equals(currentTag)) {
                value = Utils.getTextContent(startElement, eventReader);
                continue;
            }
            if (QualifiedValue.XMCDATypes.VALUED_LABEL.getTag().equals(currentTag)) {
                value = new ValuedLabelParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (QualifiedValue.XMCDATypes.BOOLEAN.getTag().equals(currentTag)) {
                String s = Utils.getTextContent(startElement, eventReader);
                value = s != null && ("true".equals(s) || "1".equals(s));
                continue;
            }
            if (QualifiedValue.XMCDATypes.NA.getTag().equals(currentTag)) {
                value = NA.na;
                continue;
            }
            if (QualifiedValue.XMCDATypes.FUZZY_NUMBER.getTag().equals(currentTag)) {
                value = new FuzzyNumberParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            event = eventReader.nextEvent();
        }
        return (VALUE_TYPE)value;
    }

    public <T> void toXML(T value, XMLStreamWriter writer) throws XMLStreamException {
        if (value == null) {
            return;
        }
        if (value instanceof Integer) {
            this.writeInteger((Integer)value, writer);
        } else if (value instanceof Double) {
            this.writeReal((Double)value, writer);
        } else if (value instanceof Float) {
            this.writeReal((Float)value, writer);
        } else if (value instanceof Interval) {
            this.writeInterval((Interval)value, writer);
        } else if (value instanceof Rational) {
            this.writeRational((Rational)value, writer);
        } else if (value instanceof String) {
            this.writeLabel((String)value, writer);
        } else if (value instanceof ValuedLabel) {
            this.writeValuedLabel((ValuedLabel)value, writer);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value, writer);
        } else if (value instanceof NA) {
            this.writeNA((NA)value, writer);
        } else if (value instanceof FuzzyNumber) {
            this.writeFuzzyNumber((FuzzyNumber)value, writer);
        } else {
            throw new RuntimeException("Unknown type: " + value.getClass());
        }
    }

    protected void writeInteger(Integer i, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeElementChars(QualifiedValue.XMCDATypes.INTEGER.getTag(), i.toString());
    }

    protected void writeReal(Double d, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeElementChars(QualifiedValue.XMCDATypes.REAL.getTag(), d.toString());
    }

    protected void writeReal(Float f, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeElementChars(QualifiedValue.XMCDATypes.REAL.getTag(), f.toString());
    }

    protected void writeInterval(Interval<?> interval, XMLStreamWriter writer) throws XMLStreamException {
        new IntervalParser().toXML(interval, writer);
    }

    protected void writeRational(Rational rational, XMLStreamWriter writer) throws XMLStreamException {
        new RationalParser().toXML(rational, writer);
    }

    protected void writeLabel(String label, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeElementChars(QualifiedValue.XMCDATypes.LABEL.getTag(), label);
    }

    protected void writeValuedLabel(ValuedLabel<?> valuedLabel, XMLStreamWriter writer) throws XMLStreamException {
        new ValuedLabelParser().toXML(valuedLabel, writer);
    }

    protected void writeBoolean(Boolean bool, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeElementChars(QualifiedValue.XMCDATypes.BOOLEAN.getTag(), bool != false ? "true" : "false");
    }

    protected void writeNA(NA na, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEmptyElement(QualifiedValue.XMCDATypes.NA.getTag());
        writer.writeln();
    }

    protected void writeFuzzyNumber(FuzzyNumber<?, ?> fuzzyNumber, XMLStreamWriter writer) throws XMLStreamException {
        new FuzzyNumberParser().toXML(fuzzyNumber, writer);
    }
}

