/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.xmcda.CommonAttributes;
import org.xmcda.Referenceable;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class ReferenceableParser {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String MCDA_CONCEPT = "mcdaConcept";

    public CommonAttributes getAttributes(StartElement startElement) {
        ReferenceableAttributeHolder holder = new ReferenceableAttributeHolder();
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            new ReferenceableParser().handleAttribute(holder, attribute);
        }
        return holder;
    }

    public boolean handleAttribute(CommonAttributes obj, Attribute attribute) {
        String attributeName = attribute.getName().toString();
        if (ID.equals(attributeName)) {
            obj.setId(attribute.getValue());
            return true;
        }
        if (MCDA_CONCEPT.equals(attributeName)) {
            obj.setMcdaConcept(attribute.getValue());
            return true;
        }
        if (NAME.equals(attributeName)) {
            obj.setName(attribute.getValue());
            return true;
        }
        return false;
    }

    public void toXML(Referenceable obj, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeNonNullAttribute(ID, obj.id());
        writer.writeNonNullAttribute(NAME, obj.name());
        writer.writeNonNullAttribute(MCDA_CONCEPT, obj.mcdaConcept());
    }

    private static final class ReferenceableAttributeHolder
    implements CommonAttributes {
        private String id;
        private String name;
        private String mcdaConcept;

        private ReferenceableAttributeHolder() {
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String mcdaConcept() {
            return this.mcdaConcept;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void setMcdaConcept(String mcdaConcept) {
            this.mcdaConcept = mcdaConcept;
        }
    }
}

